/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

class PeerFixer
implements AdjustmentListener,
Serializable {
    private static final long serialVersionUID = 7051237413532574756L;
    private ScrollPane scroller;

    PeerFixer(ScrollPane scroller) {
        this.scroller = scroller;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Adjustable adj = e.getAdjustable();
        int value = e.getValue();
        ScrollPanePeer peer = (ScrollPanePeer)this.scroller.peer;
        if (peer != null) {
            peer.setValue(adj, value);
        }
        Component c = this.scroller.getComponent(0);
        switch (adj.getOrientation()) {
            case 1: {
                c.move(c.getLocation().x, -value);
                break;
            }
            case 0: {
                c.move(-value, c.getLocation().y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal adjustable orientation");
            }
        }
    }
}

