/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.SSLContextSpi;
import com.sun.net.ssl.SSLSecurity;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509KeyManagerJavaxWrapper;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.X509TrustManagerJavaxWrapper;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

final class SSLContextSpiWrapper
extends SSLContextSpi {
    private SSLContext theSSLContext;

    SSLContextSpiWrapper(String algName, Provider prov) throws NoSuchAlgorithmException {
        this.theSSLContext = SSLContext.getInstance(algName, prov);
    }

    protected void engineInit(KeyManager[] kma, TrustManager[] tma, SecureRandom sr) throws KeyManagementException {
        Object[] tmaw;
        int src;
        int dst;
        Object[] kmaw;
        if (kma != null) {
            kmaw = new javax.net.ssl.KeyManager[kma.length];
            dst = 0;
            for (src = 0; src < kma.length; ++src) {
                if (!(kma[src] instanceof javax.net.ssl.KeyManager)) {
                    if (!(kma[src] instanceof X509KeyManager)) continue;
                    kmaw[dst] = new X509KeyManagerJavaxWrapper((X509KeyManager)kma[src]);
                    ++dst;
                    continue;
                }
                kmaw[dst] = (javax.net.ssl.KeyManager)((Object)kma[src]);
                ++dst;
            }
            if (dst != src) {
                kmaw = (javax.net.ssl.KeyManager[])SSLSecurity.truncateArray(kmaw, new javax.net.ssl.KeyManager[dst]);
            }
        } else {
            kmaw = null;
        }
        if (tma != null) {
            tmaw = new javax.net.ssl.TrustManager[tma.length];
            dst = 0;
            for (src = 0; src < tma.length; ++src) {
                if (!(tma[src] instanceof javax.net.ssl.TrustManager)) {
                    if (!(tma[src] instanceof X509TrustManager)) continue;
                    tmaw[dst] = new X509TrustManagerJavaxWrapper((X509TrustManager)tma[src]);
                    ++dst;
                    continue;
                }
                tmaw[dst] = (javax.net.ssl.TrustManager)((Object)tma[src]);
                ++dst;
            }
            if (dst != src) {
                tmaw = (javax.net.ssl.TrustManager[])SSLSecurity.truncateArray(tmaw, new javax.net.ssl.TrustManager[dst]);
            }
        } else {
            tmaw = null;
        }
        this.theSSLContext.init((javax.net.ssl.KeyManager[])kmaw, (javax.net.ssl.TrustManager[])tmaw, sr);
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return this.theSSLContext.getSocketFactory();
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.theSSLContext.getServerSocketFactory();
    }
}

