/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public class SoftAudioBuffer {
    private int size;
    private float[] buffer;
    private boolean empty = true;
    private AudioFormat format;
    private AudioFloatConverter converter;
    private byte[] converter_buffer;

    public SoftAudioBuffer(int size, AudioFormat format) {
        this.size = size;
        this.format = format;
        this.converter = AudioFloatConverter.getConverter(format);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        if (!this.empty) {
            Arrays.fill(this.buffer, 0.0f);
            this.empty = true;
        }
    }

    public boolean isSilent() {
        return this.empty;
    }

    public float[] array() {
        this.empty = false;
        if (this.buffer == null) {
            this.buffer = new float[this.size];
        }
        return this.buffer;
    }

    public void get(byte[] buffer, int channel) {
        int framesize_pc = this.format.getFrameSize() / this.format.getChannels();
        int c_len = this.size * framesize_pc;
        if (this.converter_buffer == null || this.converter_buffer.length < c_len) {
            this.converter_buffer = new byte[c_len];
        }
        if (this.format.getChannels() == 1) {
            this.converter.toByteArray(this.array(), this.size, buffer);
        } else {
            this.converter.toByteArray(this.array(), this.size, this.converter_buffer);
            if (channel >= this.format.getChannels()) {
                return;
            }
            int z_stepover = this.format.getChannels() * framesize_pc;
            int k_stepover = framesize_pc;
            for (int j = 0; j < framesize_pc; ++j) {
                int k = j;
                int z = channel * framesize_pc + j;
                for (int i = 0; i < this.size; ++i) {
                    buffer[z] = this.converter_buffer[k];
                    z += z_stepover;
                    k += k_stepover;
                }
            }
        }
    }
}

