/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.AudioPermission;
import sun.misc.Service;

class JSSecurityManager {
    private JSSecurityManager() {
    }

    private static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AudioPermission("record"));
        }
    }

    static void loadLibrary(final String libName) {
        if (JSSecurityManager.hasSecurityManager()) {
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary(libName);
                    return null;
                }
            };
            AccessController.doPrivileged(action);
        } else {
            System.loadLibrary(libName);
        }
    }

    static String getProperty(final String propertyName) {
        String propertyValue;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty(propertyName);
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    }
                };
                propertyValue = (String)AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                propertyValue = System.getProperty(propertyName);
            }
        } else {
            propertyValue = System.getProperty(propertyName);
        }
        return propertyValue;
    }

    static void loadProperties(final Properties properties, final String filename) {
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        JSSecurityManager.loadPropertiesImpl(properties, filename);
                        return null;
                    }
                };
                AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                JSSecurityManager.loadPropertiesImpl(properties, filename);
            }
        } else {
            JSSecurityManager.loadPropertiesImpl(properties, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadPropertiesImpl(Properties properties, String filename) {
        String fname = System.getProperty("java.home");
        try {
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, filename);
            fname = f.getCanonicalPath();
            FileInputStream in = new FileInputStream(fname);
            BufferedInputStream bin = new BufferedInputStream(in);
            try {
                properties.load(bin);
                Object var7_7 = null;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup topmostThreadGroup;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return JSSecurityManager.getTopmostThreadGroupImpl();
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    }
                };
                topmostThreadGroup = (ThreadGroup)AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                topmostThreadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
            }
        } else {
            topmostThreadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
        }
        return topmostThreadGroup;
    }

    private static ThreadGroup getTopmostThreadGroupImpl() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null && g.getParent().getParent() != null) {
            g = g.getParent();
        }
        return g;
    }

    static Thread createThread(final Runnable runnable, final String threadName, final boolean isDaemon, final int priority, final boolean doStart) {
        Thread thread = null;
        if (JSSecurityManager.hasSecurityManager()) {
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    try {
                        return JSSecurityManager.createThreadImpl(runnable, threadName, isDaemon, priority, doStart);
                    }
                    catch (Throwable t) {
                        return null;
                    }
                }
            };
            thread = (Thread)AccessController.doPrivileged(action);
        } else {
            thread = JSSecurityManager.createThreadImpl(runnable, threadName, isDaemon, priority, doStart);
        }
        return thread;
    }

    private static Thread createThreadImpl(Runnable runnable, String threadName, boolean isDaemon, int priority, boolean doStart) {
        ThreadGroup threadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
        Thread thread = new Thread(threadGroup, runnable);
        if (threadName != null) {
            thread.setName(threadName);
        }
        thread.setDaemon(isDaemon);
        if (priority >= 0) {
            thread.setPriority(priority);
        }
        if (doStart) {
            thread.start();
        }
        return thread;
    }

    static List getProviders(final Class providerClass) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                ArrayList p = new ArrayList();
                Iterator ps = Service.providers(providerClass);
                while (ps.hasNext()) {
                    try {
                        Object provider = ps.next();
                        if (!providerClass.isInstance(provider)) continue;
                        p.add(0, provider);
                    }
                    catch (Throwable throwable) {}
                }
                return p;
            }
        };
        List providers = (List)AccessController.doPrivileged(action);
        return providers;
    }
}

