/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibAgentMBean;
import com.sun.jmx.snmp.agent.SnmpMibHandler;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.agent.SnmpMibRequestImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpMibAgent
implements SnmpMibAgentMBean,
MBeanRegistration,
Serializable {
    protected String mibName;
    protected MBeanServer server;
    private ObjectName adaptorName;
    private transient SnmpMibHandler adaptor;

    public abstract void init() throws IllegalAccessException;

    @Override
    public abstract ObjectName preRegister(MBeanServer var1, ObjectName var2) throws Exception;

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public abstract void get(SnmpMibRequest var1) throws SnmpStatusException;

    @Override
    public abstract void getNext(SnmpMibRequest var1) throws SnmpStatusException;

    @Override
    public abstract void getBulk(SnmpMibRequest var1, int var2, int var3) throws SnmpStatusException;

    @Override
    public abstract void set(SnmpMibRequest var1) throws SnmpStatusException;

    @Override
    public abstract void check(SnmpMibRequest var1) throws SnmpStatusException;

    public abstract long[] getRootOid();

    @Override
    public MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public SnmpMibHandler getSnmpAdaptor() {
        return this.adaptor;
    }

    @Override
    public void setSnmpAdaptor(SnmpMibHandler stack) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    @Override
    public void setSnmpAdaptor(SnmpMibHandler stack, SnmpOid[] oids) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, oids);
        }
    }

    @Override
    public void setSnmpAdaptor(SnmpMibHandler stack, String contextName) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, contextName);
        }
    }

    @Override
    public void setSnmpAdaptor(SnmpMibHandler stack, String contextName, SnmpOid[] oids) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, contextName, oids);
        }
    }

    @Override
    public ObjectName getSnmpAdaptorName() {
        return this.adaptorName;
    }

    @Override
    public void setSnmpAdaptorName(ObjectName name) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] params = new Object[]{this};
        String[] signature = new String[]{"com.sun.jmx.snmp.agent.SnmpMibAgent"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    @Override
    public void setSnmpAdaptorName(ObjectName name, SnmpOid[] oids) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] params = new Object[]{this, oids};
        String[] signature = new String[]{"com.sun.jmx.snmp.agent.SnmpMibAgent", oids.getClass().getName()};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    @Override
    public void setSnmpAdaptorName(ObjectName name, String contextName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        Object[] params = new Object[]{this, contextName};
        String[] signature = new String[]{"com.sun.jmx.snmp.agent.SnmpMibAgent", "java.lang.String"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    @Override
    public void setSnmpAdaptorName(ObjectName name, String contextName, SnmpOid[] oids) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        Object[] params = new Object[]{this, contextName, oids};
        String[] signature = new String[]{"com.sun.jmx.snmp.agent.SnmpMibAgent", "java.lang.String", oids.getClass().getName()};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    @Override
    public boolean getBindingState() {
        return this.adaptor != null;
    }

    @Override
    public String getMibName() {
        return this.mibName;
    }

    public static SnmpMibRequest newMibRequest(SnmpPdu reqPdu, Vector<SnmpVarBind> vblist, int version, Object userData) {
        return new SnmpMibRequestImpl(null, reqPdu, vblist, version, userData, null, 0, SnmpMibAgent.getSecurityModel(version), null, null);
    }

    public static SnmpMibRequest newMibRequest(SnmpEngine engine, SnmpPdu reqPdu, Vector<SnmpVarBind> vblist, int version, Object userData, String principal, int securityLevel, int securityModel, byte[] contextName, byte[] accessContextName) {
        return new SnmpMibRequestImpl(engine, reqPdu, vblist, version, userData, principal, securityLevel, securityModel, contextName, accessContextName);
    }

    void getBulkWithGetNext(SnmpMibRequest req, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        Vector<SnmpVarBind> list = req.getSubList();
        int L = list.size();
        int N = Math.max(Math.min(nonRepeat, L), 0);
        int M = Math.max(maxRepeat, 0);
        int R = L - N;
        if (L != 0) {
            this.getNext(req);
            Vector<SnmpVarBind> repeaters = this.splitFrom(list, N);
            SnmpMibRequestImpl repeatedReq = new SnmpMibRequestImpl(req.getEngine(), req.getPdu(), repeaters, 220, req.getUserData(), req.getPrincipal(), req.getSecurityLevel(), req.getSecurityModel(), req.getContextName(), req.getAccessContextName());
            for (int i = 2; i <= M; ++i) {
                this.getNext(repeatedReq);
                this.concatVector(req, repeaters);
            }
        }
    }

    private Vector<SnmpVarBind> splitFrom(Vector<SnmpVarBind> original, int limit) {
        int max = original.size();
        Vector<SnmpVarBind> result = new Vector<SnmpVarBind>(max - limit);
        int i = limit;
        Enumeration<SnmpVarBind> e = original.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            if (i <= 0) {
                result.addElement(new SnmpVarBind(var.oid, var.value));
            }
            --i;
        }
        return result;
    }

    private void concatVector(SnmpMibRequest req, Vector source) {
        Enumeration e = source.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            req.addVarBind(new SnmpVarBind(var.oid, var.value));
        }
    }

    private void concatVector(Vector<SnmpVarBind> target, Vector<SnmpVarBind> source) {
        Enumeration<SnmpVarBind> e = source.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            target.addElement(new SnmpVarBind(var.oid, var.value));
        }
    }

    private static int getSecurityModel(int version) {
        switch (version) {
            case 330: {
                return 650;
            }
        }
        return 560;
    }
}

