/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.JDMSecurityDefs;
import com.sun.jmx.snmp.IPAcl.ParseException;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.PermissionImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.snmp.InetAddressAcl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpAcl
implements InetAddressAcl,
Serializable {
    private static final long serialVersionUID = -6702287103824397063L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable<InetAddress, Vector<String>> trapDestList;
    private Hashtable<InetAddress, Vector<String>> informDestList;
    private PrincipalImpl owner;

    public SnmpAcl(String Owner2) throws UnknownHostException, IllegalArgumentException {
        this(Owner2, null);
    }

    public SnmpAcl(String Owner2, String aclFileName) throws UnknownHostException, IllegalArgumentException {
        block4: {
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, Owner2);
                AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
                ownEntry.addPermission(READ);
                ownEntry.addPermission(WRITE);
                this.acl.addEntry(this.owner, ownEntry);
            }
            catch (NotOwnerException ex) {
                if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) break block4;
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "SnmpAcl(String,String)", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (aclFileName == null) {
            this.setDefaultFileName();
        } else {
            this.setAuthorizedListFile(aclFileName);
        }
        this.readAuthorizedListFile();
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public Enumeration<String> communities() {
        HashSet<String> set = new HashSet<String>();
        Vector<String> res = new Vector<String>();
        Enumeration<AclEntry> e = this.acl.entries();
        while (e.hasMoreElements()) {
            AclEntryImpl entry = (AclEntryImpl)e.nextElement();
            Enumeration<String> cs = entry.communities();
            while (cs.hasMoreElements()) {
                set.add(cs.nextElement());
            }
        }
        String[] objs = set.toArray(new String[0]);
        for (int i = 0; i < objs.length; ++i) {
            res.addElement(objs[i]);
        }
        return res.elements();
    }

    @Override
    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public static String getDefaultAclFileName() {
        String fileSeparator = System.getProperty("file.separator");
        StringBuffer defaultAclName = new StringBuffer(System.getProperty("java.home")).append(fileSeparator).append("lib").append(fileSeparator).append("snmp.acl");
        return defaultAclName.toString();
    }

    public void setAuthorizedListFile(String filename) throws IllegalArgumentException {
        File file = new File(filename);
        if (!file.isFile()) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "setAuthorizedListFile", "ACL file not found: " + filename);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] " + "doesn't exist or is not a file, " + "no configuration loaded");
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "setAuthorizedListFile", "Default file set to " + filename);
        }
        this.authorizedListFile = filename;
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl ownEntry = new AclEntryImpl(this.owner);
        ownEntry.addPermission(READ);
        ownEntry.addPermission(WRITE);
        this.acl.addEntry(this.owner, ownEntry);
        this.readAuthorizedListFile();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    @Override
    public boolean checkReadPermission(InetAddress address) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, READ);
    }

    @Override
    public boolean checkReadPermission(InetAddress address, String community) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, community, READ);
    }

    @Override
    public boolean checkCommunity(String community) {
        return this.acl.checkCommunity(community);
    }

    @Override
    public boolean checkWritePermission(InetAddress address) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, WRITE);
    }

    @Override
    public boolean checkWritePermission(InetAddress address, String community) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl p = new PrincipalImpl(address);
        return this.acl.checkPermission(p, community, WRITE);
    }

    @Override
    public Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    @Override
    public Enumeration getTrapCommunities(InetAddress i) {
        Vector<String> list = null;
        list = this.trapDestList.get(i);
        if (list != null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getTrapCommunities", "[" + i.toString() + "] is in list");
            }
            return list.elements();
        }
        list = new Vector();
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getTrapCommunities", "[" + i.toString() + "] is not in list");
        }
        return list.elements();
    }

    @Override
    public Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    @Override
    public Enumeration getInformCommunities(InetAddress i) {
        Vector<String> list = null;
        list = this.informDestList.get(i);
        if (list != null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getInformCommunities", "[" + i.toString() + "] is in list");
            }
            return list.elements();
        }
        list = new Vector();
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "getInformCommunities", "[" + i.toString() + "] is not in list");
        }
        return list.elements();
    }

    private void readAuthorizedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Parser parser = null;
            try {
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException e) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                JDMSecurityDefs n = parser.SecurityDefs();
                n.buildAclEntries(this.owner, this.acl);
                n.buildTrapEntries(this.trapDestList);
                n.buildInformEntries(this.informDestList);
            }
            catch (ParseException e) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "Got parsing exception", e);
                }
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (Error err) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpAcl.class.getName(), "readAuthorizedListFile", "Got unexpected error", err);
                }
                throw new IllegalArgumentException(err.getMessage());
            }
            Enumeration<AclEntry> e = this.acl.entries();
            while (e.hasMoreElements()) {
                AclEntryImpl aa = (AclEntryImpl)e.nextElement();
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "===> " + ((Object)aa.getPrincipal()).toString());
                }
                Enumeration<Permission> eee = aa.permissions();
                while (eee.hasMoreElements()) {
                    Permission perm = eee.nextElement();
                    if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) continue;
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpAcl.class.getName(), "readAuthorizedListFile", "perm = " + perm);
                }
            }
        }
    }

    private void setDefaultFileName() {
        try {
            this.setAuthorizedListFile(SnmpAcl.getDefaultAclFileName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

