/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class WindowsRadioButtonUI
extends BasicRadioButtonUI {
    private static final WindowsRadioButtonUI windowsRadioButtonUI = new WindowsRadioButtonUI();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean initialized = false;

    public static ComponentUI createUI(JComponent c) {
        return windowsRadioButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.initialized) {
            this.dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            this.dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            this.dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            this.dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.initialized = true;
        }
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        WindowsGraphicsUtils.paintText(g, b, textRect, text, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, textRect.x, textRect.y, textRect.width, textRect.height);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }
}

