/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOSMarkerSegment
extends MarkerSegment {
    int startSpectralSelection;
    int endSpectralSelection;
    int approxHigh;
    int approxLow;
    ScanComponentSpec[] componentSpecs;

    SOSMarkerSegment(boolean willSubsample, byte[] componentIDs, int numComponents) {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.componentSpecs = new ScanComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            int tableSel = 0;
            if (willSubsample && (i == 1 || i == 2)) {
                tableSel = 1;
            }
            this.componentSpecs[i] = new ScanComponentSpec(componentIDs[i], tableSel);
        }
    }

    SOSMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        int numComponents = buffer.buf[buffer.bufPtr++];
        this.componentSpecs = new ScanComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.componentSpecs[i] = new ScanComponentSpec(buffer);
        }
        this.startSpectralSelection = buffer.buf[buffer.bufPtr++];
        this.endSpectralSelection = buffer.buf[buffer.bufPtr++];
        this.approxHigh = buffer.buf[buffer.bufPtr] >> 4;
        this.approxLow = buffer.buf[buffer.bufPtr++] & 0xF;
        buffer.bufAvail -= this.length;
    }

    SOSMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(218);
        this.startSpectralSelection = 0;
        this.endSpectralSelection = 63;
        this.approxHigh = 0;
        this.approxLow = 0;
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        SOSMarkerSegment newGuy = (SOSMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            newGuy.componentSpecs = (ScanComponentSpec[])this.componentSpecs.clone();
            for (int i = 0; i < this.componentSpecs.length; ++i) {
                newGuy.componentSpecs[i] = (ScanComponentSpec)this.componentSpecs[i].clone();
            }
        }
        return newGuy;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("sos");
        node.setAttribute("numScanComponents", Integer.toString(this.componentSpecs.length));
        node.setAttribute("startSpectralSelection", Integer.toString(this.startSpectralSelection));
        node.setAttribute("endSpectralSelection", Integer.toString(this.endSpectralSelection));
        node.setAttribute("approxHigh", Integer.toString(this.approxHigh));
        node.setAttribute("approxLow", Integer.toString(this.approxLow));
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            node.appendChild(this.componentSpecs[i].getNativeNode());
        }
        return node;
    }

    void updateFromNativeNode(Node node, boolean fromScratch) throws IIOInvalidTreeException {
        NamedNodeMap attrs = node.getAttributes();
        int numComponents = SOSMarkerSegment.getAttributeValue(node, attrs, "numScanComponents", 1, 4, true);
        int value = SOSMarkerSegment.getAttributeValue(node, attrs, "startSpectralSelection", 0, 63, false);
        this.startSpectralSelection = value != -1 ? value : this.startSpectralSelection;
        value = SOSMarkerSegment.getAttributeValue(node, attrs, "endSpectralSelection", 0, 63, false);
        this.endSpectralSelection = value != -1 ? value : this.endSpectralSelection;
        value = SOSMarkerSegment.getAttributeValue(node, attrs, "approxHigh", 0, 15, false);
        this.approxHigh = value != -1 ? value : this.approxHigh;
        value = SOSMarkerSegment.getAttributeValue(node, attrs, "approxLow", 0, 15, false);
        this.approxLow = value != -1 ? value : this.approxLow;
        NodeList children = node.getChildNodes();
        if (children.getLength() != numComponents) {
            throw new IIOInvalidTreeException("numScanComponents must match the number of children", node);
        }
        this.componentSpecs = new ScanComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.componentSpecs[i] = new ScanComponentSpec(children.item(i));
        }
    }

    void write(ImageOutputStream ios) throws IOException {
    }

    void print() {
        this.printTag("SOS");
        System.out.print("Start spectral selection: ");
        System.out.println(this.startSpectralSelection);
        System.out.print("End spectral selection: ");
        System.out.println(this.endSpectralSelection);
        System.out.print("Approx high: ");
        System.out.println(this.approxHigh);
        System.out.print("Approx low: ");
        System.out.println(this.approxLow);
        System.out.print("Num scan components: ");
        System.out.println(this.componentSpecs.length);
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            this.componentSpecs[i].print();
        }
    }

    ScanComponentSpec getScanComponentSpec(byte componentSel, int tableSel) {
        return new ScanComponentSpec(componentSel, tableSel);
    }

    class ScanComponentSpec
    implements Cloneable {
        int componentSelector;
        int dcHuffTable;
        int acHuffTable;

        ScanComponentSpec(byte componentSel, int tableSel) {
            this.componentSelector = componentSel;
            this.dcHuffTable = tableSel;
            this.acHuffTable = tableSel;
        }

        ScanComponentSpec(JPEGBuffer buffer) {
            this.componentSelector = buffer.buf[buffer.bufPtr++];
            this.dcHuffTable = buffer.buf[buffer.bufPtr] >> 4;
            this.acHuffTable = buffer.buf[buffer.bufPtr++] & 0xF;
        }

        ScanComponentSpec(Node node) throws IIOInvalidTreeException {
            NamedNodeMap attrs = node.getAttributes();
            this.componentSelector = MarkerSegment.getAttributeValue(node, attrs, "componentSelector", 0, 255, true);
            this.dcHuffTable = MarkerSegment.getAttributeValue(node, attrs, "dcHuffTable", 0, 3, true);
            this.acHuffTable = MarkerSegment.getAttributeValue(node, attrs, "acHuffTable", 0, 3, true);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("scanComponentSpec");
            node.setAttribute("componentSelector", Integer.toString(this.componentSelector));
            node.setAttribute("dcHuffTable", Integer.toString(this.dcHuffTable));
            node.setAttribute("acHuffTable", Integer.toString(this.acHuffTable));
            return node;
        }

        void print() {
            System.out.print("Component Selector: ");
            System.out.println(this.componentSelector);
            System.out.print("DC huffman table: ");
            System.out.println(this.dcHuffTable);
            System.out.print("AC huffman table: ");
            System.out.println(this.acHuffTable);
        }
    }
}

