# -*- coding: utf-8 -*-
from __future__ import with_statement
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import urllib2
import urllib
import re
import shutil
import gdata.youtube.service
import gdata.service
from youtubeconfig import *

class YouTubeDataService(object):
    currentUser = ""
    fieldsquery = "&fields=link(@rel),entry(id,app:control(yt:state/text()),link(@rel,@href),summary,gd:comments,media:group(media:credit/text(),media:description/text(),media:player,media:title/text(),media:thumbnail(@url),yt:duration,yt:uploaded,yt:videoid),gd:rating(@average),yt:statistics(@viewCount),yt:rating)"
    ytService = gdata.youtube.service.YouTubeService()
    ytService.email = ""
    ytService.password = ""
    ytService.source = "Ytube"
    ytService.developer_key = "AI39si6YT7uxB9Zwrj1xW86FNKrUC92lYrPhoh6BwkcBzb_7E9Kiq9-HlqWC_DKvcaE6hq9r_wHjoMoUQAG70fTCUYmcKb4RcQ"
    stdHeaders = {
    'User-Agent': 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.8) Gecko/20100723 Firefox/3.6.8',
    'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Accept-Language': 'en-us,en;q=0.5',
    }
    
    def __init__(self,  parent):
        object.__init__(self,  parent)
    
    @staticmethod
    def youtubeLogin(username):      
        YouTubeDataService.ytService.email = unicode(YouTubeAPISettings.userDict[username][0], "utf-8")
        YouTubeDataService.ytService.password = unicode(YouTubeAPISettings.userDict[username][1], "utf-8")
        try:
            YouTubeDataService.ytService.ProgrammaticLogin()
            YouTubeDataService.currentUser = username
            result = True
        except:
            try:
                YouTubeDataService.ytService.email = unicode(username, "utf-8")
                YouTubeDataService.ytService.password = unicode(YouTubeAPISettings.userDict[username][1], "utf-8")
                YouTubeDataService.ytService.ProgrammaticLogin()
                YouTubeDataService.currentUser = username
                result = True
            except Exception, e:
                result = False
        return result
        
    @staticmethod
    def addComment(comment, videoId):
        videoEntry = YouTubeDataService.getVideoEntry(videoId)
        YouTubeDataService.ytService.AddComment(unicode(comment), videoEntry) 

    @staticmethod
    def addLikeOrDislike(likeOrDislike, videoId):
        videoEntry = YouTubeDataService.getVideoEntry(videoId, apiVersion=2)
        try:
            YouTubeDataService.ytService.AddLikeOrDislike(likeOrDislike, videoEntry)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result
    
    @staticmethod
    def addSubscription(username):
        try:
            YouTubeDataService.ytService.AddSubscriptionToChannel(username)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def removeSubscription(subscriptionUri):
        try:
            YouTubeDataService.ytService.DeleteSubscription(subscriptionUri)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def addVideoToFavourites(videoId):
        a ="<?xml version=\"1.0\" encoding=\"UTF-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><id>%s</id></entry>" % videoId
        try:
            YouTubeDataService.ytService.AddVideoEntryToFavorites(a)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def removeVideoFromFavourites(videoId):
        try:
            YouTubeDataService.ytService.DeleteVideoEntryFromFavorites(videoId)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def newPlaylist(playlistTitle, playlistDescription, private):
        new_playlistentry = YouTubeDataService.ytService.AddPlaylist(playlistTitle, playlistDescription, private)
        if isinstance(new_playlistentry, gdata.youtube.YouTubePlaylistEntry):
            return True            
        return False

    @staticmethod
    def addVideoToPlaylist(playlistId, videoId):
        playlistUri = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId
        YouTubeDataService.ytService.AddPlaylistVideoEntryToPlaylist(playlistUri, videoId)

    @staticmethod
    def removeVideoFromPlaylist(playlistId, videoId):
        playlistUri = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId
        try:
            YouTubeDataService.ytService.DeletePlaylistVideoEntry(playlistUri, videoId)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def updatePlaylistVideo(playlist_uri, playlistentryId, newVideoTitle, newVideoDescription, newPosition):
        YouTubeDataService.ytService.UpdatePlaylistVideoEntryMetaData(playlist_uri, playlistentryId, newVideoTitle, newVideoDescription, newPosition)

    @staticmethod
    def updatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private):
        YouTubeDataService.ytService.UpdatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private)

    @staticmethod
    def deletePlaylist(playlistId):
        playlistUri = "http://gdata.youtube.com/feeds/api/users/default/playlists/%s" % playlistId
        try:
            YouTubeDataService.ytService.DeletePlaylist(playlistUri)
            result = True
        except gdata.service.Error, e:
            result = e.args[0].get("body")
        return result

    @staticmethod
    def getVideoEntry(videoId, apiVersion=1):
        try:
            videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(video_id=videoId, api_version=apiVersion)
        except:
            videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(videoId, api_version=apiVersion)
        return videoEntry
        
    @staticmethod
    def getVideoRestrictions(video):
        restriction = None
        try:
            if video.control.FindExtensions()[0].text != "Syndication of this video was restricted by its owner.":
                restriction = video.control.FindExtensions()[0].text
        except:
            restriction = None
        return restriction

    @staticmethod
    def getVideoThumbnail(thumbUrl):
        try:
            opener = urllib2.build_opener()
            thumbPage = opener.open(thumbUrl)
            image = QImage()
            if image.loadFromData(thumbPage.read()):
                thumbnail = QPixmap.fromImage(image)
        except:
            thumbnail = None
        return thumbnail

    @staticmethod
    def updateVideo(video_uri, newVideoTitle, newVideoDescription):
        video = YouTubeDataService.ytService.GetYouTubeVideoEntry(video_uri)
        video.media.title.text = newVideoTitle
        video.media.description.text = newVideoDescription
        YouTubeDataService.ytService.UpdateVideoEntry(video)

    @staticmethod
    def deleteVideo(video_uri):
        videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(video_uri)
        YouTubeDataService.ytService.DeleteVideoEntry(videoEntry)

    @staticmethod
    def getVideoUrl(video,  videoFormat=18):
        try:
            videoUrl = ""       
            playerUrl = video.media.player.url.split("&")[0]
            html = urllib.urlopen(playerUrl).read()
            html = "".join(html.split())
            formats = {}
            pos = html.find("\",\"fmt_url_map\":\"")
            if (pos != -1):
                pos2 = html.find("\"", pos + 17)
                fmt_map = urllib.unquote(html[pos + 17:pos2]) + ","
                parts = fmt_map.split("|")
                key = parts[0]
                for p in parts[1:]:
                    idx = p.rfind(",")
                    value = p[:idx].replace("\\/", "/").replace("\u0026", "&").replace("http://o-o.preferred.", "ytube")
                    if value.startswith("ytube"):
                        value = "http://%s" % value.partition(".")[2]
                    formats[int(key)] = value
                    key = p[idx + 1:]                
            formatList = [22, 35, 34, 18, 5]
            for format in formatList[formatList.index(videoFormat):]:
                if videoFormat in formats:
                    videoUrl = formats.get(videoFormat)
                    break
                break
            return videoUrl
        except Exception, e:
            return videoUrl

    @staticmethod
    def getflashVideoUrl(a):
        b = ""       
        c = "http://www.youtube.com/get_video_info?video_id=%s&el=vevo&ps=default&gl=US&hl=en" % a
        try:
            d = urllib.urlopen(c).read()
            b = d.split("url_encoded_fmt_stream_map=")[1].split("&")[0].split("http%253A%252F%252F")[-1]
            if not b.startswith("v"):
                b = ""
            return b
        except Exception, e:
            return b

class YouTubeVideoFeed(QThread):
    def __init__(self, parent, videoFeed, maxresults=10):
        QThread.__init__(self, parent)
        self.videoFeed = videoFeed
        self.videoList = []
        self.results = 0
        self.thumbcount = 0
        self.moreResults = True
        self.maxresults = maxresults
        
    def resetResultCount(self):
        self.videoList = []
        self.results = 0
        self.thumbcount = 0
    
    def getVideoFeed(self, retriesRemaining=3):
        try:
            try:
                self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(("%s?start-index=%d&max-results=%d&v=2%s" % (self.videoFeed, self.results + 1, self.maxresults, YouTubeDataService.fieldsquery)).encode("utf-8"))
            except:
                self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(("%s&start-index=%d&max-results=%d&v=2%s" % (self.videoFeed, self.results + 1, self.maxresults, YouTubeDataService.fieldsquery)).encode("utf-8"))
            for link in self.ytVideoFeed.link:
                self.moreResults = (link.rel == "next")
        except Exception, e:
            if retriesRemaining > 0:
                retriesRemaining -= 1
                self.getVideoFeed(retriesRemaining)
            else:
                pass
            
    def getVideoData(self):
        try:
            for video in self.ytVideoFeed.entry:
                try:
                    if video.media.player != None:
                        self.videoList.append(video)
                        self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
                        self.results += 1
                except Exception, e:
                    pass
        except Exception, e:
            pass
                
    def getThumbnails(self):
        for video in self.videoList[self.thumbcount:]:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (self.thumbcount, thumbnail))
                self.thumbcount += 1
            except Exception, e:
                pass

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getVideoFeed() 
        self.getVideoData()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubeQueueFeed(QThread):
    playlist = []
    
    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        for video in YouTubeQueueFeed.playlist:
            try:
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
            except:
                pass
                
    def getThumbnails(self):
        row = 0
        for video in YouTubeQueueFeed.playlist:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (row, thumbnail))
                row += 1
            except Exception, e:
                pass

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getQueueFeed()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubeDownloadQueueFeed(QThread):
    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        for task in YouTubeVideoDownloader.taskQueue:
            try:
                video = task.video
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), video)
            except:
                pass
                
    def getThumbnails(self):
        row = 0
        for task in YouTubeVideoDownloader.taskQueue:
            try:
                video = task.video
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[0].url)
                self.emit(SIGNAL("thumbnailLoaded(PyQt_PyObject)"), (row, thumbnail))
                row += 1
            except Exception, e:
                pass

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getQueueFeed()
        self.emit(SIGNAL("feedCompleted(bool)"), False)
        self.getThumbnails()

class YouTubePlaylistFeed(QThread):
    def __init__(self, parent, username):
        QThread.__init__(self, parent)
        self.retriesRemaining = 3
        self.results = 1
        if username==None:
            self.username="default"
        else:
            self.username = username
        
    def getPlaylistFeed(self):
        playlistsUri = "http://gdata.youtube.com/feeds/api/users/%s/playlists?max-results=50&v=2&fields=entry(title,summary,link(@rel,@href),yt:countHint,yt:playlistId)" % self.username
        try:
            self.playlistFeed = YouTubeDataService.ytService.GetYouTubePlaylistFeed(uri = playlistsUri)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.playlistFeed.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                self.retriesRemaining -= 1
                self.getPlaylistFeed()
            else:
                pass
            
    def run(self):
        self.getPlaylistFeed()

class YouTubeSubscriptionsFeed(QThread):
    def __init__(self, parent):
        QThread.__init__(self, parent)
        self.retriesRemaining = 3

    def getSubscriptionsFeed(self):
        subscriptionsUri = "http://gdata.youtube.com/feeds/api/users/default/subscriptions?max-results=50&v=2&fields=entry(link(@rel,@href),yt:username)"
        try:
            self.subscriptionsFeed = YouTubeDataService.ytService.GetYouTubeSubscriptionFeed(uri = subscriptionsUri)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.subscriptionsFeed.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                self.retriesRemaining -= 1
                self.getSubscriptionsFeed()
            else:
                pass
            
    def run(self):
        self.getSubscriptionsFeed()

class YouTubeCommentsFeed(QThread):
    def __init__(self, parent, commentsFeed):
        QThread.__init__(self, parent)
        self.retriesRemaining = 3
        self.commentsFeed = commentsFeed
        self.results = 1
        self.moreResults = True
        self.comments = ("%s&start-index=%d&v=2" % (self.commentsFeed, self.results + 1)).encode("utf-8")
        
    def getVideoComments(self):
        try:
            comments = YouTubeDataService.ytService.GetYouTubeVideoFeed(self.comments)
            for link in comments.link:
                if link.rel == "next":
                    self.comments = link.href
                self.moreResults = (link.rel == "next")
            self.results = len(comments.entry)
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), comments.entry)
        except Exception, e:
            if self.retriesRemaining > 0:
                self.retriesRemaining -= 1
                self.getVideoComments()
            else:
                pass

    def resetResultCount(self):
        self.moreResults = True

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getVideoComments()
        self.emit(SIGNAL("feedCompleted(bool)"), False)

class YouTubeVideoDownloader(object):
    taskQueue = []
    currentTask = None
    currentStatus = "inactive"
    
    def __init__(self, parent = None):
        object.__init__(self, parent = None)
        
    @staticmethod
    def addTask(video):
        task = DownloadTask(video)
        YouTubeVideoDownloader.taskQueue.append(task)
        if YouTubeVideoDownloader.currentStatus == "inactive" and VideoDownloadSettings.defaultTaskStatus == "queued":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def pauseTask(task):
        YouTubeVideoDownloader.taskQueue[task].setStatus("paused")
        
    @staticmethod
    def cancelTask(task):
        YouTubeVideoDownloader.taskQueue[task].setStatus("cancelled")
            
    @staticmethod
    def resumeTask(task):
        YouTubeVideoDownloader.taskQueue[task].setStatus("queued")
        if YouTubeVideoDownloader.currentStatus == "inactive":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def clearTasks():
        YouTubeVideoDownloader.taskQueue = []
        
    @staticmethod
    def saveTasks():
        taskList = []
        for task in YouTubeVideoDownloader.taskQueue:
            if task.getStatus() in ("paused", "queued", "downloading"):
                savedTask = task.getId()
                taskList.append(savedTask)
        return taskList
        
    @staticmethod
    def restoreTasks(taskList):
        for task in taskList:
            videoId = unicode(task, "utf-8")
            video = YouTubeDataService.getVideoEntry(videoId, apiVersion=2)
            YouTubeVideoDownloader.addTask(video)
    
    @staticmethod
    def run():
        for task in YouTubeVideoDownloader.taskQueue:
            if task.getStatus() == "queued":
                YouTubeVideoDownloader.currentTask = task
                YouTubeVideoDownloader.currentTask.start(QThread.LowPriority)
                YouTubeVideoDownloader.currentStatus = "active"
                break
        else:
            YouTubeVideoDownloader.currentStatus = "inactive"

class DownloadTask(QThread):       
    def getTitle(self):
        return self.video.media.title.text
        
    def getId(self):
        return self.video.media.player.url.split("=") [1].split("&")[0]
        
    def getVideo(self):
        return self.video

    def getStatus(self):
        return self.status

    def setStatus(self, status):
        if status != self.getStatus:
            self.statusChanged = True
            self.status = status
        
    def removedFromList(self):
        if self.status != "completed":
            QFile.remove(self.tempname)

    def __init__(self, video):
        QThread.__init__(self,  parent = None)
        self.status = VideoDownloadSettings.defaultTaskStatus
        self.statusChanged = True
        self.video = video
        self.connect(self,  SIGNAL("finished()"),  YouTubeVideoDownloader.run)

        # Create the target filename
        if VideoDownloadSettings.downloadFormat in (34, 35, 22):
            formatExt = "HQ"
            self.filename = "%s/%s-%s.mp4" % (VideoDownloadSettings.downloadFolder, unicode(re.sub('[\"?#~!@=:/|\\\\]', "-", self.video.media.title.text), "utf-8"), formatExt)
        else:
            self.filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, unicode(re.sub('[\"?#~!@=:/|\\\\]', "-", self.video.media.title.text), "utf-8"))
        self.tempname = self.filename + '.partial'

        self.totalSize = 0
        self.speed = 0.0
        self.progress = 0.0
        self.errorMessage = None

        # Variables for speed calculation
        self.startTime = 0
        self.startBlocks = 0

        # If the tempname already exists, set progress accordingly
        if QFile.exists(self.tempname):
            try:
                already_downloaded = QFile(self.tempname).size()
                if self.totalSize > 0:
                    self.progress = max(0.0, min(1.0, float(alreadyDownloaded)/self.totalSize))
            except OSError, os_error:
                print 'Error while getting size for existing file: %s' % os_error

    def statusUpdated(self, count, blockSize, totalSize):
        # We see a different "total size" while downloading,
        # so correct the total size variable in the thread
        if totalSize != self.totalSize and totalSize > 0:
            self.totalSize = float(totalSize)

        if self.totalSize > 0:
            self.progress = max(0.0, min(1.0, float(count*blockSize)/self.totalSize))

        self.calculateSpeed(count, blockSize)

        if self.status == "cancelled":
            raise DownloadCancelledException()

        if self.status == "paused":
            raise DownloadCancelledException()
            
        self.emit(SIGNAL("downloadUpdated()"))

    def calculateSpeed(self, count, blockSize):
        if count % 5 == 0:
            now = QDateTime.currentDateTime().toTime_t()
            if self.startTime > 0:
                passed = now - self.startTime
                if passed > 0:
                    speed = ((count-self.startBlocks)*blockSize)/passed
                else:
                    speed = 0
            else:
                self.startTime = now
                self.startBlocks = count
                passed = now - self.startTime
                speed = count*blockSize

            self.speed = float(speed/1000)

    def run(self):
        # Speed calculation (re-)starts here
        self.startTime = 0
        self.startBlocks = 0

        # If the download has already been cancelled, skip it
        if self.status == "cancelled":
            QFile.remove(self.tempname)
            self.progress = 0.0
            self.speed = 0.0
        # We are downloading this file right now
        self.status = "downloading"
        try:
            # Resolve URL and start downloading the episode
            url = YouTubeDataService.getVideoUrl(self.video,  VideoDownloadSettings.downloadFormat)
            downloader =  DownloadURLOpener()
            headers, realUrl = downloader.retrieveResume(url, \
                    self.tempname, reporthook=self.statusUpdated)
            shutil.move(self.tempname, self.filename)
            self.status = "completed"
            self.speed = 0.0
        except DownloadCancelledException:
            if self.status == "cancelled":
                QFile.remove(self.tempname)
                self.progress = 0.0
                self.speed = 0.0
                self.emit(SIGNAL("statusChanged()"))
        except urllib.ContentTooShortError, ctse:
            self.status = "failed"
            self.emit(SIGNAL("statusChanged()"))            
        except IOError, ioe:
            self.status = "failed"
            self.emit(SIGNAL("statusChanged()"))
        except Exception, e:
            self.status = "failed"
            self.emit(SIGNAL("statusChanged()"))
        
        
class ContentRange(object):
    def __init__(self, start, stop, length):
        assert start >= 0, "Bad start: %r" % start
        assert stop is None or (stop >= 0 and stop >= start), (
            "Bad stop: %r" % stop)
        self.start = start
        self.stop = stop
        self.length = length

    def __repr__(self):
        return '<%s %s>' % (
            self.__class__.__name__,
            self)

    def __str__(self):
        if self.stop is None:
            stop = '*'
        else:
            stop = self.stop + 1
        if self.length is None:
            length = '*'
        else:
            length = self.length
        return 'bytes %s-%s/%s' % (self.start, stop, length)

    def __iter__(self):
        return iter([self.start, self.stop, self.length])

    @classmethod
    def parse(cls, value):
        if value is None:
            return None
        value = value.strip()
        if not value.startswith('bytes '):
            # Unparseable
            return None
        value = value[len('bytes '):].strip()
        if '/' not in value:
            # Invalid, no length given
            return None
        range, length = value.split('/', 1)
        if '-' not in range:
            # Invalid, no range
            return None
        start, end = range.split('-', 1)
        try:
            start = int(start)
            if end == '*':
                end = None
            else:
                end = int(end)
            if length == '*':
                length = None
            else:
                length = int(length)
        except ValueError:
            # Parse problem
            return None
        if end is None:
            return cls(start, None, length)
        else:
            return cls(start, end-1, length)
        
class DownloadURLOpener(urllib.FancyURLopener):
    def __init__(self):
        urllib.FancyURLopener.__init__(self, None)

    def retrieveResume(self, url, filename, reporthook=None, data=None):
        currentSize = 0
        tfp = None
        if QFile.exists(filename):
            try:
                currentSize = QFile(filename).size()
                tfp = open(filename, 'ab')
                if currentSize > 0:
                    self.addheader('Range', 'bytes=%s-' % (currentSize))
            except:
                print 'Cannot open file for resuming: %s' % filename
                tfp = None
                currentSize = 0

        if tfp is None:
            tfp = open(filename, 'wb')

        url = urllib.unwrap(urllib.toBytes(url))
        fp = self.open(url, data)
        headers = fp.info()

        if currentSize > 0:
            range = ContentRange.parse(headers.get('content-range', ''))
            if range is None or range.start != currentSize:
                tfp.close()
                tfp = open(filename, 'wb')
                currentSize = 0
                print 'Cannot resume. Missing or wrong Content-Range header (RFC2616)'

        result = headers, fp.geturl()
        bs = 1024*8
        size = -1
        read = currentSize
        blocknum = int(currentSize/bs)
        if reporthook:
            if "content-length" in headers:
                size = int(headers["Content-Length"]) + currentSize
            reporthook(blocknum, bs, size)
        while read < size or size == -1:
            if size == -1:
                block = fp.read(bs)
            else:
                block = fp.read(min(size-read, bs))
            if block == "":
                break
            read += len(block)
            tfp.write(block)
            blocknum += 1
            if reporthook:
                reporthook(blocknum, bs, size)
        fp.close()
        tfp.close()
        del fp
        del tfp
        if size >= 0 and read < size:
            raise urllib.ContentTooShortError("retrieval incomplete: got only %i out "
                                       "of %i bytes" % (read, size), result)

        return result
        
class DownloadCancelledException(Exception): pass
