#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
import os
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtWebKit import QWebView
try:
    from PyQt4.QtMaemo5 import QMaemo5ListPickSelector, QMaemo5AbstractPickSelector, QMaemo5InformationBox, QMaemo5ValueButton
except:
    pass
import youtubeservice
import youtubewindows
from youtubeconfig import *
from videosharing import Twitter, Facebook
from Ui_addtoplaylistdialog import Ui_AddToPlaylistDialog
from Ui_newplaylistdialog import Ui_NewPlaylistDialog
from Ui_confirmdeletedialog import Ui_ConfirmDeleteDialog
from Ui_addcommentdialog import Ui_AddCommentDialog
from Ui_searchdialog import Ui_searchDialog
from Ui_switchaccountdialog import Ui_SwitchAccountDialog
from Ui_manageaccountsdialog import Ui_ManageAccountsDialog
from Ui_editaccountdialog import Ui_EditAccountDialog
from Ui_addaccountdialog import Ui_AddAccountDialog
from Ui_settingsdialog import Ui_SettingsDialog
from Ui_noaccountfounddialog import Ui_NoAccountFoundDialog

class AddToPlaylistDialog(QDialog, Ui_AddToPlaylistDialog):
    def __init__(self, parent, videos):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.videos = videos
        self.yt = youtubeservice.YouTubePlaylistFeed(self, None)
        self.connect(self.yt, SIGNAL("dataLoaded(PyQt_PyObject)"), self.loadPlaylists)
        self.show()
        self.yt.start()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 720)
            self.listWidget.setGeometry(QRect(5, 10, 470, 600))
            self.newButton.setGeometry(QRect(10, 620, 460, 70))
        else:
            self.resize(800, 420)
            self.listWidget.setGeometry(QRect(5, 10, 620, 360))
            self.newButton.setGeometry(QRect(640, 295, 150, 70))

    def loadPlaylists(self, playlistFeed):
        for playlist in playlistFeed:
            item = QListWidgetItem(unicode(playlist.title.text, "utf-8"))
            item.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.listWidget.addItem(item)
            
    def toggleBusy(self, isBusy):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
    
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        row = self.listWidget.row(item)
        playlistId = self.yt.playlistFeed.entry[row].playlist_id.text
        try:
            self.toggleBusy(True)
            for video in self.videos:
                videoId = video.media.video_id.text
                youtubeservice.YouTubeDataService.addVideoToPlaylist(playlistId, videoId)
            if len(self.videos) == 1:
                QMaemo5InformationBox.information(self, "\'%s\' has been added to your playlist: \'%s\'" % (unicode(video.media.title.text, "utf-8"), item.text()))
            else:
                QMaemo5InformationBox.information(self, "Your chosen videos have been added to your playlist: \'%s\'" % item.text())
        except:
            QMaemo5InformationBox.information(self, "Unable to add videos to your playlist")
        self.toggleBusy(False)
        self.accept()

    @pyqtSignature("")
    def on_newButton_clicked(self):
        newPlaylistDialog = NewPlaylistDialog(self, self.videos)    
        self.connect(newPlaylistDialog, SIGNAL("accepted()"), self.accept)    

class NewPlaylistDialog(QDialog, Ui_NewPlaylistDialog):
    def __init__(self, parent, videos = None):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.titleEdit.setFocus()
        self.videos = videos
        self.show()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 410)
            self.privateCheckBox.setGeometry(QRect(10, 250, 460, 70))
            self.saveButton.setGeometry(QRect(10, 330, 460, 70))
        else:
            self.resize(800, 400)
            self.saveButton.setGeometry(QRect(640, 290, 150, 70))
            self.privateCheckBox.setGeometry(QRect(10, 290, 460, 70))
    
    def toggleBusy(self, isBusy=False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
 
    @pyqtSignature("")
    def on_saveButton_clicked(self):
        playlistTitle = unicode(self.titleEdit.text())
        playlistDescription = unicode(self.descriptionEdit.toPlainText())
        private = self.privateCheckBox.isChecked()
        try:
            self.toggleBusy(True)
            result = youtubeservice.YouTubeDataService.newPlaylist(playlistTitle, playlistDescription, private)
            if (self.videos == None and result):
                QMaemo5InformationBox.information(self, "Your new playlist: \'%s\' has been created" % playlistTitle)
            else:
                try:
                    result = youtubeservice.YouTubeDataService.ytService.GetYouTubePlaylistFeed(uri="http://gdata.youtube.com/feeds/api/users/default/playlists?max-results=50&v=2")
                    playlistId = result.entry[-1].playlist_id.text
                    for video in self.videos:
                        youtubeservice.YouTubeDataService.addVideoToPlaylist(playlistId, video.media.video_id.text)
                    if len(self.videos) == 1:
                        QMaemo5InformationBox.information(self, "\'%s\' has been added to your playlist: \'%s\'" % (self.videos[0].media.title.text, playlistTitle))
                    else:
                        QMaemo5InformationBox.information(self, "Your chosen videos have been added to your playlist: \'%s\'" % playlistTitle)
                except:
                    QMaemo5InformationBox.information(self, "Unable to add new video to \'%s\'" % playlistTitle)
                    
        except:
            QMaemo5InformationBox.information(self, "Unable to add new playlist") 
        self.toggleBusy()
        self.accept()   

class EditPlaylistDialog(NewPlaylistDialog):
    def __init__(self, parent, playlist):
        NewPlaylistDialog.__init__(self, parent)
        self.setWindowTitle("Edit Playlist Metadata")
        self.playlist = playlist
        self.titleEdit.setText(self.playlist.title.text)
        try:
            self.descriptionEdit.setText(self.playlist.description.text)
        except:
            pass
        
    @pyqtSignature("")
    def on_saveButton_clicked(self):
        newPlaylistTitle = unicode(self.titleEdit.text())
        newPlaylistDescription = unicode(self.descriptionEdit.toPlainText())
        private = self.privateCheckBox.isChecked()
        playlistId = self.playlist.playlist_id.text
        try:
            self.toggleBusy(True)
            youtubeservice.YouTubeDataService.updatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private)
            QMaemo5InformationBox.information(self, "Your playlist metadata has been updated")
        except:
            QMaemo5InformationBox.information(self, "Unable to update your playlist metadata") 
        self.toggleBusy(False)
        self.accept()

class EditVideoDialog(NewPlaylistDialog):
    def __init__(self, parent, video):
        NewPlaylistDialog.__init__(self, parent)
        self.setWindowTitle("Edit Video Metadata")
        self.privateCheckBox.setVisible(False)
        self.orientationChanged()
        self.video = video
        self.titleEdit.setText(unicode(self.video.media.title.text, "utf-8"))
        try:
            self.descriptionEdit.setText(unicode(self.video.media.description.text, "utf-8"))
        except:
            pass

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 340)
            self.saveButton.setGeometry(QRect(10, 260, 460, 70))
        else:
            self.resize(800, 240)
            self.saveButton.setGeometry(QRect(640, 160, 150, 70))
        
    @pyqtSignature("")
    def on_saveButton_clicked(self):
        newVideoTitle = unicode(self.titleEdit.text())
        newVideoDescription = unicode(self.descriptionEdit.toPlainText())
        for link in self.video.link:
            if link.rel == "self":
                video_uri = link.href
        try:
            self.toggleBusy(True)
            youtubeservice.YouTubeDataService.updateVideo(video_uri, newVideoTitle, newVideoDescription)
            QMaemo5InformationBox.information(self, "Your video metadata has been updated")
        except:
            QMaemo5InformationBox.information(self, "Unable to update your video metadata") 
        self.toggleBusy(False)
        self.accept()

class EditPlaylistVideoDialog(NewPlaylistDialog):
    def __init__(self, parent, playlist_uri, playlistVideo, position, count):
        NewPlaylistDialog.__init__(self, parent)
        self.setWindowTitle("Edit Custom Metadata")
        self.playlist_uri = playlist_uri
        self.playlistVideo = playlistVideo
        self.privateCheckBox.setVisible(False) 
        self.titleEdit.setText(unicode(self.playlistVideo.title.text, "utf-8"))
        try:
            self.descriptionEdit.setText(unicode(self.playlistVideo.content.text, "utf-8") )
        except:
            pass
        self.positionButton = QMaemo5ValueButton("Position in playlist:", self)
        self.positionButton.setGeometry(10, 290, 460, 70)
        self.positionButton.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.positionModel = QStandardItemModel(0, 1)
        for num in range(count):
            item = QStandardItem(unicode(num + 1))
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.positionModel.appendRow(item)
        self.positionSelector = QMaemo5ListPickSelector()
        self.positionSelector.setModel(self.positionModel)
        self.positionButton.setPickSelector(self.positionSelector)
        self.positionSelector.setCurrentIndex(position - 1)
        self.positionButton.setVisible(True)
        self.orientationChanged()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 430)
            self.positionButton.setGeometry(10, 260, 460, 70)
            self.saveButton.setGeometry(QRect(10, 350, 460, 70))
        else:
            self.resize(800, 400)
            self.positionButton.setGeometry(10, 290, 460, 70)
            self.saveButton.setGeometry(QRect(640, 290, 150, 70))
        
    @pyqtSignature("")
    def on_saveButton_clicked(self):
        newVideoTitle = unicode(self.titleEdit.text())
        newVideoDescription = unicode(self.descriptionEdit.toPlainText())
        newPosition = unicode(self.positionButton.valueText())
        playlistentryId = self.playlist_uri.replace("?v=2","").split("/")[-1:][0]
        self.playlist_uri = self.playlist_uri.replace(playlistentryId,"")[:-5]
        try:
            self.toggleBusy(True)
            youtubeservice.YouTubeDataService.updatePlaylistVideo(self.playlist_uri, playlistentryId, newVideoTitle, newVideoDescription, newPosition)
            QMaemo5InformationBox.information(self, "Your custom metadata has been updated")
        except:
            QMaemo5InformationBox.information(self, "Unable to update your custom metadata") 
        self.toggleBusy(False)
        self.accept()      

class ConfirmDeleteDialog(QDialog, Ui_ConfirmDeleteDialog):
    def __init__(self, parent, title):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.confirmLabel.viewport().setAutoFillBackground(False)
        self.confirmLabel.setText("Do you want to delete \'%s\'?" % unicode(title, "utf-8"))
        self.connect(self, SIGNAL("accepted()"), self.confirmDelete)
        self.show() 

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 270)
            self.confirmButton.setGeometry(QRect(10, 190, 460, 70))
            self.cancelButton.setGeometry(QRect(10, 110, 460, 70))
            self.confirmLabel.setGeometry(QRect(10, 10, 581, 100))
        else:
            self.resize(800, 200)
            self.confirmButton.setGeometry(QRect(640, 110, 150, 70))
            self.cancelButton.setGeometry(QRect(640, 20, 150, 70))
            self.confirmLabel.setGeometry(QRect(10, 10, 581, 151))

    def confirmDelete(self):
        self.emit(SIGNAL("deleteConfirmed()"))

class RateVideoDialog(QDialog):
    def __init__(self, parent, videoId):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Like/Dislike Video")
        self.videoId = videoId
        self.likeButton = QPushButton(QIcon(":/images/ui-images/likeicon.png"), "Like", self)
        self.dislikeButton = QPushButton(QIcon(":/images/ui-images/dislikeicon.png"), "Dislike", self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        for button in (self.likeButton, self.dislikeButton):
            self.connect(button, SIGNAL("clicked()"), self.likeOrDislike)
        self.orientationChanged()
        self.show()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 170)
            self.likeButton.setGeometry(QRect(10, 10, 460, 70))
            self.dislikeButton.setGeometry(QRect(10, 90, 460, 70))
        else:
            self.resize(800, 90)
            self.likeButton.setGeometry(QRect(10, 10, 350, 70))
            self.dislikeButton.setGeometry(QRect(440, 10, 350, 70))
            
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
    
    def likeOrDislike(self):
        self.toggleBusy(True)
        if self.sender() is self.likeButton:
            value = "like"
        else:
            value = "dislike"
        try:
            ratingAdded = youtubeservice.YouTubeDataService.addLikeOrDislike(value, self.videoId)
            if ratingAdded == True:
                QMaemo5InformationBox.information(self, "You %sd this video" % value)
            else:
                QMaemo5InformationBox.information(self, ratingAdded)
        except Exception, e:
            QMaemo5InformationBox.information(self, "Unable to like/dislike this video")
        self.toggleBusy()
        self.accept()
        
class AddCommentDialog(QDialog, Ui_AddCommentDialog):
    def __init__(self, parent, video):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.commentEdit.setFocus()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.video = video
        self.show()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 230)
            self.submitButton.setGeometry(QRect(10, 150, 460, 70))
            self.commentEdit.setGeometry(QRect(10, 10, 460, 140))
        else:
            self.resize(800, 180)
            self.submitButton.setGeometry(QRect(640, 100, 150, 70))
            self.commentEdit.setGeometry(QRect(10, 30, 590, 140))
    
    @pyqtSignature("")
    def on_submitButton_clicked(self):
        videoTitle = self.video.media.title.text
        videoId = self.video.media.video_id.text
        author = self.video.media.credit.text
        try:
            youtubeservice.YouTubeDataService.addComment(self.commentEdit.toPlainText(), videoId)
            QMaemo5InformationBox.information(self, "Your comment has been added to \'%s\'. It may require %s\'s approval." % (unicode(videoTitle, "utf-8"), unicode(author, "utf-8")))
        except:
            QMaemo5InformationBox.information(self, "Unable to add comment")
        self.accept()

class SearchDialog(QDialog, Ui_searchDialog):
    def __init__(self, parent = None,  username = None):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5StackedWindow) 
        self.username = username
        if self.username != None:
            if self.username == youtubeservice.YouTubeDataService.currentUser:
                self.setWindowTitle("Search my uploads")
            else:
                self.setWindowTitle("Search %s\'s videos" % unicode(self.username, "utf-8"))
        self.searchOrderButton = QMaemo5ValueButton("Order results by:", self)
        self.searchOrderButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
        self.searchOrderModel = QStandardItemModel(0, 1)
        for order in ("Relevance", "Date published", "View count", "Rating"):
            item = QStandardItem(order)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.searchOrderModel.appendRow(item)
        self.searchOrderSelector = QMaemo5ListPickSelector()
        self.searchOrderSelector.setModel(self.searchOrderModel)
        self.searchOrderButton.setPickSelector(self.searchOrderSelector)
        self.searchOrderSelector.setCurrentIndex(SearchSettings.searchOrder)
        self.recentSearchesButton = QMaemo5ValueButton("Recent searches", self)
        self.recentSearchesButton.setValueLayout(QMaemo5ValueButton.ValueUnderTextCentered)
        self.recentSearchesModel = QStandardItemModel(0, 1)
        for searchString in SearchSettings.recentSearches:
            item = QStandardItem(searchString)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.recentSearchesModel.appendRow(item)
        self.recentSearchesSelector = QMaemo5ListPickSelector()
        self.recentSearchesSelector.setModel(self.recentSearchesModel)
        self.recentSearchesButton.setPickSelector(self.recentSearchesSelector)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.connect(self.recentSearchesSelector,  SIGNAL("selected(QString)"), self.selectRecentSearch)
        self.orientationChanged()
        self.show()
      
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 360)
            self.searchLabel.setGeometry(QRect(10, 10, 400, 30))
            self.lineEdit.setGeometry(QRect(10, 40, 460, 70))
            self.searchOrderButton.setGeometry(QRect(10, 120, 460, 70))
            self.recentSearchesButton.setGeometry(QRect(10, 200, 460, 70))
            self.searchButton.setGeometry(QRect(10, 280, 460, 70))      
        else:
            self.resize(800, 280)
            self.searchLabel.setGeometry(QRect(10, 10, 400, 30))
            self.lineEdit.setGeometry(QRect(10, 40, 600, 70))
            self.searchOrderButton.setGeometry(QRect(10, 120, 600, 70))
            self.recentSearchesButton.setGeometry(QRect(10, 200, 600, 70))
            self.searchButton.setGeometry(QRect(640, 200, 150, 70))  

    def selectRecentSearch(self,  searchString):
        self.lineEdit.setText(searchString)
        self.recentSearchesButton.setValueText("")

    @pyqtSignature("")    
    def on_searchButton_clicked(self):
        SearchSettings.searchOrder = self.searchOrderSelector.currentIndex()
        searchString = unicode(self.lineEdit.text())
        searchDict = {"Relevance": "relevance", "Date published": "published",  "View count": "viewCount", "Rating": "rating"}
        searchOrder = searchDict.get(unicode(self.searchOrderButton.valueText()))
        if searchString.startswith("http://www.youtube.com/watch?v="):
            self.goToVideo(searchString)
        else:
            self.getSearchResults(searchString, searchOrder)
            
    def goToVideo(self, url):
        from videoinfowindow import VideoInfoWindow
        try:
            videoId = url.split("=") [1].split("&")[0]
            video = youtubeservice.YouTubeDataService.getVideoEntry(videoId, apiVersion = 2)
            restriction = youtubeservice.YouTubeDataService.getVideoRestrictions(video)
            if restriction == None:
                videoInfoWindow = VideoInfoWindow(self, video)
                self.connect(videoInfoWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
                self.connect(videoInfoWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
            else:
                QMaemo5InformationBox.information(self, "Video not available: %s" % restriction)
        except:
            QMaemo5InformationBox.information(self, "Unable to find YouTube video. Please check the URL")
            
    def getSearchResults(self, searchString, searchOrder):
        if searchString in SearchSettings.recentSearches:
            SearchSettings.recentSearches.removeAll(searchString)
        if SearchSettings.recentSearches.count() > 30:
            SearchSettings.recentSearches.removeAt(30)
        SearchSettings.recentSearches.prepend(searchString)
        searchWindow = youtubewindows.YoutubeWindow(self, searchString, searchOrder, self.username)
        self.connect(searchWindow, SIGNAL("queueChanged(int)"), self.queueChanged)
        self.connect(searchWindow, SIGNAL("downloadsChanged(int)"), self.downloadsChanged)
        
    def queueChanged(self, queueLength):
        self.emit(SIGNAL("queueChanged(int)"), queueLength)
        
    def downloadsChanged(self,  taskQueueLength):
        self.emit(SIGNAL("downloadsChanged(int)"), taskQueueLength)

class SettingsDialog(QDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Settings")
        self.saveButton = QPushButton("Save",  self)
        accountLabel = QLabel("YouTube accounts")
        accountLabel.setStyleSheet("color: rgb(120, 120, 120)")
        downloadsLabel = QLabel("Video download options")
        downloadsLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.accountButton = QMaemo5ValueButton("Default account", self)
        self.accountButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.downloadFolderButton = QMaemo5ValueButton("Download location", self)
        self.downloadFolderButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.downloadFolderButton.setValueText(VideoDownloadSettings.downloadFolder)
        self.downloadFormatButton = QMaemo5ValueButton("Video download quality", self)
        self.downloadFormatButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.downloadStatusCheckBox = QCheckBox("Start downloads immediately",  self)
        self.downloadStatusCheckBox.setVisible(True)
        if VideoDownloadSettings.defaultTaskStatus == "queued":
            self.downloadStatusCheckBox.setChecked(True)
        self.accountModel = QStandardItemModel(0, 1)
        for account in YouTubeAPISettings.userDict.iterkeys():
            item = QStandardItem(account)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.accountModel.appendRow(item)
        self.accountSelector = QMaemo5ListPickSelector()
        self.accountSelector.setModel(self.accountModel)
        self.accountButton.setPickSelector(self.accountSelector)
        self.accountButton.setValueText(YouTubeAPISettings.defaultUser)
        self.downloadFormatModel = QStandardItemModel(0,  1)
        for format in ("N900 compatible", "360p", "480p", "720p"):
            item = QStandardItem(format)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.downloadFormatModel.appendRow(item)
        self.downloadFormatSelector = QMaemo5ListPickSelector()
        self.downloadFormatSelector.setModel(self.downloadFormatModel)
        self.downloadFormatButton.setPickSelector(self.downloadFormatSelector)
        downloadFormat = VideoDownloadSettings.downloadFormat
        self.downloadFormatSelector.setCurrentIndex(VideoDownloadSettings.formatList.index(downloadFormat))
        categoriesLabel = QLabel("YouTube categories")
        categoriesLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.categoryDict = {u'All': u'', u'Films - Drama': u'_Movies_Drama', u'Entertainment': u'_Entertainment', 
                            u'Science & Technology': u'_Tech', u'Films - Comedy': u'_Movies_Comedy', 
                            u'Films - Documentary': u'_Movies_Documentary', u'News & Politics': u'_News', 
                            u'Pets & Animals': u'_Animals', u'Non-profits & Activism': u'_Nonprofit', 
                            u'Music': u'_Music', u'Films - Shorts': u'_Movies_Shorts', u'Trailers': u'_Trailers', 
                            u'Films': u'_Movies', u'Videoblogging': u'_Videoblog', u'Films - Horror': u'_Movies_Horror', 
                            u'Comedy': u'_Comedy', u'Howto & Style': u'_Howto', u'Shows': u'_Shows', u'Gaming': u'_Games', 
                            u'People & Blogs': u'_People', u'Education': u'_Education', u'Films - Thriller': u'_Movies_Thriller', 
                            u'Films - Classics': u'_Movies_Classics', u'Travel & Events': u'_Travel', u'Films - Foreign': u'_Movies_Foreign', 
                            u'Short Films': u'_Shortmov', u'Films - Sci-Fi/Fantasy': u'_Movies_Sci_fi_fantasy', u'Cars & Vehicles': u'_Autos', 
                            u'Films - Family': u'Movies_Family', u'Films - Action/Adventure': u'Movies_Action_adventure', 
                            u'Films - Anime/Animation': u'_Movies_Anime_animation', u'Sport': u'_Sports', u'Film & Animation': u'_Film'
                            }
        self.categoryModel = QStandardItemModel(0, 1)
        self.categorySelector = QMaemo5ListPickSelector()
        self.categorySelector.setModel(self.categoryModel)
        categoryKeys = self.categoryDict.keys()
        categoryKeys.sort()
        num = 0
        for category in categoryKeys:
            item = QStandardItem(category)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.categoryModel.appendRow(item)
            if self.categoryDict.get(category) == YouTubeAPISettings.categoryFilter:
                self.categorySelector.setCurrentIndex(num) 
            num += 1
        self.categoryButton = QMaemo5ValueButton("Videos category filter", self)
        self.categoryButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.categoryButton.setPickSelector(self.categorySelector)
        self.locationDict = {'All': '', 'Australia': 'AU/', 'Brazil': 'BR/', 'Canada': 'CA/', 'Czech Republic': 'CZ/', 
                            'France': 'FR/', 'Germany': 'DE/', 'Great Britain': 'GB/', 'Holland': 'NL/', 'Hong Kong': 'HK/', 
                            'India': 'IN/', 'Ireland': 'IE/', 'Israel': 'IL/', 'Italy': 'IT/', 'Japan': 'JP/', 'Mexico': 'MX/', 
                            'New Zealand': 'NZ/', 'Poland': 'PL/', 'Russia': 'RU/', 'South Korea': 'KR/', 'Spain': 'ES/', 
                            'Sweden': 'SE/', 'Taiwan': 'TW/', 'United States': 'US/'
                            }
        self.locationModel = QStandardItemModel(0, 1)
        self.locationSelector = QMaemo5ListPickSelector()
        self.locationSelector.setModel(self.locationModel)
        locationKeys = self.locationDict.keys()
        locationKeys.sort()
        num = 0
        for location in locationKeys:
            item = QStandardItem(location)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.locationModel.appendRow(item)
            if self.locationDict.get(location) == YouTubeAPISettings.locationFilter:
                self.locationSelector.setCurrentIndex(num)
            num += 1
        self.locationButton = QMaemo5ValueButton("Videos location filter", self)
        self.locationButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.locationButton.setPickSelector(self.locationSelector)
        searchesLabel = QLabel("YouTube searches")
        searchesLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.clearSearchesButton = QPushButton("Clear recent searches", self)
        generalLabel = QLabel("General settings")
        generalLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.orientationModel = QStandardItemModel(0, 1)
        for orientation in ("Landscape", "Automatic"):
            item = QStandardItem(orientation)
            item.setEditable(False)
            item.setTextAlignment(Qt.AlignCenter)
            self.orientationModel.appendRow(item)
        self.orientationSelector = QMaemo5ListPickSelector()
        self.orientationSelector.setModel(self.orientationModel)
        if not GeneralSettings.autoOrientation:
            self.orientationSelector.setCurrentIndex(0)
        else:
            self.orientationSelector.setCurrentIndex(1)
        self.orientationButton = QMaemo5ValueButton("Display orientation", self)
        self.orientationButton.setValueLayout(QMaemo5ValueButton.ValueUnderText)
        self.orientationButton.setPickSelector(self.orientationSelector)
        self.scrollArea = QScrollArea(self)
        self.scrollArea.setMaximumHeight(460)
        self.scrollArea.setFixedWidth(620)
        self.orientationChanged()
        scrollWidget = QWidget()
        vBox = QVBoxLayout(scrollWidget)
        vBox.addWidget(accountLabel)
        vBox.addWidget(self.accountButton)
        vBox.addWidget(downloadsLabel)
        vBox.addWidget(self.downloadFolderButton)
        vBox.addWidget(self.downloadFormatButton)
        vBox.addWidget(self.downloadStatusCheckBox)
        vBox.addWidget(categoriesLabel)
        vBox.addWidget(self.categoryButton)
        vBox.addWidget(self.locationButton)
        vBox.addWidget(searchesLabel)
        vBox.addWidget(self.clearSearchesButton)
        vBox.addWidget(generalLabel)
        vBox.addWidget(self.orientationButton)
        self.scrollArea.setWidget(scrollWidget)
        vBox = QVBoxLayout(self)
        vBox.addWidget(self.scrollArea)
        self.orientationChanged()
        self.show()
        self.connect(self.saveButton,  SIGNAL("clicked()"),  self.saveSettings)
        self.connect(self.downloadFolderButton,  SIGNAL("clicked()"),  self.chooseDownloadFolder)
        self.connect(self.clearSearchesButton, SIGNAL("clicked()"), self.clearRecentSearches)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480,  720)
            """self.playbackFormatButton,"""
            for button in (self.accountButton, self.downloadFolderButton, self.locationButton, self.categoryButton, self.downloadFormatButton, self.downloadStatusCheckBox, self.clearSearchesButton, self.orientationButton):
                button.setFixedWidth(420)
            self.saveButton.setGeometry(QRect(10,  620,  460,  70))
        else:
            self.resize(800,  400)
            for button in (self.accountButton, self.downloadFolderButton, self.locationButton, self.categoryButton, self.downloadFormatButton, self.downloadStatusCheckBox, self.clearSearchesButton, self.orientationButton):
                button.setFixedWidth(580)
            self.saveButton.setGeometry(QRect(640,  300,  150,  70))
        
    def chooseDownloadFolder(self):
        currentFolder = self.downloadFolderButton.valueText()
        newFolder = QFileDialog.getExistingDirectory(self, directory = currentFolder, options = QFileDialog.ShowDirsOnly)
        if newFolder != "":
            self.downloadFolderButton.setValueText(newFolder)
            
    def clearRecentSearches(self):
        try:
            SearchSettings.recentSearches.clear()
            QMaemo5InformationBox.information(self, "Your recent searches have been cleared")
        except:
            QMaemo5InformationBox.information(self, "Unable to clear your recent searches")
        

    def saveSettings(self):
        account = unicode(self.accountButton.valueText())
        downloadFolder = unicode(self.downloadFolderButton.valueText())
        downloadFormat = self.downloadFormatSelector.currentIndex()
        category = unicode(self.categoryButton.valueText())
        location = unicode(self.locationButton.valueText())
        YouTubeAPISettings.defaultUser = account        
        YouTubeAPISettings.categoryFilter = self.categoryDict.get(category)
        YouTubeAPISettings.locationFilter = self.locationDict.get(location)
        VideoDownloadSettings.downloadFormat = VideoDownloadSettings.formatList[downloadFormat]
        VideoDownloadSettings.downloadFolder = downloadFolder
        if self.downloadStatusCheckBox.isChecked():
            VideoDownloadSettings.defaultTaskStatus = "queued"
        else:
            VideoDownloadSettings.defaultTaskStatus = "paused"
        GeneralSettings.autoOrientation = (self.orientationSelector.currentIndex() == 1)
        self.emit(SIGNAL("autoOrientationChanged()"))
        QMaemo5InformationBox.information(self,  "Your settings have been saved")
        self.accept()
        
class SwitchAccountDialog(QDialog, Ui_SwitchAccountDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        for username in YouTubeAPISettings.userDict.iterkeys():
            item = QListWidgetItem(username)
            item.setTextAlignment(Qt.AlignCenter)
            self.listWidget.addItem(item)
            if username == youtubeservice.YouTubeDataService.currentUser:
                self.listWidget.setCurrentItem(item)
        self.show()

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        username = item.text()
        try:
            youtubeservice.YouTubeDataService.youtubeLogin(username)
            QMaemo5InformationBox.information(self, "You are now signed in to YouTube as \'%s\'" % username)
        except:
            QMaemo5InformationBox.information(self, "Unable to sign in to your YouTube account")   
        self.accept()         
        
class AddAccountDialog(QDialog, Ui_AddAccountDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.orientationChanged()
        self.passwordEdit.setEchoMode(QLineEdit.Password)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.show()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 550)
            self.usernameEdit.setGeometry(QRect(10, 41, 460, 70))
            self.emailEdit.setGeometry(QRect(10, 162, 460, 70))
            self.passwordEdit.setGeometry(QRect(10, 283, 460, 70))
            self.label.setGeometry(QRect(10, 10, 131, 31))
            self.label_2.setGeometry(QRect(10, 121, 181, 31))
            self.label_3.setGeometry(QRect(10, 242, 151, 31))
            self.signInButton.setGeometry(QRect(10, 463, 460, 70))
            self.defaultCheckBox.setGeometry(QRect(10, 373, 460, 70))
        else:
            self.resize(800, 380)
            self.usernameEdit.setGeometry(QRect(10, 50, 460, 70))
            self.emailEdit.setGeometry(QRect(10, 170, 460, 70))
            self.passwordEdit.setGeometry(QRect(10, 290, 460, 70))
            self.label.setGeometry(QRect(10, 10, 131, 31))
            self.label_2.setGeometry(QRect(10, 130, 181, 31))
            self.label_3.setGeometry(QRect(10, 250, 151, 31))
            self.signInButton.setGeometry(QRect(640, 290, 150, 70))
            self.defaultCheckBox.setGeometry(QRect(480, 50, 310, 70))
        

    @pyqtSignature("")
    def on_signInButton_clicked(self):
        username = self.usernameEdit.text()
        email = self.emailEdit.text()
        password = self.passwordEdit.text()
        try:
            if self.defaultCheckBox.isChecked() or YouTubeAPISettings.userDict == {}:
                YouTubeAPISettings.defaultUser = username
            YouTubeAPISettings.userDict.update({username: (email, password)})
            youtubeservice.YouTubeDataService.youtubeLogin(username)
            QMaemo5InformationBox.information(self, "Account added. You are now signed in to YouTube as \'%s\'" % username)
            self.accept()
        except:
            del(YouTubeAPISettings.userDict[username])
            QMaemo5InformationBox.information(self, "Unable to sign in to your YouTube account. Please check your account details")

class ManageAccountsDialog(QDialog, Ui_ManageAccountsDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.orientationChanged()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        for username in YouTubeAPISettings.userDict.iterkeys():
            item = QListWidgetItem(username)
            item.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
            self.listWidget.addItem(item)
        self.show()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 480)
            self.listWidget.setGeometry(QRect(10, 10, 460, 220))
            self.newButton.setGeometry(QRect(10, 230, 460, 70))
            self.editButton.setGeometry(QRect(10, 310, 460, 70))
            self.deleteButton.setGeometry(QRect(10, 390, 460, 70))
        else:
            self.resize(800, 250)
            self.listWidget.setGeometry(QRect(10, 10, 600, 230))
            self.newButton.setGeometry(QRect(640, 10, 150, 70))
            self.editButton.setGeometry(QRect(640, 90, 150, 70))
            self.deleteButton.setGeometry(QRect(640, 170, 150, 70))
            

    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self, item):
        self.editButton.setEnabled(True)
        self.deleteButton.setEnabled(True)
        
    @pyqtSignature("")
    def on_newButton_clicked(self):
        addAccountDialog = AddAccountDialog(self)
        self.connect(addAccountDialog,  SIGNAL("accepted()"),  self.accept)

    @pyqtSignature("")
    def on_editButton_clicked(self):
        username = self.listWidget.currentItem().text()
        editAccountDialog = EditAccountDialog(self, username)
        self.connect(editAccountDialog,  SIGNAL("accepted()"),  self.accept)

    @pyqtSignature("")
    def on_deleteButton_clicked(self):
        self.username = self.listWidget.currentItem().text()
        if self.username == youtubeservice.YouTubeDataService.currentUser:
            QMaemo5InformationBox.information(self, "You are currently signed in to YouTube using this account")
        else:
            confirmDeleteDialog = ConfirmDeleteDialog(self, self.username)
            self.connect(confirmDeleteDialog, SIGNAL("deleteConfirmed()"), self.deleteAccount)

    def deleteAccount(self):
        try:
            del(YouTubeAPISettings.userDict[self.username])
            QMaemo5InformationBox.information(self, "You have deleted the account \'%s\'" % self.username)
        except:
            QMaemo5InformationBox.information(self, "Unable to delete the account")
        self.accept()

class EditAccountDialog(QDialog, Ui_EditAccountDialog):
    def __init__(self, parent, username):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.usernameEdit.setText(username)
        loginInfo = YouTubeAPISettings.userDict.get(username)
        email = loginInfo[0]
        password = loginInfo[1]
        self.emailEdit.setText(email)
        self.passwordEdit.setText(password)
        self.passwordEdit.setEchoMode(QLineEdit.Password)
        if YouTubeAPISettings.defaultUser == username:
            self.defaultCheckBox.setChecked(True)
        self.show()

    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 610)
            self.defaultCheckBox.setGeometry(QRect(10, 370, 460, 70))
            self.saveButton.setGeometry(QRect(10, 530, 460, 70))
            self.editButton.setGeometry(QRect(10, 450, 460, 70))
        else:
            self.resize(800, 380)
            self.defaultCheckBox.setGeometry(QRect(480, 50, 310, 70))
            self.saveButton.setGeometry(QRect(640, 290, 150, 70))
            self.editButton.setGeometry(QRect(640, 200, 150, 70))


    @pyqtSignature("")
    def on_editButton_clicked(self):
        self.usernameEdit.setEnabled(True)
        self.emailEdit.setEnabled(True)
        self.passwordEdit.setEnabled(True)
        self.defaultCheckBox.setEnabled(True)
        self.saveButton.setEnabled(True)

    @pyqtSignature("")
    def on_saveButton_clicked(self):
        username = self.usernameEdit.text()
        email = self.emailEdit.text()
        password = self.passwordEdit.text()
        try:
            YouTubeAPISettings.update({username: (email, password)})
            currentUser = youtubeservice.YouTubeDataService.currentUser
            youtubeservice.YouTubeDataService.youtubeLogin(username)
            if self.defaultCheckBox.isChecked():
                YouTubeAPISettings.defaultUser = username
            QMaemo5InformationBox.information(self, "YouTube account details for \'%s\' successfully verified" % username)
            youtubeservice.YouTubeDataService.youtubeLogin(currentUser)            
        except:
            QMaemo5InformationBox.information(self, "Unable to verify the YouTube account details")
        self.accept()
        
class NoAccountFoundDialog(QDialog,  Ui_NoAccountFoundDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.show()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 280)
            self.yesButton.setGeometry(QRect(10, 120, 460, 70))
            self.dontAskButton.setGeometry(QRect(10, 200, 460, 70))
            self.confirmLabel.setGeometry(QRect(10, 10, 460, 100))
        else:
            self.resize(800, 170)
            self.yesButton.setGeometry(QRect(640, 10, 150, 70))
            self.dontAskButton.setGeometry(QRect(640, 90, 150, 70))
            self.confirmLabel.setGeometry(QRect(10, 10, 620, 150))
            
    @pyqtSignature("")
    def on_yesButton_clicked(self):
        addAccountDialog = AddAccountDialog(self)
        self.connect(addAccountDialog,  SIGNAL("accepted()"),  self.accept)
        
    @pyqtSignature("")
    def on_dontAskButton_clicked(self):
        YouTubeAPISettings.raiseNoAccountFoundDialog = False

class TwitterAuthorisationDialog(QDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Twitter Authorization")
        self.webView = QWebView(self)
        self.webView.setZoomFactor(0.6)        
        self.pinLabel = QLabel("Enter pin code", self)
        self.pinLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.pinEdit = QLineEdit(self)
        self.submitButton = QPushButton("Submit", self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.connect(self.submitButton, SIGNAL("clicked()"), self.getTwitterAccess)
        self.connect(self.webView, SIGNAL("loadFinished(bool)"), self.loadFinished)
        self.webView.load(QUrl("https://twitter.com/"))
        QTimer.singleShot(1000, self.loadTwitterPage)
        self.show()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 510)
            self.webView.setGeometry(QRect(10, 10, 460, 300))
            self.pinLabel.setGeometry(QRect(10, 320, 400, 30))
            self.pinEdit.setGeometry(QRect(10, 350, 460, 70))
            self.submitButton.setGeometry(QRect(10, 430, 460, 70))
        else:
            self.resize(800, 370)
            self.webView.setGeometry(QRect(10, 10, 590, 250))
            self.pinLabel.setGeometry(QRect(10, 260, 400, 30))
            self.pinEdit.setGeometry(QRect(10, 290, 590, 70))
            self.submitButton.setGeometry(QRect(640, 290, 150, 70))
            
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
        
    def loadFinished(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
        
    def loadTwitterPage(self):
        self.toggleBusy(True)
        try:
            url = Twitter.getAuthorisationUrl()
            self.webView.load(QUrl(url))
        except:
            QMaemo5InformationBox.information(self, "Unable to connect to Twitter")
        self.toggleBusy()
            
    def getTwitterAccess(self):
        if self.pinEdit.text() != "":
            pincode = unicode(self.pinEdit.text(), "utf-8")
            self.toggleBusy(True)
            try:
                accessTokenKey, accessTokenSecret = Twitter.getAccessToken(pincode)
                VideoSharingSettings.twitterAccessTokenKey = accessTokenKey
                VideoSharingSettings.twitterAccessTokenSecret = accessTokenSecret
                QMaemo5InformationBox.information(self, "YTube is now authorized to access your Twitter account")
                VideoSharingSettings.raiseTwitterAuthorisationDialog = False
                self.accept()
            except Exception, e:
                QMaemo5InformationBox.information(self, "Unable to complete authorization. Please check the pin code and try again")
            self.toggleBusy()
                
class ShareViaTwitterDialog(QDialog):
    def __init__(self, parent, videoUrl):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Share Via Twitter")
        self.messageEdit = QTextEdit(videoUrl, self)
        self.charLabel = QLabel(self)
        self.charLabel.setStyleSheet("color: rgb(120, 120, 120)")
        self.setCharCount()
        self.submitButton = QPushButton("Submit", self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.connect(self.messageEdit, SIGNAL("textChanged()"), self.setCharCount)
        self.connect(self.submitButton, SIGNAL("clicked()"), self.shareViaTwitter)
        self.show()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 270)
            self.charLabel.setGeometry(QRect(10, 10, 200, 30))
            self.messageEdit.setGeometry(QRect(10, 40, 460, 140))
            self.submitButton.setGeometry(QRect(10, 190, 460, 70))
        else:
            self.resize(800, 190)
            self.charLabel.setGeometry(QRect(10, 10, 200, 30))
            self.messageEdit.setGeometry(QRect(10, 40, 590, 140))
            self.submitButton.setGeometry(QRect(640, 110, 150, 70))
            
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
            
    def setCharCount(self):
        messageLength = self.messageEdit.toPlainText().length()
        count = unicode(140 - messageLength)
        self.charLabel.setText(count)
        
    def shareViaTwitter(self):
        message = unicode(self.messageEdit.toPlainText(), "utf-8")
        if message != "":
            self.toggleBusy(True)
            try:
                Twitter.postMessage(message)
                QMaemo5InformationBox.information(self, "Your video and message have been posted to Twitter")
                self.accept()
            except Exception, e:
                QMaemo5InformationBox.information(self, "Unable to post message to Twitter")
            self.toggleBusy()
            
class FacebookAuthorisationDialog(QDialog):
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Facebook Authorization")
        self.webView = QWebView(self)
        self.submitButton = QPushButton("Done", self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.connect(self.submitButton, SIGNAL("clicked()"), self.getFacebookAccess)
        self.connect(self.webView, SIGNAL("loadFinished(bool)"), self.loadFinished)
        self.show()
        self.loadFacebookPage()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 400)
            self.webView.setGeometry(QRect(10, 10, 460, 300))
            self.submitButton.setGeometry(QRect(10, 320, 460, 70))
        else:
            self.resize(800, 270)
            self.webView.setGeometry(QRect(10, 10, 590, 250))
            self.submitButton.setGeometry(QRect(640, 190, 150, 70))
            
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
        
    def loadFinished(self):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, False)
        
    def loadFacebookPage(self):
        self.toggleBusy(True)
        clientId = Facebook.clientId
        try:
            url = "https://graph.facebook.com/oauth/authorize?client_id=%s&redirect_uri=http://www.facebook.com/connect/login_success.html&type=user_agent&display=popup&scope=publish_stream,offline_access" % clientId
            self.webView.load(QUrl(url))
        except:
            QMaemo5InformationBox.information(self, "Unable to connect to Facebook")
            self.toggleBusy()
            
    def getFacebookAccess(self):
        self.toggleBusy(True)
        accessUrl = self.webView.url().toString()
        try:
            accessToken = unicode(accessUrl, "utf-8").split("=")[1].split("&")[0] #Had to do this this because QUrl.queryItemValue() wouldn't work.
            VideoSharingSettings.facebookAccessToken = accessToken
            QMaemo5InformationBox.information(self, "YTube is now authorized to access your Facebook account")
            VideoSharingSettings.raiseFacebookAuthorisationDialog = False
            self.accept()
        except Exception, e:
            QMaemo5InformationBox.information(self, "Unable to confirm Facebook authorization")
        self.toggleBusy()
            
class ShareViaFacebookDialog(QDialog):
    def __init__(self, parent, videoUrl):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Share Via Facebook")
        self.videoUrl = videoUrl
        self.messageEdit = QTextEdit(self)
        self.submitButton = QPushButton("Submit", self)
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        self.orientationChanged()
        self.connect(self.submitButton, SIGNAL("clicked()"), self.shareViaFacebook)
        self.show()
        
    def orientationChanged(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.resize(480, 230)
            self.messageEdit.setGeometry(QRect(10, 10, 460, 140))
            self.submitButton.setGeometry(QRect(10, 150, 460, 70))
        else:
            self.resize(800, 160)
            self.messageEdit.setGeometry(QRect(10, 10, 590, 140))
            self.submitButton.setGeometry(QRect(640, 80, 150, 70))
            
    def toggleBusy(self, isBusy = False):
        self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, isBusy)
            
    def shareViaFacebook(self):
        message = unicode(self.messageEdit.toPlainText(), "utf-8")
        if message != "":
            self.toggleBusy(True)
            try:
                Facebook.postMessage(message, self.videoUrl)
                QMaemo5InformationBox.information(self, "Your video and message have been posted to Facebook")
                self.accept()
            except Exception, e:
                QMaemo5InformationBox.information(self, "Unable to post message to Facebook")
            self.toggleBusy()
