# -*- coding: utf-8 -*-
from re import sub
import dbus
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.phonon import Phonon
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from youtubeservice import YouTubeDataService, YouTubeVideoFeed
from youtubeconfig import VideoPlaybackSettings, VideoDownloadSettings
from Ui_videoplaybackwindow import Ui_VideoPlaybackWindow

class VideoPlaybackWindow(QMainWindow, Ui_VideoPlaybackWindow):
    def __init__(self, parent, video=None, playlist=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.player = Phonon.VideoPlayer(self)
        self.player.setVisible(False)
        self.layout.addWidget(self.player)
        self.video = video
        self.playlist = playlist
        self.seekBar = Phonon.SeekSlider(self.player.mediaObject(), self.toolBar)
        self.toolBar.addWidget(self.elapsedtime)
        self.toolBar.addWidget(self.seekBar)
        self.toolBar.addWidget(self.durationLabel)
        self.player.mousePressEvent = self.toggleControls
        self.timer = QTimer(self)
        self.player.mediaObject().setPrefinishMark(5000)
        self.player.mediaObject().setTickInterval(0)
        self.connect(self.timer, SIGNAL("timeout()"), self.toggleSwitch)
        self.connect(self.player.mediaObject(), SIGNAL("prefinishMarkReached(qint32)"), self.queueNextVideo)
        self.connect(self.player.mediaObject(), SIGNAL("currentSourceChanged(const Phonon::MediaSource&)"), self.displayCurrentVideoInfo)
        self.connect(self.player.mediaObject(), SIGNAL("stateChanged(Phonon::State, Phonon::State)"), self.stateChanged)
        self.connect(self.player.mediaObject(), SIGNAL("finished()"), self.on_stopButton_clicked)
        self.connect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)        
        self.currentVideo = 0
        self.showFullScreen()
        if self.video != None:
            mediasource = self.getMediaSource(self.video)
        else:
            mediasource = self.getMediaSource(self.playlist[0])
        self.player.play(mediasource)
        self.keepDisplayOn()
        for button in (self.playButton, self.pauseButton, self.stopButton, self.previousButton, self.nextButton):            
            button.setStyleSheet("background-color: rgb(0, 0, 0, 255)")
            self.connect(button,  SIGNAL("pressed()"), self.changeButtonStyleSheet)
            self.connect(button,  SIGNAL("released()"), self.changeButtonStyleSheet)
            
    def stateChanged(self, newState, oldState):
        if newState == Phonon.ErrorState:
            QMaemo5InformationBox.information(self, "Error")
            self.on_stopButton_clicked()
        elif newState == Phonon.BufferingState:
            self.player.setVisible(False)
            self.loadingLabel.setVisible(True)            
        elif newState == Phonon.PlayingState:
            self.player.setVisible(True)
            self.loadingLabel.setVisible(False)
            if not self.player.mediaObject().hasVideo():
                QMaemo5InformationBox.information(self, "Unable to connect to YouTube")
                self.on_stopButton_clicked()
        elif newState == Phonon.LoadingState:
            self.player.setVisible(False)
            self.loadingLabel.setVisible(True)

    def changeButtonStyleSheet(self):
        button = self.sender()
        if button.isDown():
            button.setStyleSheet("background-color: #4ABEFF")            
        else:
            button.setStyleSheet("background-color: rgb(0, 0, 0, 255)")
                    
    def tick(self, a):
        if a >= 10:            
            self.disconnect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)
            self.connect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.ticking)
            if self.playlist != None:
                try:
                    self.showPlaylistBar()
                except:
                    pass
            else:
                try:
                    self.getVideoRelated()
                except:
                    pass

    def ticking(self, time):
        if time >= 3600000:
            hr = round(time / 3600000, 0)
            displayHr = "%d:" % hr
        else:
            displayHr = ""
        displayTime = QTime(0, (time / 60000) % 60, (time / 1000) % 60)
        self.elapsedtime.setText("%s%s" % (displayHr, displayTime.toString('mm:ss')))
        
    def keepDisplayOn(self):
        bus = dbus.SystemBus()
        mce = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mce.req_display_blanking_pause()
        QTimer.singleShot(9000, self.keepDisplayOn)
        
    def displayCurrentVideoInfo(self):
        self.toggleSwitch()
        if self.playlist == None:
            videoTitle = unicode(self.video.media.title.text, "utf-8")
            self.durationLabel.setText("%s" % self.fT(float(self.video.media.duration.seconds)))
        else:
            videoTitle = unicode(self.playlist[self.currentVideo].media.title.text, "utf-8")
            self.durationLabel.setText("%s" % self.fT(float(self.playlist[self.currentVideo].media.duration.seconds)))
        self.titleLabel.setText("%s" % videoTitle)
        self.setWindowTitle("%s" % videoTitle)
        QMaemo5InformationBox.information(self, "Playing \'%s\'" % videoTitle)

    def fT(self, a):
        if a >= 3600:
            b = "%d:" % round(a / 3600, 0)
        else:
            b = ""
        c = QTime(0, (a / 60) % 60, a % 60)
        d="%s%s" % (b, c.toString('mm:ss'))
        return d        

    def toggleSwitch(self, a=False):
        if self.playlist != None:
            self.listWidget.setVisible(a)
            self.previousButton.setVisible(a)
            self.nextButton.setVisible(a)
        self.titleLabel.setVisible(a)
        self.toolBar.setVisible(a)
        self.stopButton.setVisible(a)
        self.playButton.setVisible((a and self.player.isPaused()))
        self.pauseButton.setVisible((a and self.player.isPlaying()))
        if a:
            self.player.mediaObject().setTickInterval(1000)            
        else:
            self.player.mediaObject().setTickInterval(0)
        
    def toggleControls(self, event=None):
        if self.toolBar.isVisible():
            self.toggleSwitch()
        else:
            self.toggleSwitch(a=True)
            self.timer.start(20000)
                  
    def getMediaSource(self, video):
        filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, sub('[\"<>:"/|?*\\\\]', "-", video.media.title.text).decode("utf-8"))
        if QFile.exists(filename):
            self.loadingLabel.setText(unicode("Please wait!\nStart loading video from device.", "utf-8"))
            mediasource = Phonon.MediaSource(filename)
        else:            
            videoUrl = YouTubeDataService.getVideoUrl(video, VideoPlaybackSettings.playbackFormat)
            if videoUrl == "":
                self.loadingLabel.setText(unicode("Error!\nVideo is only viewable on youtube website", "utf-8"))
                QTimer.singleShot(3000, self.on_stopButton_clicked)
            else:
                self.loadingLabel.setText(unicode("Please wait!\nStart loading video from YouTube.", "utf-8"))
                mediasource = Phonon.MediaSource(videoUrl)
        return mediasource
            
    def queueNextVideo(self):
        if self.playlist != None and self.video == None:
            try:
                video = self.playlist[self.currentVideo + 1]
                mediasource = self.getMediaSource(video)
                self.player.mediaObject().enqueue(mediasource)
                self.currentVideo += 1
            except:
                pass
            
    @pyqtSignature("")
    def on_previousButton_clicked(self):
        if self.playlist != None and self.player.currentTime() <= 5000:
            video = self.playlist[self.currentVideo - 1]
            mediasource = self.getMediaSource(video)
            if self.currentVideo > 0:
                self.currentVideo -= 1
                self.listWidget.item(self.currentVideo).setSelected(True)
            else:
                self.currentVideo = len(self.playlist) - 1
                self.listWidget.item(self.currentVideo).setSelected(True)
            self.player.play(mediasource)
        else:
            self.player.seek(0)
            
    @pyqtSignature("")
    def on_nextButton_clicked(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                self.currentVideo += 1
                self.listWidget.item(self.currentVideo).setSelected(True)
            except:
                video = self.playlist[0]
                self.currentVideo = 0
                self.listWidget.item(self.currentVideo).setSelected(True)
            mediasource = self.getMediaSource(video)
            self.player.play(mediasource)
            
    @pyqtSignature("")
    def on_stopButton_clicked(self):
        self.player.stop()
        if self.video != None:
            try:
                while self.yt.isRunning():
                    self.yt.wait()
            except:
                pass
            self.emit(SIGNAL("destroyed"))       
        self.player.deleteLater()
        self.close()
        
    @pyqtSignature("")
    def on_pauseButton_clicked(self):
        self.playButton.setVisible(True)
        self.pauseButton.setVisible(False)      
        self.timer.stop()
        self.player.pause()

    @pyqtSignature("")
    def on_playButton_clicked(self):
        self.pauseButton.setVisible(True)
        self.playButton.setVisible(False)     
        self.timer.start(10000)
        self.player.play()                
        
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self):
        row = self.listWidget.currentRow()
        try:
            video = self.playlist[row]
            self.currentVideo = row
        except:
            video = self.playlist[0]
            self.currentVideo = 0
        mediasource = self.getMediaSource(video)
        self.player.play(mediasource)

    def showPlaylistBar(self):        
        for video in self.playlist:
            thumbUrl = video.media.thumbnail[0].url
            thumbnail = YouTubeDataService.getVideoThumbnail(thumbUrl)
            icon = QIcon()
            icon.addPixmap(thumbnail, QIcon.Normal, QIcon.Off)
            item = QListWidgetItem(self.listWidget)
            item.setIcon(icon)            
            self.listWidget.addItem(item)

    def getVideoRelated(self):
        for link in self.video.link:
            if link.rel.split("#")[-1] == "video.related":
                videoFeed = link.href
        self.yt = YouTubeVideoFeed(self, videoFeed, 20)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.showVideoRelatedBar)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.dataloaded)
        self.yt.start()
        
    def showVideoRelatedBar(self, thumbdata):
        row, thumbnail = thumbdata
        icon = QIcon()
        icon.addPixmap(thumbnail, QIcon.Normal, QIcon.Off)
        item = QListWidgetItem(self.listWidget)
        item.setIcon(icon)            
        self.listWidget.addItem(item)

    def dataloaded(self):
        self.playlist = self.yt.videoList
        self.playlist.insert(0, self.video)
        self.disconnect(self.yt, SIGNAL("feedCompleted(bool)"), self.dataloaded)
