import os
import sys
import time
import pickle

DL_DIR = "/home/user/MyDocs/.videos/ytcli" 
DL_LOG = "/tmp/ytcli_log"
Q_RUNLOCK = "/tmp/ytcli_runlock"
Q_LOCK = "/tmp/ytcli_qlock"
Q_FILE = "/tmp/ytcli_q"
Q_PID = "/tmp/ytcli_qpid"

# exit immediately if this script seems to be runnin already
runlock = ""
try:
  runlock = os.open(Q_RUNLOCK, os.O_CREAT|os.O_EXCL|os.O_RDWR)
  pidfile = open(Q_PID, "wb")
  pidfile.truncate()
  pidfile.write(str(os.getpid()))
  pidfile.close()
except:
  sys.exit(0)

def download(vid):
  if not os.path.exists(DL_DIR):
    os.makedirs(DL_DIR)
  call = ("youtube-dl -c -t --max-quality '34'" + 
            " \"" + vid[1] + "\"")
  import subprocess
  import shlex
  call = shlex.split(call)
  import signal
  log = open(DL_LOG, "wb")
  log.truncate()
  dl = subprocess.Popen(call, cwd=DL_DIR, stdout=log)
  def kill_handler(sig, frame):
    os.kill(dl.pid, signal.SIGKILL)
    log.close()
    os.close(runlock)
    os.remove(Q_RUNLOCK)
    sys.exit(0)
  def cancel_handler(sig, frame):
    # in this case we just kill the current download and move on
    os.kill(dl.pid, signal.SIGKILL)
    log.close()
  signal.signal(signal.SIGUSR1, kill_handler)
  signal.signal(signal.SIGUSR2, cancel_handler)
  dl.wait()
  call = ("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\'" + vid[0] + " completed\'")
  os.system(call)

def acquire_lock():
  while True:
    try:
      lock = os.open(Q_LOCK, os.O_CREAT|os.O_EXCL|os.O_RDWR)
      return lock
    except:
      time.sleep(1)

def free_lock(lock):
  os.close(lock)
  os.remove(Q_LOCK)

while True:
  try:
    l = {}
    lock = acquire_lock()
    if os.path.isfile(Q_FILE):
      f = open(Q_FILE, "r")
      l = pickle.load(f)
    else:
      break
    if len(l) == 0:
      break
    f.close()
    free_lock(lock)
    vid = l[0]
    download(vid)
    lock = acquire_lock()
    if os.path.isfile(Q_FILE):
      f = open(Q_FILE, "r")
      l = pickle.load(f)
    else:
      break
    f.close()
    new_l = {}
    counter = 0
    for elem in l:
      if l[elem][0] != vid[0]:
        new_l[counter] = l[elem]
        counter += 1
    f = open(Q_FILE, "w")
    f.truncate()
    pickle.dump(new_l, f)
    f.close()
    free_lock(lock)
  except IOError:
    print "There has been a fatal error handling " + Q_FILE

free_lock(lock)
os.close(runlock)
os.remove(Q_RUNLOCK)

