import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import hildon
import math
import cairo
from threading import Thread

class tangogps_friendDownloader(Thread):
    def __init__(self,pa):
        Thread.__init__(self)
        self.pa = pa

    def parseData(self, data_res):
        t = data_res.split( "|" )
        for f in t:
            i = f.split("#")
            if len(i) == 7 and float(i[2]) < 180 and float(i[2]) >-180 and float(i[3])<180 and float(i[3]) >-180:
                friend = [
                        float(i[2]),
                        float(i[3]),
                        self.pa.get_name(),
                        i[1],
                        self.pa.ico_friend,
                        None,
                        self.pa.from_zoom
                        ]
                self.pa.friend.append( friend )
        print "tangogps friend found ",len(self.pa.friend),"frend"

    def downloadData(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("www.tangogps.org")
        conn.request("GET", "/friends/update_pos.php")
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "tangogps_friendDownloader downolad"
        data_res = self.downloadData()
        print "tangogps_friendDownloader parse"
        self.parseData(data_res)
        print "geonames downolad"
        self.pa.do_draw_friend()
        print "tangogps_friendDownloader DONE"


class tangogps_friend:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "tangogps_ico.png"
        self.ui_menu_main = 1
        self.ui_menu_left = 0
        self.ui_search = 1
        self.from_zoom = 4
        self.ui_thread = 0

        self.ico_friend = gdk.pixbuf_new_from_file( './plugins/tangogps-friend.png' )

        self.from_zoom = 3

        print "__init__ tangogps friend"

    def do_draw_friend(self):
        for p in self.friend:
            self.osmMapa.marker_add([
                        p[0],
                        p[1],
                        p[2],
                        p[3],
                        p[4],
                        p[5],
                        p[6]
                        ])

    def clean_layer(self):
        self.friend = []
        self.osmMapa.marker_layer_clean( self.get_name() )

    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):
        self.friend = []
        self.osmMapa.marker_layer_clean(self.get_name())
        t = tangogps_friendDownloader( self )
        t.start()
        return self

    def on_bt_update(self, w, dialog):
        self.clean_layer()
        self.makeInit()
        dialog.destroy()

    def get_menu_widgets(self, dialog):
        bt_update = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"update")
        bt_update.connect("clicked", self.on_bt_update, dialog)
        return bt_update

    def search_query(self, str):
        tr = []
        for p in self.friend:
            item_str = ("%s" % (p[3]))
            #print "item_str[",item_str,"] p[3][",p[3],"] str[",str,"]"
            if item_str.find(str) <> -1:
                tr.append(p)
        return tr

    def get_name(self):
        return "tangogps friend"


    def do_button_press(self, gpsmap, gdkeventbutton):
        pass