import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
from threading import Thread

from db_helper import *


class dbWiki(db_helper):
    def __init__(self):
        db_helper.__init__(self)
    
    def set_struct(self):
         self.struct = {
            'wiki' : {
                      'lat':     "float",
                      'lon':     "float",
                      'title':   "text",
                      'summary': "text",
                      'url':     "text",
                      'rank':    "int"                      
                      }
            }

    def add_item(self, point):
        if not self.one_value('wiki', 'id', "lat=%f and lon=%f"%(point[0],point[1])):
            self.insert('wiki',
                    {
                        'lat':     point[0],
                        'lon':     point[1],
                        'title':   point[3],
                        'summary': point[7]['desc'],
                        'url':     point[7]['url'],
                        'rank':    point[7]['rank']
                        })

    def get_items(self,t_ln, b_ln, t_lt, b_lt,pixbuf, name, id_exclu,limit):
        tr = []
        # t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
        ex = ""
        print id_exclu
        if len(id_exclu)>1:
            i = ",".join(id_exclu)
            ex = "and id NOT IN (%s)"% i
        elif len(id_exclu)==1:
            ex = "and id NOT IN (%i)"% id_exclu
                                               
        res = self.select('wiki',"*",
            "%f < lon and %f > lon and %f > lat and %f < lat %s order by rank desc limit %i" % ( t_ln, b_ln, t_lt, b_lt, ex,limit) )
        for i in res:
            rank = i['rank']*0.5
            ico = pixbuf
            h = int(ico.get_width()*rank)
            if h< 15:
                h = 15
            ico = ico.scale_simple( h,h, gtk.gdk.INTERP_HYPER )
            point = [
                    i['lat'],
                    i['lon'],
                    'wiki',
                    i['title'],
                    ico,
                    None,
                    3,
                    {
                        'url':i['url'],
                        'desc':i['summary'],
                        'rank': rank,
                        'id': i['id']
                        }
                    ]
            id_exclu.append("%s"%i['id'])
            tr.append( point )
        
        return tr

class wikiDownloader(Thread):
    def __init__(self,pa, lat,lon,radius):
        Thread.__init__(self)
        self.pa = pa
        self.lat = lat
        self.lon = lon
        self.radius = radius


    def parseData(self, data_res):
        tr = []        
        doc = xml.dom.minidom.parseString(data_res)
        try:
            if self.pa.use_db:
                db = dbWiki()
            for e in doc.getElementsByTagName("entry"):
                lt = float(e.getElementsByTagName("lat")[0].childNodes[0].data)
                ln = float(e.getElementsByTagName("lng")[0].childNodes[0].data)
                rank = float(e.getElementsByTagName("rank")[0].childNodes[0].data)/100
                title = e.getElementsByTagName("title")[0].childNodes[0].data
                desc = e.getElementsByTagName("summary")[0].childNodes[0].data
                url = e.getElementsByTagName("wikipediaUrl")[0].childNodes[0].data
                title = e.getElementsByTagName("title")[0].childNodes[0].data
                
                
                ico = self.pa.ico_wiki
                h = int(ico.get_width()*rank)
                if h< 15:
                    h = 15
                ico = ico.scale_simple( h,h, gtk.gdk.INTERP_HYPER )
                point = [
                        lt,
                        ln,
                        self.pa.get_name(),
                        title,
                        ico,
                        None,
                        3,
                        {
                            'url':url,
                            'desc':desc,
                            'rank': rank
                            }
                        ]
                tr.append( point )
                if self.pa.use_db:
                    db.add_item(point)
            
            
        except Exception, e:
            print "wiki parse ERROR ",e
        
        
        return tr
        print "wiki friend found ",len(self.pa.friend),"frend"

    def downloadData(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("ws.geonames.org")
        url = "/findNearbyWikipedia?lat=%f&lng=%f&radius=%i&maxRows=%i" % (self.lat, self.lon, self.radius,self.pa.limit)
        print "url[",url,"]"
        conn.request("GET", url)
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "wiki downolad"
        data_res = self.downloadData()
        print "wiki parse"
        tr = self.parseData(data_res)
        self.pa.rebuild_markers( tr )
        print "wiki DONE results(%i)"% len(tr)
        self.pa.t_run = 0
        
class wiki:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG

        self.ico = "Wikipedia_Icon.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 0
        
        self.t_run = 0
        self.markers = []
        self.osm_box = []
        self.zoom_old = 0
        self.limit = 5
        
        self.use_db = 0
        
        if self.use_db:
            self.db = dbWiki()
            self.db_ids_exclude = []
        self.osmMapa = osmMapa
        self.ico_wiki = gdk.pixbuf_new_from_file("./plugins/Wikipedia_Icon_48_48.png")
        
        self.from_zoom = 6

        print "__init__ wiki"

    def get_name(self):
        return "wiki"

    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):        
        print "wiki makeInit"
      
    def rebuild_markers(self, res ):
        for m in res:
            self.osmMapa.marker_add( m, True )
    def do_draw(self, gpsmap, gdkdrawable):
        print "wiki do_draw"
        osm_zoom = self.osmMapa.osm.props.zoom
        if self.osmMapa.osm_box <> self.osm_box or osm_zoom <> self.zoom_old:
            print "wiki do_draw 1 run",self.t_run
            if self.t_run == 0:
                self.t_run = 1
                self.osm_box = self.osmMapa.osm_box
                if self.osmMapa.osm.props.zoom <> self.zoom_old:
                    self.osmMapa.marker_layer_clean( self.get_name( ))
                    self.db_ids_exclude = []
                    self.limit = 15
                    self.zoom_old = self.osmMapa.osm.props.zoom
                else:
                    self.limit = 5
            
                
                if osm_zoom >= 14:
                    print "wiki do_draw 2"
                    t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
                    t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
                    lat = self.osmMapa.osm.props.latitude
                    lon = self.osmMapa.osm.props.longitude
                    t_lt = self.osmMapa.osm_box[0]
                    rad = int(self.osmMapa.distance( lat, lon, t_lt, lon  ))
                    
                    if rad >= 20:
                        rad = 20
                    elif rad == 0:
                        rad = 1
                    t = wikiDownloader( self, lat,lon,rad )
                    t.run()
                    
                    
                    # db points
                    print "wiki points",len(self.db_ids_exclude)
                    if self.use_db:
                        if len(self.db_ids_exclude)>60:
                            self.db_ids_exclude = []
                            self.osmMapa.marker_layer_clean( self.get_name( ))
                        points = self.db.get_items(t_ln, b_ln, t_lt, b_lt, self.ico_wiki, self.get_name(), self.db_ids_exclude, self.limit*3)
                        for m in points:
                            self.osmMapa.marker_add( m, True )
                    
                else:
                    self.t_run = 0
                

    def get_menu_widgets(self, dialog):
        return None