import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import hildon
import math


from threading import Thread

class rcspot_eventyDownloader(Thread):
    def __init__(self,pa):
        Thread.__init__(self)
        self.pa = pa



    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        for event in doc.getElementsByTagName("event"):
            e = [
                float(event.getElementsByTagName("lon")[0].childNodes[0].data),
                float(event.getElementsByTagName("lat")[0].childNodes[0].data),
                self.pa.get_name(),
                "%s\n%s" %( event.getElementsByTagName("start_str")[0].childNodes[0].data, event.getElementsByTagName("nazwa")[0].childNodes[0].data),
                self.pa.ico_rc,
                None,
                self.pa.from_zoom
                ]
            self.pa.eventy.append( e )
        print "rcspot found ",len(self.pa.eventy),"events"

    def downloadXml(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("www.rcspot.pl")
        conn.request("GET", "/api_xml.php?p=eventy")
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "rcspot_eventyDownloader downolad"
        res = self.downloadXml()
        print "rcspot_eventyDownloader parse"
        self.parseXml( res )
        self.pa.do_draw_address()
        print "rcspot_eventyDownloader DONE"

class rcspot_eventy:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa
        self.ico = "rcspot.png"

        self.ui_menu_main = 1
        self.ui_menu_left = 0
        self.ui_search = 1
        self.from_zoom = 4

        self.ico_rc = gdk.pixbuf_new_from_file( './plugins/rcspot.png' )
        print "__init__ rcspot eventy"


    def do_draw_address(self):
        for p in self.eventy:
            self.osmMapa.marker_add([
                        p[0],
                        p[1],
                        p[2],
                        p[3],
                        p[4],
                        p[5],
                        p[6]
                        ])

    def clean_layer(self):
        self.eventy = []
        self.osmMapa.marker_layer_clean( self.get_name() )

    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):
        self.eventy = []
        self.images = []
        t = rcspot_eventyDownloader(self)
        t.start()

        return None

    def search_query(self, str):
        tr = []
        for p in self.eventy:
            item_str = ("%s" % (p[3]))
            if item_str.find(str) <> -1:
                tr.append([
                        p[0],
                        p[1],
                        p[2],
                        p[3],
                        p[4],
                        p[5],
                        p[6]
                        ])
        return tr

    def on_bt_update(self, w, dialog):
        self.clean_layer()
        self.makeInit()
        dialog.destroy()

    def get_menu_widgets(self, dialog):
        bt_update = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"update")
        bt_update.connect("clicked", self.on_bt_update, dialog)
        return bt_update

    def get_name(self):
        return "rcspot eventy"

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass