import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
from threading import Thread


class wikiDownloader(Thread):
    def __init__(self,pa, lat,lon,radius):
        Thread.__init__(self)
        self.pa = pa
        self.lat = lat
        self.lon = lon
        self.radius = radius


    def parseData(self, data_res):
        tr = []        
        doc = xml.dom.minidom.parseString(data_res)
        try:
            for e in doc.getElementsByTagName("entry"):
                lt = float(e.getElementsByTagName("lat")[0].childNodes[0].data)
                ln = float(e.getElementsByTagName("lng")[0].childNodes[0].data)
                rank = float(e.getElementsByTagName("rank")[0].childNodes[0].data)/100
                title = e.getElementsByTagName("title")[0].childNodes[0].data
                desc = e.getElementsByTagName("summary")[0].childNodes[0].data
                url = e.getElementsByTagName("wikipediaUrl")[0].childNodes[0].data
                title = e.getElementsByTagName("title")[0].childNodes[0].data
                
                
                ico = self.pa.ico_wiki
                h = int(ico.get_width()*rank)
                if h< 15:
                    h = 15
                ico = ico.scale_simple( h,h, gtk.gdk.INTERP_HYPER )
                
                tr.append( [
                        lt,
                        ln,
                        self.pa.get_name(),
                        title,
                        ico,
                        None,
                        3,
                        {
                            'url':url,
                            'desc':desc
                            }
                        ])
            
            
        except Exception, e:
            print "wiki parse ERROR ",e
        
        
        return tr
        print "wiki friend found ",len(self.pa.friend),"frend"

    def downloadData(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("ws.geonames.org")
        url = "/findNearbyWikipedia?lat=%f&lng=%f&radius=%i&maxRows=%i" % (self.lat, self.lon, self.radius,self.pa.limit)
        print "url[",url,"]"
        conn.request("GET", url)
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "wiki downolad"
        data_res = self.downloadData()
        print "wiki parse"
        tr = self.parseData(data_res)
        self.pa.rebuild_markers( tr )
        print "wiki DONE results(%i)"% len(tr)
        self.pa.t_run = 0


class wiki:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG

        self.ico = "Wikipedia_Icon.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 0
        
        self.t_run = 0
        self.markers = []
        self.osm_box = []
        self.zoom_old = 0
        self.limit = 5
        
        self.osmMapa = osmMapa
        self.ico_wiki = gdk.pixbuf_new_from_file("./plugins/Wikipedia_Icon_48_48.png")
        
        self.from_zoom = 6

        print "__init__ wiki"

    def get_name(self):
        return "wiki"

    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):        
        print "wiki makeInit"
      
    def rebuild_markers(self, res ):
        for m in res:
            self.osmMapa.marker_add( m, True )
    def do_draw(self, gpsmap, gdkdrawable):
        print "wiki do_draw"
        osm_zoom = self.osmMapa.osm.props.zoom
        if self.osmMapa.osm_box <> self.osm_box or osm_zoom <> self.zoom_old:
            if self.t_run == 0: 
                self.t_run = 1
                self.osm_box = self.osmMapa.osm_box
                if self.osmMapa.osm.props.zoom <> self.zoom_old:
                    self.osmMapa.marker_layer_clean( self.get_name( ))
                    self.limit = 15
                    self.zoom_old = self.osmMapa.osm.props.zoom
                else:
                    self.limit = 5
            
                
                if osm_zoom >= 10:
                    t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
                    t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
                    lat = self.osmMapa.osm.props.latitude
                    lon = self.osmMapa.osm.props.longitude
                    t_lt = self.osmMapa.osm_box[0]
                    rad = int(self.osmMapa.distance( lat, lon, t_lt, lon  ))
                    
                    if rad >= 20:
                        rad = 20
                    elif rad == 0:
                        rad = 1
                    t = wikiDownloader( self, lat,lon,rad )
                    t.run()
                

    def get_menu_widgets(self, dialog):
        return None