#!/usr/bin/python

"""
Copyright (C) Hadley Rich 2008 <hads@nice.net.nz>
based on main.c - with thanks to John Stowers

This is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See theF
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

"""

import math
import time
import sys
import os.path
import gtk.gdk
import gobject
import imp
import pickle
from gtk import gdk
from threading import Thread
import xml.dom.minidom,os
from xml.dom.minidom import Node
import hildon
import dbus.glib
import cairo
import time
import md5


from h_deb import *
from h_config_sl import *
from h_UI_searchDialog import *
from h_UI_mainMenuDialog import *
from h_UI_detailsWindow import *
from h_UI_welcomeScreen import *

try:
    from h_UI_selectContact import *
    send_to_contact = 1
except:
    send_to_contact = 0

from GpsManager import *
from BuildPluginsList import *


gobject.threads_init()
from dbus import glib
glib.init_threads()

gtk.gdk.threads_init()


name = "yosmapa"
version = "0.19-20"




#Try static lib first
mydir = os.path.dirname(os.path.abspath(__file__))
libdir = os.path.join(mydir, ".libs")
sys.path.insert(0, libdir)

import osmgpsmap

deb("using library: %s" % osmgpsmap.__file__)


try:
    import location
    deb("gps found!")
    gpsPresent = 1
except Exception, e:
    print "FROM ERROR location ",e
    gpsPresent = 0


try:
    from portrait import *
    autorotate = 1
except Exception, e:
    print "FROM ERROR portriat ",e
    autorotate = 0


CONFIG = {
    'zoom':       3,
    'lat':        0.0,
    'lon':        0.0,

    'engine_name':    osmgpsmap.SOURCE_OPENSTREETMAP,

    'gpxtrack':     0,
    'gpxfile':      '',

    'gpslock':      0,

    }

timing_plugins = 0
timing_osd = 0



maps_source = [
    [osmgpsmap.SOURCE_OPENSTREETMAP, "OpenStreetMap I"],
    [osmgpsmap.SOURCE_OPENSTREETMAP_RENDERER, "OpenStreetMap II"],
#    [osmgpsmap.SOURCE_OPENAERIALMAP, "OpenAerialMap"],
#    [osmgpsmap.SOURCE_OPENCYCLEMAP, "OpenCycleMap"],
#    [osmgpsmap.SOURCE_OSM_PUBLIC_TRANSPORT, "Public Transport"],
#    [osmgpsmap.SOURCE_OSMC_TRAILS, "OSMC Trails"],
    [osmgpsmap.SOURCE_MAPS_FOR_FREE, "Maps-For-Free"],
    [osmgpsmap.SOURCE_GOOGLE_STREET, "Google Maps"],
    [osmgpsmap.SOURCE_GOOGLE_SATELLITE, "Google Satellite"],
    [osmgpsmap.SOURCE_GOOGLE_HYBRID, "Google Hybrid"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_STREET, "Virtual Earth"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_SATELLITE, "Virtual Earth Satellite"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_HYBRID, "Virtual Earth Hybrid"],
    ["http://tiles.ump.waw.pl/ump_tiles/#Z/#X/#Y.png", "UMP-PL" ],


    ["http://tile2.opencyclemap.org/transport/#Z/#X/#Y.png","public transport - tile2 openstreetmap"],
    ["http://tile.xn--pnvkarte-m4a.de/tilegen/#Z/#X/#Y.png","public transport - tile xn pnvkarte m4a"],
    ["http://otile1.mqcdn.com/tiles/1.0.0/osm/#Z/#X/#Y.png","otile1 mqcdn"],
    ["http://c.tile.opencyclemap.org/cycle/#Z/#X/#Y.png","c tile opencyclemap"],
    ["http://c.www.toolserver.org/tiles/bw-noicons/#Z/#X/#Y.png","black/white - c ww toolserver"],
    ["http://tile.osmosnimki.ru/kosmo/#Z/#X/#Y.png","tile osmosnimki ru"],
    ["http://a.tile.cloudmade.com/fd093e52f0965d46bb1c6c6281022199/1/256/#Z/#X/#Y.png","a tile cloudmade"],
    ["http://b.tile.cloudmade.com/BC9A493B41014CAABB98F0471D759707/999/256/#Z/#X/#Y.png","night - b tile claudmade"],

    #[osmgpsmap.SOURCE_YAHOO_STREET, "Yahoo Maps"],
    #[osmgpsmap.SOURCE_YAHOO_SATELLITE, "Yahoo Satellite"],
    #[osmgpsmap.SOURCE_YAHOO_HYBRID, "Yahoo Hybrid"]
               ]






class YosmapaOSD(gobject.GObject, osmgpsmap.GpsMapLayer):
    def __init__(self, osmMapa):
        gobject.GObject.__init__(self)
        self.osmMapa = osmMapa

        self.plugin_ico_yoffset = 50
        self.plugin_ico_h = 60
        self.plugin_ico_test = 48

        self.pb_plus = cairo.ImageSurface.create_from_png( './imgs/i_plus.png' )
        self.pb_min = cairo.ImageSurface.create_from_png( './imgs/i_min.png' )
        self.pb_gps_on = cairo.ImageSurface.create_from_png( './imgs/i_gps_on.png' )
        self.pb_gps = cairo.ImageSurface.create_from_png( './imgs/i_gps.png' )
        self.pb_menu = cairo.ImageSurface.create_from_png( './imgs/ico_config2_64_64.png' )

        self.pb_find = cairo.ImageSurface.create_from_png( './imgs/ico_find2_48_48.png' )
        self.pb_clean = cairo.ImageSurface.create_from_png( './imgs/ico_clean_48_48.png' )
        #self.show_find_results

        self.make_drawing = 1
        self.gdkdrawable = None

    def do_draw(self, gpsmap, gdkdrawable):
        #return None
        if self.make_drawing:
            if timing_osd:
                t = time.time()

            self.size = gdkdrawable.get_size()
            CONFIG['width'] = self.size[0]
            CONFIG['height'] = self.size[1]
            x = self.size[0]-64

            cr = gdkdrawable.cairo_create()
            self.gdkdrawable = gdkdrawable

            cr.set_source_surface( self.pb_plus, x,10 )
            cr.paint()

            if gpsPresent:
                if self.osmMapa.get_gpslock() == 1:
                    cr.set_source_surface( self.pb_gps_on, x,80 )
                else:
                    cr.set_source_surface( self.pb_gps, x,80 )
                cr.paint()

                try:
                    self.osmMapa.osm.props.gps_track_highlight_radius = (gps.accuracy/gps.acc_scale[self.osmMapa.osm.props.zoom])*10
                except:
                    self.osmMapa.osm.props.gps_track_highlight_radius = 0
                    print "GPS manager: accurasy is insain (",self.accuracy,")"


            cr.set_source_surface( self.pb_min, x,160 )
            cr.paint()
            cr.set_source_surface( self.pb_menu, x,self.size[1]-100 )
            cr.paint()

            if len(self.osmMapa.find_plugins) > 0:
                if len(self.osmMapa.show_find_results) > 0:
                    cr.set_source_surface( self.pb_clean, x+10,self.size[1]-160 )
                else:
                    cr.set_source_surface( self.pb_find, x+10,self.size[1]-160 )
                cr.paint()

            plug_nr = 0
            for plugin in self.osmMapa.plugins_list:
                plugin_name = plugin[1]
                if CONFIG[plugin_name] and plugin[2]:
                    if len(plugin) == 3:
                        plugin.append( plugin[0].get_menu_widgets(self) )
                    if plugin[3] <> None:
                        try:
                            if plugin[0].ui_menu_left:
                                cr.set_source_surface( plugin[2], 2, (plug_nr*self.plugin_ico_h)+self.plugin_ico_yoffset )
                                cr.paint()
                                plug_nr+=1
                        except:
                                cr.set_source_surface( plugin[2], 2, (plug_nr*self.plugin_ico_h)+self.plugin_ico_yoffset )
                                cr.paint()
                                plug_nr+=1


            if self.osmMapa.osm.props.tiles_queued != 0:
                str = "Downloading images (%i)" % self.osmMapa.osm.props.tiles_queued
                cr.set_source_rgb(0.0, 0.0, 0.0)
                cr.select_font_face("Georgia")
                cr.set_font_size(15)
                cr.move_to(10,15)
                cr.show_text(str)
            if timing_osd:
                print "YosmapaOSD do_draw in:",(time.time()-t)

            self.make_drawing = 0

        return None

    def do_render(self, gpsmap):
        self.make_drawing = 1
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        if timing_osd:
            t = time.time()
        #print "dummy event ",gpsmap, gdkeventbutton
        x = self.size[0]-64
        #print "x start",x,"bt press at",gdkeventbutton.x
        if gdkeventbutton.x >= x:
            if gdkeventbutton.y>10 and gdkeventbutton.y<70:
                print "bt plus"
                self.osmMapa.zoom_in_clicked(None)
            elif gdkeventbutton.y>80 and gdkeventbutton.y<140:
                print "bt gps"
                if self.osmMapa.get_gpslock():
                    self.osmMapa.set_gpslock( 0 )
                else:
                    self.osmMapa.set_gpslock( 1 )
                    try:
                        if gpsPresent:
                            self.osmMapa.osm.set_center( gps.lat, gps.lon )
                    except:
                        print "gps get trac kupa"
            elif gdkeventbutton.y>160 and gdkeventbutton.y<220:
                print "bt min"
                self.osmMapa.zoom_out_clicked(None)
            elif len(self.osmMapa.find_plugins) >0 and gdkeventbutton.y>(self.size[1]-160) and  gdkeventbutton.y<(self.size[1]-105):
                print "bt search"
                self.osmMapa.build_search()

            elif gdkeventbutton.y>(self.size[1]-100) and  gdkeventbutton.y<(self.size[1]-34):
                print "bt menu"
                self.osmMapa.build_mainMenu()
                #dialog.run()
                #dialog.destroy()
                #print "response from dialog [",res,"]"

        elif gdkeventbutton.x <= 52:
            plug_nr = 0
            for plugin in self.osmMapa.plugins_list:
                plugin_name = plugin[1]
                try:
                    if plugin[0].ui_menu_left:
                        probeIt = 1
                    else:
                        probeIt = 0
                except:
                    probeIt = 1
                if CONFIG[plugin_name] and probeIt:
                    try:
                        ico = plugin[0].ico
                        w = plugin[0].get_menu_widgets(self)
                        y = (plug_nr*self.plugin_ico_h)+self.plugin_ico_yoffset
                        if gdkeventbutton.y < (y+self.plugin_ico_test) and gdkeventbutton.y > y:
                            print "clicked on plugin nr ",plug_nr," name:", plugin_name

                            try:
                                w.destroy()
                            except:
                                pass
                            try:
                                md.destroy()
                            except:
                                pass
                            try:
                                w2.destroy()
                            except:
                                pass

                            stackW = 0
                            try:
                                if plugin[0].ui_stackable:
                                    stackW = 1
                            except:
                                pass

                            if stackW == 0:
                                md = hildon.Dialog()
                                md.set_title( plugin_name )
                                w2 = plugin[0].get_menu_widgets(md)
                                md.vbox.pack_start( w2, True )
                                md.show_all()
                            else:
                                w = hildon.StackableWindow()
                                self.osmMapa.set_autorotate_for_object(w)
                                w.set_title( plugin_name )
                                v = gtk.VBox()
                                w2 = plugin[0].get_menu_widgets(w)
                                v.pack_start(w2, True)
                                w.add( v )
                                w.show_all()
                            #md.run()
                        if w <> None:
                            plug_nr+=1
                    except:
                        pass
        else:
            x = gdkeventbutton.x
            y = gdkeventbutton.y
            t = time.time()
            self.osmMapa.cliked_at_xyt = [ x,y, t ]
            print "click at :",x,",",y


            for c in self.osmMapa.clikable_icons:
                if x >= c[0] and y >= c[1] and x<= c[2] and y<= c[3]:
                    self.osmMapa.cliked_item = [ c[4][0],c[4][1] ]
                    self.osmMapa.set_gpslock( False )
                    if self.osmMapa.cliked_item <> []:
                        self.osmMapa.osm.set_center( c[4][0], c[4][1] )
                    else:
                        cr = self.gdkdrawable.cairo_create()
                        self.osmMapa.draw_cloud_byll(cr, c[4])



            for c in self.osmMapa.clikable_clouds:
                if x >= c[0] and y >= c[1] and x<= c[2] and y<= c[3]:

                    if type(c[6]) == list:
                        self.on_details(None,c[6])



        if timing_osd:
            print "YosmapaOSD press in:",( time.time()-t )
        return False

    def on_details(self, w, point):
        w = DetailsWindow( self.osmMapa, point, CONFIG )

gobject.type_register(YosmapaOSD)







class UI(hildon.StackableWindow):

    def dont_sleep(self):
        f = open( "/sys/class/backlight/acx565akm/brightness", "r")
        content = f.read()
        f.close()
        if int(content) <> 0:
            CONFIG['work_work_work'] = 1
            if self.get_gpslock():
                self.req.req_tklock_mode_change('unlocked')
        else:
            CONFIG['work_work_work'] = 0

            #req.req_tklock_mode_change('locked')

        if CONFIG['work_work_work']:
            time_loop = 15000
        else:
            time_loop = 25000


        gobject.timeout_add( time_loop, self.dont_sleep )

    def fullscreen_toggle(self):
        if self.window_is_fullscreen:
            self.unfullscreen()
            self.window_is_fullscreen = False
        else:
            self.fullscreen()
            self.window_is_fullscreen = True

    def get_home(self):
        return home
    def get_config(self):
        return CONFIG
    def set_config(self,str, val):
        CONFIG[str] = val
    def get_version(self):
        return version


    def plugin_present(self,plug_name):
        tr = 0
        if CONFIG[plug_name] == 0:
            return tr

        for p in self.plugins_list:
            if p[1] == plug_name:
                return 1

        return tr
    def get_plugin(self, str):
        for p in self.plugins_list:
            if str == p[1]:
                return p[0]

    def build_mainMenu(self):
        dialog = MainMenuDialog(self, CONFIG, maps_source,autorotate, FremantleRotation)

    def build_search(self):
        dialog = SearchDialog(self, CONFIG)

    def build_route(self):
        plug = self.get_plugin("Google - routesearch")

        w = hildon.StackableWindow()
        self.set_autorotate_for_object(w)
        w.set_title( plug.get_name() )
        v = gtk.VBox()
        w2 = plug.get_menu_widgets(w)
        v.pack_start(w2, True)
        w.add( v )
        w.show_all()

    def build_details(self, point):
        w = DetailsWindow( self, point, CONFIG )


    # ------------------ SMS

    def send_to_contact_present(self):
        return send_to_contact
    def send_to_contact_dialog(self,str_to_send):
        bt_sms = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL,"SMS")
        bt_sms.connect("clicked", self.send_to_contact_step1, str_to_send)
        bt_sms.show_all()
        return bt_sms
    def send_to_contact_step1(self, w, str_to_send):
        s = SelectContact(self,str_to_send)
        s.start_dialog()
    def send_to_contact_step2(self, telNr, str_to_send):
        if telNr=="" or str_to_send == "":
            return None

        d = gtk.Dialog()
        d.set_title("Share via SMS")

        d.vbox.pack_start( gtk.Label("Send to: %s"%telNr), False)

        text = gtk.TextView()
        text.set_size_request(240, 240)
        text.set_wrap_mode(True)
        tb = text.get_buffer()
        tb.set_text( str_to_send )
        text.set_buffer( tb )
        d.vbox.pack_start( text, True)

        bt_send = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL,"Send SMS")
        bt_send.connect("clicked", self.send_to_contact_step3, telNr,text, d)
        d.vbox.pack_start( bt_send, False )

        d.show_all()
        d.run()
        d.destroy()

    def send_to_contact_step3(self, w, number, text, dialog):
        tb = text.get_buffer()
        message = tb.get_text( tb.get_start_iter(), tb.get_end_iter() )

        cmd = "smssend -s -v 167 -m \"%s\" -n %s &" % (message.replace("\"", "'"), number)
        print "cmd [[%s]]" % cmd
        os.system(cmd)


        dialog.destroy()
        print "SMS send! tel:[%s] message[%s]" % (number, message)



    # ------------------ SMS



    def set_autorotate_for_object_same_as_UI(self, obj):
        try:
            mode = self.window_rotate.get_mode()
            print "mode --- ",mode
            w = FremantleRotation(name, obj, version, mode)
        except Exception, e:
            print "mode set error :/ --------------- [",e,"]------------"
            pass

    def set_autorotate_for_object(self, obj):
        if autorotate:
            if CONFIG['autorotate']:
                initial_mode = FremantleRotation.AUTOMATIC
            else:
                initial_mode = FremantleRotation.NEVER
            self.window_rotate = FremantleRotation(name, obj, version, initial_mode)
            print "__init__ autorotate init!"

    def on_key_down(self,widget,a):
        print "keydown", a.keyval
        if a.keyval == 102: # f
            self.fullscreen_toggle()
    def showBanner(self, str):
        print "showBanner push one: (",str,")"
        hildon.hildon_banner_show_information(self, "", str)

    def ben_iter_func(self):
        self.ben_iter-=1
        CONFIG['lat']-= 0.00003
        CONFIG['lon']-= 0.00003
        self.osm.set_center( CONFIG['lat'], CONFIG['lon'] )

        CONFIG['lat']= self.osm.props.latitude
        CONFIG['lon']= self.osm.props.longitude
        #print "ben_iter_funk to go:", self.ben_iter

        gobject.timeout_add( 50, self.ben_iter_func  )

        if self.ben_iter < 0:
            gtk.main_quit()


    def __init__(self):
        self.window_is_fullscreen = False

        hildon.StackableWindow.__init__(self)
        self.connect('key-release-event', self.on_key_down)

        self.ben_iter = 100
        self.show_find_results = []
        self.find_plugins = []

        self.do_draw_plugins = []
        self.do_button_release_plugins = []


        CONFIG['work_work_work'] = 1

        try:
            print "__init__track record chk: ",CONFIG['track_record']
        except:
            CONFIG['track_record'] = 0

        try:
            print "__init__autorotate mode: ",CONFIG['autorotate']
        except:
            CONFIG['autorotate'] = 1

        try:
            self.bus = dbus.SystemBus()
            self.req = self.bus.get_object('com.nokia.mce','/com/nokia/mce/request')

            self.dont_sleep()
        except:
            pass



        self.set_default_size(500, 500)
        self.connect('destroy', lambda x: gtk.main_quit())
        self.set_title("%s ver: %s"%(name, version))

        self.vbox = gtk.VBox(False, 0)
        self.add(self.vbox)

        self.my_gps_track = []
        self.baner_tmp = 0,0,""

        self.clikable_clouds = []
        self.clikable_icons = []
        self.cliked_item = []

        self.cliked_at_xyt = [0,0,0]

        self.markers = []

        self.window_rotate = -1
        self.set_autorotate_for_object(self)
        
        
        try:
            self.osm.set_center_and_zoom( CONFIG['lat'], CONFIG['lon'], CONFIG['zoom'] )
        except:
            pass

        gobject.timeout_add(500, self.print_tiles)

    def set_plugins_searchable(self):
        self.find_plugins = []
        for p in self.plugins_list:
            try:
                if p[0].ui_search and CONFIG[p[1]]:
                    self.find_plugins.append(p)
                    print "add searchable plugin,",p[1]
            except:
                pass

    def set_plugins_list(self, plugins_list):
        self.plugins_list = plugins_list
        self.set_plugins_searchable()


    """
    -------------------------------------------------------------------
    marker
    p(
0        lat (float),
1        lon (float),
2        plugin_source (string),
3        title (string) || None,
4        image (pixbuf),
5        osm_point (gobject) || None,
6        zoom (int) start draw from zoom
7        {} details
    )
    """

    def recalculate_center_and_zoom(self):
        print "recalculate_center_and_zoom"
        ico = None
        if len(self.show_find_results)>0:
            self.set_gpslock(0)
            if len(self.show_find_results ) == 1:
                p = self.show_find_results[0]
                self.osm.set_center_and_zoom(p[0],p[1], 17 )
            else:
                t_lt, t_ln, b_lt, b_ln = 0.0, 0.0, 0.0, 0.0
                for i,p in enumerate(self.show_find_results):
                    p[6] = 0
                    if not ico and p[4]:
                        ico = p[4]
                        f_name = "%s_%s.jpg" % (home, md5.new(CONFIG['search']).hexdigest() )
                        ico.save( f_name, "png", {"quality":"100"}  )

                    if i == 0:
                        t_lt, t_ln, b_lt, b_ln = p[0],p[1],p[0],p[1]

                    if t_lt > p[0]: t_lt = p[0]
                    if b_lt < p[0]: b_lt = p[0]
                    if t_ln > p[1]: t_ln = p[1]
                    if b_ln < p[1]: b_ln = p[1]

                print t_lt, t_ln, b_lt, b_ln




                dis = self.distance( t_lt,t_ln, b_lt,b_ln )*1000
                acc_scale = {
                      18: 70,
                      17: 100,
                      16: 200,
                      15: 500,
                      14: 1000,
                      13: 2000,
                      12: 4000,
                      11: 9000,
                      10: 10000,
                      9:  30000,
                      8:  70000,
                      7:  100000,
                      6:  200000,
                      5:  500000,
                      4:  1000000,
                      3:  2000000,
                      2:  4000000
                      }
                zoom = 17
                for key in acc_scale:
                    print "dis[",dis,"] val[",acc_scale[key],"]"
                    if acc_scale[key] <= dis:
                        zoom = key
                        break

                latc, lonc = [(t_lt+b_lt)/2,(t_ln+b_ln)/2]
                self.osm.set_center_and_zoom(latc,lonc,zoom )



        print "recalculate_center_and_zoom ---- Done"

    def marker_draw(self,cr):

        print "marker_draw"
        self.clikable_clouds = []
        t_lt, t_ln, b_lt, b_ln = self.osm.get_bbox()
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        zoom =  self.osm.props.zoom

        if len(self.show_find_results)>0:
            self.marker_clear_from_layer( self.markers )
            make_from = self.show_find_results
        else:
            make_from = self.markers


        self.clikable_icons = []
        if len(self.cliked_item) == 2:
            icon_clicked = 1
            #print "icon_clicked !",self.cliked_item
        else:
            icon_clicked = 0

        for m in make_from:
            lt = m[0]
            ln = m[1]
            if m[6] < zoom and t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                x,y = self.osm.geographic_to_screen(lt,ln)
                xoff, yoff = m[4].get_width(), m[4].get_height()
                x-= xoff/2
                y-= yoff/2
                self.clikable_icons.append( [x, y, x+xoff, y+yoff, m] )

                if not m[5]:
                    m[5] = self.osm.image_add( lt, ln, m[4] )
                    if self.cliked_item == [] and m[3]:
                        self.cliked_item = [lt,ln]
                        icon_clicked = 1
                else:
                    if self.cliked_item == [] and m[3]:
                        self.cliked_item = [lt,ln]
                        icon_clicked = 1


                if m[2] == "Google - routesearch" and m[3]:
                    self.draw_cloud_byll(cr, m)
                elif ( m[3] and icon_clicked ):
                    if self.cliked_item[0] == m[0] and self.cliked_item[1] == m[1]:
                        self.draw_cloud_byll(cr, m)
            else:
                if m[5]:
                    self.osm.image_remove(m[5])
                    m[5] = None
                    if icon_clicked:
                        if self.cliked_item[0] == m[0] and self.cliked_item[1] == m[1]:
                            self.cliked_item = []


    def marker_clear_from_layer(self, from_what):
        for m in from_what:
            if m[5]:
                self.osm.image_remove( m[5] )
                m[5] = None

    def marker_layer_clean(self, plugin = ""):
        if plugin == "":
            for m in self.markers:
                if m[5]:
                    self.osm.image_remove( m[5] )
            self.markers = []
        else:
            mark_tmp = []
            for m in self.markers:
                if m[2] == plugin:
                    if m[5]:
                        self.osm.image_remove( m[5] )
                else:
                    mark_tmp.append(m)
            self.markers = mark_tmp

    def marker_add(self, marker):
        self.markers.append( [marker[0], marker[1], marker[2], marker[3], marker[4], None, marker[6]] )

    def marker_del(self, marker):
        mark_tmp = []
        for m in self.markers:
            if m[0] == marker[0] and m[1] == marker[1] and m[2] == marker[2]:
                if m[5]:
                    self.osm.image_remove( m[5] )
            else:
                mark_tmp.append(m)
        self.markers = mark_tmp

   #-------------------------------------------------------------------



    def get_may_current_ll(self):
        if gpsPresent:
            if gps.lat <> 0.0 and gps.lon <> 0.0:
                return [ gps.lat, gps.lon ]


        return [ self.osm.props.latitude, self.osm.props.longitude ]

    def distance( self,lat1, lon1, lat2 = None, lon2 = None):
        if lat2 == None and lon2 == None:
            lat2,lon2 = self.get_may_current_ll()
        try:
            theta = lon1 - lon2
            dist = math.sin(math.radians(lat1)) * math.sin(math.radians(lat2)) +  math.cos(math.radians(lat1)) * math.cos(math.radians(lat2)) * math.cos(math.radians(theta))
            dist = math.acos(dist)
            dist = math.degrees(dist)
            return dist * 111.18957696
        except:
            return 0
    def distance_to_string(self, dis):
        if dis > 1.0:
            return "%.1f km"%dis
        else:
            dis*=1000
            return "%i m"%dis


    def cal_angle(self, lat0, lon0, lat1 = None, lon1 = None):
        if lat1 == None and lon1 == None:
            lat1,lon1 = self.get_may_current_ll()

        deltax = lat1-lat0
        deltay = lon0-lon1
        M_PI = 3.14159265
        angle_rad = math.atan2(deltax,deltay)+M_PI

        return [ angle_rad, 0 ]


    def cal_dist(self, lat0, lon0, lat1 = None, lon1 = None):
        if lat1 == None and lon1 == None:
            lat1,lon1 = self.get_may_current_ll()
        return math.sqrt((lon0 - lon1)**2 + (lat0 - lat1)**2)

    def draw_arrow(self, gdkdrawable, lat, lon,rgba=[0.9,0.2,0.9,0.7], borderRgba=[0.0,0.4,0.4,0.3] ):

        cr = gdkdrawable.cairo_create()
        t_lt, t_ln, b_lt, b_ln = self.osm.get_bbox()
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        size = gdkdrawable.get_size()
        screen_center = [ size[0]/2, size[1]/2 ]
        latc = self.osm.props.latitude
        lonc = self.osm.props.longitude
        screen_distance = self.cal_dist( latc,lonc,t_lt,lonc )*0.7
        dis = self.cal_dist( latc, lonc, lat, lon )

        #print "dis:",dis,"screen_distance:",screen_distance

        if dis > screen_distance:
            a = self.cal_angle( latc, lonc, lat, lon)

            cr.arc(             screen_center[0], screen_center[1], 150,             a[0],   a[0]  )
            cr.arc(             screen_center[0], screen_center[1], 140,             a[0]+0.05,   a[0]+0.05  )
            cr.arc_negative(    screen_center[0], screen_center[1], 170,             a[0] ,      a[0]  )
            cr.arc(             screen_center[0], screen_center[1], 140,             a[0]-0.05,   a[0]-0.05 )
            cr.arc(             screen_center[0], screen_center[1], 150,             a[0],   a[0]  )

            cr.set_source_rgba (rgba[0],rgba[1],rgba[2],rgba[3])
            cr.fill_preserve ()
            cr.set_source_rgba (borderRgba[0],borderRgba[1],borderRgba[2],borderRgba[3])
            cr.set_line_width (1.0)
            cr.stroke ()

            cr.arc(             screen_center[0], screen_center[1], 180,             a[0],   a[0]  )
            cr.rotate( a[0] )
            cr.set_source_rgba(1.0, 1.0, 1.0, 0.7)
            cp = cr.get_current_point()
            cr.rectangle(cp[0]-3,cp[1]-10,40, 12)
            cr.move_to( cp[0], cp[1]+1)
            cr.fill_preserve ()
            #cr.set_source_rgba(0.0, 0.0, 0.0, 0.7)
            #cr.set_line_width (1.0)
            #cr.stroke ()

            cr.set_source_rgb(0.0, 0.0, 0.0)
            cr.select_font_face("Georgia")
            cr.set_font_size(12)
            #cr.move_to(x+2,y+line_height)


            dis = self.distance_to_string( self.distance( latc, lonc, lat, lon) )
            cr.show_text("%s"%dis)

    def draw_cloud_byll(self, cr, lat, lon = None, str = None, font_size = 13, Fifek = True):
        if lon == None and str == None:
            x,y = self.osm.geographic_to_screen(lat[0],lat[1])
            str = lat
        self.draw_cloud(cr, x, y, str, font_size, Fifek)
    def draw_cloud(self, cr, x, y, str = None, font_size = 13, Fifek = True):

        point = None
        if type(str) == list:
            point = str
            str = point[3]

        if str == "" or str == None:
            return None
        if x<0:
            print "inwert"
            x = CONFIG['width']+x
        if y<0:
            print "inwert"
            y = CONFIG['height']+y

        rlat, rlon = self.osm.get_co_ordinates(int(x), int(y))
        cr.select_font_face("Georgia")
        cr.set_font_size(font_size)
        xbearing, ybearing, width, height, xadvance, yadvance = cr.text_extents( str )

        line_height = height
        multiline = 0
        if str.find("\n") <> -1:
            multiline = 1
            tmp = str.split("\n")
            line_height = height
            width = 0
            height*=len(tmp)
            for l in tmp:
                xbearing, ybearing, width2, height2, xadvance, yadvance = cr.text_extents( l )
                if width2> width:
                    width = width2

        y+=3

        aspect = 1.0
        corner_radius = 3.0
        M_PI = 3.14159265

        radius = corner_radius / aspect
        degrees = M_PI / 180.0

        cr.new_sub_path ()
        if Fifek:
            cr.line_to( x,y )
            cr.line_to( x+5,y+10 )
        x-=5
        y+=10
        height+=4
        width+=4

        cr.arc (x + width - radius, y + radius, radius, -90 * degrees, 0 * degrees)
        cr.arc (x + width - radius, y + height - radius, radius, 0 * degrees, 90 * degrees)
        cr.arc (x + radius, y + height - radius, radius, 90 * degrees, 180 * degrees)
        cr.arc (x + radius, y + radius, radius, 180 * degrees, 270 * degrees)
        cr.close_path ()

        cr.set_source_rgb (1.0, 1.0, 1.0)
        cr.fill_preserve ()
        cr.set_source_rgb (0.0, 0.0, 0.0)
        cr.set_line_width (1.0)
        cr.stroke ()

        if multiline:
            line_nr = 0
            for l in tmp:
                cr.move_to(x+2,y+12+(line_nr*line_height))
                cr.show_text(l)
                line_nr+=1

        else:
            cr.move_to(x+2,y+line_height+1)
            cr.show_text(str)

        if Fifek:
            if point:
                point_data = point
            else:
                point_data = str
            self.clikable_clouds.append( [ x,y,x+width,y+height, float(math.degrees(rlat)), float(math.degrees(rlon)), point_data ] )

        return True

    def point_test(self, lat, lon, x,y):
        return False


    def set_gpslock(self, state ):
        if state:
            CONFIG['gpslock'] = 1
            self.osm.set_zoom( 16 )
            self.osd.props.show_crosshair = False
        else:
            CONFIG['gpslock'] = 0
            self.osd.props.show_crosshair = True
    def get_gpslock(self):
        return CONFIG['gpslock']

    def load_map_clicked(self, button=None):

        try:
            if self.osm:
                #remove old map
                self.vbox.remove(self.osm)
        except:
            pass

        try:
            if type( CONFIG['engine_name'] ) == int:
               self.osm = osmgpsmap.GpsMap(
                            map_source=CONFIG['engine_name']
                            )
            else:
                self.osm = osmgpsmap.GpsMap(
                        repo_uri=CONFIG['engine_name']
                        )

            self.osd = osmgpsmap.GpsMapOsd(show_crosshair=(not self.get_gpslock() ))
            self.osm.layer_add(
                    self.osd
                    )

            self.osm.layer_add( PluginsLayer(self,self.plugins_list) )
            self.osm.layer_add( YosmapaOSD(self) )
            self.osm.connect('button_release_event', self.map_clicked)

            for plugin in self.plugins_list:
                plugin_name = plugin[1]
                if CONFIG[plugin_name]:
                    try:
                        plugin[0].makeInit()
                    except Exception, e:
                        print "plugin make init error ---- [",plugin_name,"], [",e,"]"
                        pass

            #connect keyboard shortcuts
        except Exception, e:
            print "ERROR:", e
            self.osm = osmgpsmap.GpsMap()

        self.vbox.pack_start(self.osm, True)
        #self.osm.connect('button-release-event', self.map_clicked)

        self.osm.show()
        self.osm.set_center( CONFIG['lat'], CONFIG['lon'])
        self.osm.set_zoom( CONFIG['zoom'] )


    def print_tiles(self):
        if self.osm.props.tiles_queued != 0:
            print self.osm.props.tiles_queued, 'tiles queued'
        self.download_max = 0
        return True

    def zoom_in_clicked(self, button):
        if self.osm.props.zoom < 18:
            self.osm.set_zoom(self.osm.props.zoom + 1)

    def zoom_out_clicked(self, button):
        if self.osm.props.zoom > 2:
            self.osm.set_zoom(self.osm.props.zoom - 1)


    def map_release_menu(self, xR, yR ):
        t = time.time()

        accuracy = 10
        if int(xR/accuracy) == int(self.cliked_at_xyt[0]/accuracy) and int(yR/accuracy) == int(self.cliked_at_xyt[1]/accuracy) and (t-0.5) > self.cliked_at_xyt[2]:
            print "menu tab map show !"

            m = gtk.Menu()
            latc,lonc = self.get_may_current_ll()

            rlat, rlon = self.osm.get_co_ordinates(int(xR), int(yR))
            lat = math.degrees(rlat)
            lon = math.degrees(rlon)

            dis = self.distance_to_string( self.distance( latc, lonc,lat,lon) )

            mi = gtk.MenuItem("Distans it: %s\n" % dis)
            m.append(mi)

            mi = gtk.MenuItem("\nCenter to\n")
            mi.connect("activate",self.onM_set_center,lat,lon)
            m.append(mi)

            if CONFIG['POI']:
                mi = gtk.MenuItem("\nAdd as POI\n")
                mi.connect("activate",self.onM_add_as_poi,lat,lon)
                m.append(mi)

            if CONFIG['Google - routesearch']:
                mi = gtk.MenuItem("\nRoute to\n")
                mi.connect("activate",self.onM_route_to_it,lat,lon)
                m.append(mi)


            #if type(c[6]) == list:
            if CONFIG['Google - geonames']:
                mi = gtk.MenuItem("\nDetails")
                mi.connect("activate",self.onM_details,lat,lon)
                m.append(mi)

            m.show_all()
            m.popup( None, None, None , 2, 0)

    def onM_details(self,w, lat,lon):
        print "-- details from menu -- "
        dw = DetailsWindow( self, [lat,lon], CONFIG )
        print "-- details from menu -- "

    def onM_route_to_it(self, w, lat, lon):
        p = self.get_plugin( "Google - routesearch" )
        if p <> None:
            CONFIG['google_routesearch_from'] = "my current location"
            CONFIG['google_routesearch_to'] = "loc:%f+%f" %( lat, lon)
            p.search_action()

    def onM_add_as_poi(self, w, lat, lon):
        poi = self.get_plugin("POI")
        if poi <> None:
            self.osm.set_center( lat,lon)
            poi.on_add( None,None )

    def onM_set_center(self, w,lat, lon):
        self.osm.set_center_and_zoom( lat,lon, 16)



    def map_clicked(self, osm, event):
        if CONFIG['work_work_work']:
            print "config update"


            x = event.x
            y = event.y

            self.map_release_menu(x, y)
            print "click at :",x,",",y

            CONFIG['lat'] = self.osm.props.latitude
            CONFIG['lon'] = self.osm.props.longitude
            CONFIG['zoom'] = self.osm.props.zoom


            if event.button == 6:
                pass
            elif event.button == 8:
                rlat, rlon = self.osm.get_co_ordinates(int(event.x), int(event.y))
                self.osm.gps_add(
                        math.degrees(rlat),
                        math.degrees(rlon),
                        osmgpsmap.INVALID)
                self.my_gps_track.append( [ math.degrees(rlat), math.degrees(rlon) ] )


            #self.osmMapa.do_draw_plugins = []
        #self.osmMapa.do_button_release_plugins = []

            if len( self.do_button_release_plugins ) == 0:
                make_from = self.plugins_list
                add = 1
            else:
                make_from = self.do_button_release_plugins
                add = 0


            for plugin in make_from:
                if CONFIG[plugin[1]]:
                    try:
                        plugin[0].do_button_release(osm,event)
                        if add:
                            self.do_button_release_plugins.append(plugin)
                    except Exception, e:
                        print "UI map_release ERROR:", e


    def welcomeScreenInit(self):
        ws = WelcomeScreen(self,CONFIG)



def gps_emulator_iter():
    print "threshold:",u.osm.props.auto_center_threshold
    u.osm.props.auto_center = True
    try:
        f = open("../gps_emu.var", "r")
        d = f.read()
        f.close()
        lat, lon, acu, dir = d.split(",")
        lat = float( lat )
        lon = float( lon )
        dir = float(dir)

        u.osm.gps_add( lat, lon, dir)


        u.osm.props.gps_track_highlight_radius = (float(acu)/gps.acc_scale[u.osm.props.zoom])*10
        print "gps_add"
    except Exception, e:
            print "ERROR:", e

    gobject.timeout_add( 1000, gps_emulator_iter )
    print "gps_emulator_iter DONE"


class PluginsLayer(gobject.GObject, osmgpsmap.GpsMapLayer):
    def __init__(self, osmMapa, plugins):
        gobject.GObject.__init__(self)
        self.osmMapa = osmMapa
        self.plugins = plugins
        self.make_draw = 1

    def do_draw(self, gpsmap, gdkdrawable):
        if self.make_draw and CONFIG['work_work_work']:
            if timing_plugins:
                t = time.time()

            self.osmMapa.marker_draw(gdkdrawable.cairo_create())

            if len( self.osmMapa.do_draw_plugins ) == 0:
                make_from = self.plugins
                add = 1
            else:
                make_from = self.osmMapa.do_draw_plugins
                add = 0

            for plugin in make_from:
                if CONFIG[plugin[1]]:
                    try:
                        if timing_plugins:
                            tp = time.time()
                        plugin[0].do_draw(gpsmap, gdkdrawable)
                        if timing_plugins:
                            print "plugin ", plugin[1]," in ",(time.time()-tp)
                        if add:
                            self.osmMapa.do_draw_plugins.append(plugin)
                    except Exception, e:
                        print "PluginsLayer do_draw ERROR (",plugin[1],"):", e


            if timing_plugins:
                print "PluginsLayers in",(time.time()-t)
            self.make_draw = 0

    def do_render(self, gpsmap):
        self.make_draw = 1
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        return False
gobject.type_register(PluginsLayer)







if __name__ == "__main__":
    t = time.time()
    print "__main__"

    config_load( CONFIG )
    u = UI()
    u.show_all()
    plugs = BuildPluginsList(u, CONFIG)
    u.set_plugins_list( plugs.get_plugins_list() )
    u.load_map_clicked()

    if gpsPresent:
        print "GPS init"
        gps = GpsManager(u, CONFIG, location)
        gps.start()
        print "GPS init DONE"

    if 0:
        u.osm.props.auto_center = True
        gps_emulator_iter()

    if 0: # ben
        CONFIG['lat'] = 52.404198
        CONFIG['lon'] = 16.970615
        u.ben_iter_func()

    try:
        if CONFIG['welcome_screen']:
            u.welcomeScreenInit()
    except:
         u.welcomeScreenInit()


    if os.name == "nt": gtk.gdk.threads_enter()
    print "Up and running in: ",(time.time()-t)
    gtk.main()
    if os.name == "nt": gtk.gdk.threads_leave()
    config_save( CONFIG )

    if gpsPresent:
        print "GPS kill it"

        gps.loop.quit()
        gps.control.stop()
        gtk.gdk.threads_leave()
        gtk.gdk.threads_leave()
        gtk.gdk.threads_leave()

        print "GPS kill it DONE"


