import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
import hildon

from threading import Thread

class nominatimDownloader(Thread):
    def __init__(self,geonames,box,str="", more = False):
        Thread.__init__(self)
        self.geonames = geonames
        self.tp = ""
        self.box = box
        self.zoom_start = self.geonames.osmMapa.osm.props.zoom
        self.str = str
        self.more = more

        self.zoom_out_iter = 0

    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        tr = []
        try:
            for p in doc.getElementsByTagName("place"):
                lat = float(p.getAttribute("lat"))
                lon = float(p.getAttribute("lon"))
                desc = p.getAttribute("display_name")
                name = desc.split(",")[0]

                try:
                    ico_href = p.getAttribute("icon")
                    ico_name = "./maps/%s" % ico_href.replace("/", "_")
                    if not os.path.exists( ico_name ):
                        ico_cmd = "wget \"%s\" -O \"%s\"" % (ico_href, ico_name )
                        os.system(ico_cmd)
                    ico = gdk.pixbuf_new_from_file(ico_name)
                except:
                    ico_name = "./maps/ico_igla_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)

                print "nominatimDownloader found in xml"

                add_it = 1
                for p in self.geonames.results:
                    if p[4] == id:
                        add_it = 0
                        break

                if add_it:
                    tr.append( [
                        lat,
                        lon,
                        self.geonames.get_name(),
                        name,
                        ico,
                        None,
                        self.geonames.from_zoom,
                        {
                            'desc': desc
                         }
                        ])

        except Exception, e:
            print "nominatimDownloader parseXml Error: ",e

        return tr


    def downloadXml(self):
        """
        http://nominatim.openstreetmap.org/search?viewbox= 16.73, 52.5  ,17.11, 52.3&q=fuel&format=xml&bounded=1&limit=10
        """
        t_lt, t_ln, b_lt, b_ln = self.box
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        #print t_lt, t_ln, b_lt, b_ln
        conn = httplib.HTTPConnection("nominatim.openstreetmap.org")
        req = "/search?viewbox=%f,%f,%f,%f&q=%s&format=xml&bounded=1&limit=15" % ( t_ln, t_lt, b_ln,b_lt, self.str.replace(" ","%20") )
        print req
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        #if self.more == False:
        #    self.geonames.osmMapa.showBanner(("searching:%s" % self.str))
        print "nominatimDownloader downolad"
        res = self.downloadXml()
        print "nominatimDownloader parse"
        tr = self.parseXml( res )
        print "nominatimDownloader parse DONE len(",len(tr),")"

        if len(tr)==0 and self.zoom_out_iter < 5:

            dis = self.geonames.osmMapa.cal_dist( self.box[0], self.box[1], self.box[2], self.box[3] )
            if dis<0: dis = -dis
            self.box = [
                        self.box[0]-dis,
                        self.box[1]-dis,
                        self.box[2]+dis,
                        self.box[3]+dis
                        ]
            self.zoom_out_iter+=1
            #self.geonames.osmMapa.showBanner("looking on bigger area")
            self.run()
        elif len(tr)==0:
            #self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            self.geonames.ui_thread = 2
            #self.geonames.osmMapa.showBanner("no result in bigger area too :..(")
        else:
            #self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            print "nominatimDownloader downolad"
            print "nominatimDownloader DONE"

        if len( tr ) > 0:
            for p in tr:
                self.geonames.osmMapa.show_find_results.append( p )
            #self.geonames.osmMapa.recalculate_center_and_zoom()
            self.geonames.ui_thread = 2
            print "nominatimDownloader add marker"


class nominatim_geonames:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "nominatim.png"

        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 1
        self.ui_thread = 1

        self.from_zoom = 7

        self.box_old = 0,0,0,0

        self.draw = 0
        self.results = []
        self.timeout = 3
        self.downloadMore = 0



        try:
            print "nominatim_geonames recent search for:\n",self.CONFIG['nominatim_geonames_recent_search'],"\n-----------"
        except:
            self.CONFIG['nominatim_geonames_recent_search'] = []

        try:
            print "nominatim_geonames search for:",self.CONFIG['nominatim_geonames_search']
        except:
            self.CONFIG['nominatim_geonames_search'] = ""

        try:
            if self.CONFIG['nomenatim_geonames_arrows']:
                pass
        except:
            self.CONFIG['nomenatim_geonames_arrows'] = 1

        print "__init__ nominatim_geonames"



    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):
        pass



    def get_name(self):
        return "Nominatim - geonames"

    def search_query(self, str):
        # TODO
        self.results = []
        self.ui_thread = 1
        self.box = self.osmMapa.osm.get_bbox()
        self.CONFIG['nominatim_geonames_search'] = str
        t = nominatimDownloader( self, self.box, self.CONFIG['nominatim_geonames_search'])
        t.start()
        return []

    def get_menu_widgets(self, dialog):
        return None

    def do_button_release(self, gpsmap, gdkeventbutton):
        """
        if self.downloadMore:
            print "nominatim_geonames download more !"
            self.box = self.osmMapa.osm.get_bbox()
            t = nominatimDownloader( self, self.box, self.CONFIG['nominatim_geonames_search'], True)
            t.start()
        """
        pass