import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
import time
import hildon
import gobject
import re
import thread
from threading import Thread

from decode_line import *



class MyZoomSelect(gtk.Dialog):

    def act_download(self,widget):
        self.p.zoom_min = int(self.h_min.get_value())
        self.p.zoom_max = int(self.h_max.get_value())
        self.destroy()

    def __init__(self, p):
        self.p = p

        gtk.Dialog.__init__(self)
        self.set_title("Select zoom to download")
        self.set_size_request(640, 480)

        self.h_min = gtk.HScale()
        self.h_min.set_range(1,18)
        self.h_min.set_value(11)
        self.vbox.pack_start( self.h_min, True,True,0)

        self.h_max = gtk.HScale()
        self.h_max.set_range(1,18)
        self.h_max.set_value(16)
        self.vbox.pack_start( self.h_max, True,True,0)

        bt_download = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Download")
        bt_download.connect("clicked", self.act_download)
        self.vbox.pack_start( bt_download, True, True, 0)

        self.show_all()


class googleRoutesearchDownloader(Thread):
    def __init__(self,geonames,config, offline, z_min, z_max):
        Thread.__init__(self)
        self.geonames = geonames
        self.osmMapa = self.geonames.osmMapa
        self.CONFIG = config
        self.offline = offline
        self.zoom_min = z_min
        self.zoom_max = z_max

    def parseXml(self, xml_res, lang = "en"):
        doc = xml.dom.minidom.parseString(xml_res)

        step_count = 0
        if lang == "en":
            self.geonames.points = []

        download_offline = 0
        if self.offline:
            download_offline = 1


        if doc.getElementsByTagName("status")[0].childNodes[0].data == "ZERO_RESULTS":
            self.osmMapa.showBanner("No results :/ ZERO, NADA")
            return None

        for step in doc.getElementsByTagName("step"):

            sl = step.getElementsByTagName("start_location")[0]
            el = step.getElementsByTagName("end_location")[0]

            sll = [ sl.getElementsByTagName("lat")[0].childNodes[0].data, sl.getElementsByTagName("lng")[0].childNodes[0].data]
            ell = [ el.getElementsByTagName("lat")[0].childNodes[0].data, el.getElementsByTagName("lng")[0].childNodes[0].data]



            # ---------------------------------- PARSE STREET NAMES
            str_no_street_name = step.getElementsByTagName("html_instructions")[0].childNodes[0].data
            print "----------------------------------------\nno street_name A:\t\t[",str_no_street_name,"]"

            m = re.search(r'(.*) <b>(.*)</b>(.*)<b>(.*)</b>(.*)<b>(.*)</b>', str_no_street_name, re.M|re.I)
            try:
                m.group(0)
                str_no_street_name = "%s %s"%(m.group(1), m.group(2))
                print "m"
            except:
                pass

            m0 = re.search(r'<b>(.*)</b>(.*)<b>(.*)</b>(.*)<b>(.*)</b>', str_no_street_name, re.M|re.I)
            try:
                m0.group(0)
                m0.group(1)
                str_no_street_name = "%s %s"%(m0.group(2), m0.group(3))
                print "0"
            except:
                pass

            m2 = re.search(r'(.*) <b>(.*)</b> (.*) <b>(.*)</b><div style="font-size:0.9em">(.*)</div>', str_no_street_name, re.M|re.I)
            try:
                m2.group(0)
                str_no_street_name = "%s %s %s"%(m2.group(1), m2.group(2),m2.group(5))
                print "2"
            except:
                pass

            m1 = re.search(r'(.*)<b>(.*)</b>(.*)<b>(.*)</b>', str_no_street_name, re.M|re.I)
            try:
                m1.group(0)
                str_no_street_name = "%s %s"%(m1.group(1), m1.group(2))
                print "1"
            except:
                pass


            m33 = re.search(r'(.*) <b>(.*)</b><div style="font-size:0.9em">(.*)</div>', str_no_street_name, re.M|re.I)
            try:
                m33.group(0)
                str_no_street_name = "%s. %s"%(m33.group(1), m33.group(3))
                print "33"
            except:
                pass


            m3 = re.search(r'(.*) <b>(.*)</b>', str_no_street_name, re.M|re.I)
            try:
                m3.group(0)
                str_no_street_name = "%s"%(m3.group(1))
                print "3"
            except:
                pass


            str_no_street_name = re.sub(r'<[^>]*?>', ' ', str_no_street_name )
            str_no_street_name = str_no_street_name.replace("  ", " ")



            print "no street_name B:\t\t[",str_no_street_name,"]"



            str = re.sub(r'<[^>]*?>', ' ', step.getElementsByTagName("html_instructions")[0].childNodes[0].data )
            str = str.replace("  ", " ")
            ico = None
            ico_name = None
            if lang == "en":

                if str.find("Continue straight") == 0:
                    ico_name = "./plugins/ico_turn_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)
                elif str.find("Turn left") == 0 or str.find("Take the 1st left") == 0 or str.find("Take the 2nd left") == 0 or str.find("Take the 3rd left") == 0:
                    ico_name = "./plugins/ico_turn_left_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)
                elif str.find("Turn right") == 0 or str.find("Take the 1st right") == 0 or str.find("Take the 2nd right") == 0 or str.find("Take the 3rd right") == 0:
                    ico_name = "./plugins/ico_turn_right_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)
                elif str.find("Slight right") == 0:
                    ico_name = "./plugins/ico_turn_sright_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)
                elif str.find("Slight left") == 0:
                    ico_name = "./plugins/ico_turn_sleft_32_32.png"
                    ico = gdk.pixbuf_new_from_file( ico_name)
                elif str.find("Keep left") == 0:
                    ico_name = "./plugins/ico_turn_keep_left_32_32.png"
                    ico = gdk.pixbuf_new_from_file( ico_name)
                elif str.find("Keep right") == 0:
                    ico_name = "./plugins/ico_turn_keep_right_32_32.png"
                    ico = gdk.pixbuf_new_from_file( ico_name)
                elif str.find("Make a U-turn") == 0 or str.find("Sharp left") == 0 or str.find("Sharp right") == 0:
                    ico_name = "./plugins/ico_turn_u_32_32.png"
                    ico = gdk.pixbuf_new_from_file( ico_name)
                self.geonames.markers.append([
                                     float(sll[0]),float(sll[1]),
                                     str,
                                     ico,
                                     ico_name,
                                     str_no_street_name
                                     ])
                t = osmgpsmap.GpsMapTrack()
                t.props.color = gtk.gdk.color_parse("#1a39fb")

                self.geonames.tracks.append( t )
                point0 = osmgpsmap.point_new_degrees(float(sll[0]),float(sll[1]))
                point1 = osmgpsmap.point_new_degrees(float(ell[0]),float(ell[1]))
                t.add_point( point0 )
                self.geonames.points.append( [float(sll[0]),float(sll[1])] )

                points = step.getElementsByTagName("points")[0].childNodes[0].data
                if len(points) > 2:
                    a = decode_line( points )
                    print "points from points in poliline", len( a )
                    for p in a:
                        point0 = osmgpsmap.point_new_degrees(float(p[0]),float(p[1]))
                        self.geonames.points.append( [float(p[0]),float(p[1])] )
                        t.add_point( point0 )

                        if download_offline:
                            self.osmMapa.osm.download_maps(
                                   float(p[0]),float(p[1]),
                                   float(p[0]),float(p[1]),
                                   self.zoom_min,self.zoom_max
                                   )

                t.add_point( point1 )
                self.geonames.points.append( [float(ell[0]),float(ell[1])] )
                self.osmMapa.osm.track_add( t )

                if step_count == 0:
                    i = gdk.pixbuf_new_from_file("./plugins/ico_comment_g.png")
                    self.geonames.icons.append( self.osmMapa.osm.image_add( float(sll[0]),float(sll[1]), i ) )

            else:
                m = self.geonames.markers[ len(self.geonames.markers_lang) ]
                self.geonames.markers_lang.append([
                                     m[0],m[1],
                                     str,
                                     m[3],
                                     m[4],
                                     str_no_street_name
                                    ])


            step_count+=1






        if step_count > 0:
            ico = gdk.pixbuf_new_from_file("./plugins/ico_comment_m.png")
            if lang == "en":
                str = "Destination point"
                self.geonames.markers.append([
                    float(ell[0]),float(ell[1]),
                    str,
                    ico,
                    "./plugins/ico_comment_m.png"
                    ])
            else:
                str = "DONE"
                self.geonames.markers_lang.append([
                     float(ell[0]),float(ell[1]),
                     str,
                     ico,
                     "./plugins/ico_comment_m.png"
                     ])


        print "step added ", step_count







    def downloadXml(self, lang = "en"):
        """
        maps.googleapis.com/maps/api/directions/xml?&destination=Polska,Pozna%C5%84,os.Stare%20%C5%BBegrze&waypoints=Polska,Pozna%C5%84,ul.%20g%C5%82ogowska%2010&sensor=false
        """
        conn = httplib.HTTPConnection("maps.googleapis.com")
        start = self.CONFIG['google_routesearch_from']
        end = self.CONFIG['google_routesearch_to']

        if start == "my current location":
            lat, lon = self.osmMapa.get_may_current_ll()
            start = "loc:%f+%f"%( float(lat), float(lon)  )
        if end == "my current location":
            lat, lon = self.osmMapa.get_may_current_ll()
            end = "loc:%f+%f"%( float(lat), float(lon)  )

        req = "/maps/api/directions/xml?mode=%s&origin=%s&destination=%s&sensor=true&language=%s" % (self.geonames.mode[self.CONFIG['google_routesearch_mode']],start,end, lang)
        print req
        req = req.replace(" ", "%20")
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "googleRoutesearchDownloader downolad"
        res = self.downloadXml()
        print "googleRoutesearchDownloader parse"
        self.parseXml( res )

        if self.CONFIG['google_routesearch_speak_street_lang'] == "en":
            self.geonames.markers_lang = self.geonames.markers
        else:
            self.geonames.osmMapa.showBanner("downloading lang pack...")
            res2 = self.downloadXml(self.CONFIG['google_routesearch_speak_street_lang'])
            self.parseXml( res2, self.CONFIG['google_routesearch_speak_street_lang'] )

        self.geonames.recalculate_in_progress = 0

class SaveTrackDialog( hildon.Program):
    def __init__(self, zoom=0, lat=0, lon=0):
        hildon.Program.__init__(self)
        self.app = hildon.Program()
        self.window = hildon.Window()

    def startIt(self):
        dlg = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SAVE)
        #hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
        czas = time.strftime("%Y%m%d_%H%M.gpx", time.localtime() )
        #dlg.set_current_folder("/home/user/MyDocs")
        dlg.set_current_name(czas)
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            tr = dlg.get_filename()
        else:
            tr = ""
        dlg.destroy()
        return tr


class google_routesearch:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa


        self.ico = "ico_navi2_32_32.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 1
        self.ui_stackable = 1
        self.ui_search = 0


        self.tp = ""
        self.timeout = 5
        self.draw = 0
        self.ll = 0,0

        self.tracks = []
        self.tracks_on_map = []
        self.points = []
        self.markers = []
        self.markers_lang = []
        self.markers_icons = []

        self.icons = []

        self.drive_mode = 0

        self.my_point = -1

        self.zoom_minimum = 15
        self.zoom_min = 10
        self.zoom_max = 16

        self.espeak_say = ""
        self.espeak_dis = 0
        self.espeak_time = 0
        self.espeak_langs = []


        self.recalculate_in_progress = 0

        if os.path.isfile("/usr/bin/espeak"):
            self.espeak = 1

            os.system( "espeak --voices | awk '{print $2}' | grep -v \"Language\" > /tmp/espeak_langs" )
            f = open( "/tmp/espeak_langs", "r" )
            l = 1
            while l:
                try:
                    l = f.readline().replace("\n","")
                    if l<>"":
                        #print "espeak lang add[",l,"]"
                        self.espeak_langs.append(l)
                except:
                    pass

            if len(self.espeak_langs) == 0:
                self.CONFIG['google_routesearch_speak_street_lang'] = "en"

            print "google_routesearch - found espeak yyyy cool"

            try:
                print "google_routesearch speak street lang:", self.CONFIG['google_routesearch_speak_street_lang']
            except:
                self.CONFIG['google_routesearch_speak_street_lang'] = "en"
        else:
            self.espeak = 0


        try:
            print "google_routesearch speak:", self.CONFIG['google_routesearch_speak']
        except:
            if self.espeak:
                self.CONFIG['google_routesearch_speak'] = 1
            else:
                self.CONFIG['google_routesearch_speak'] = 0

        try:
            print "google_routesearch speak streets nams:", self.CONFIG['google_routesearch_speak_streets_names']
        except:
            self.CONFIG['google_routesearch_speak_streets_names'] = 1


        #self.ico = "google_routesearch.png"

        try:
            print "google_routesearch auto recal:", self.CONFIG['google_routesearch_auto_recal']
        except:
            self.CONFIG['google_routesearch_auto_recal'] = 500

        try:
            print "google_routesearch auto recal make:", self.CONFIG['google_routesearch_auto_recal_make']
        except:
            self.CONFIG['google_routesearch_auto_recal_make'] = 1

        try:
            print "google_routesearch last search:", self.CONFIG['google_routesearch_from']
        except:
            self.CONFIG['google_routesearch_from'] = ""
        try:
            print "google_routesearch last search:", self.CONFIG['google_routesearch_to']
        except:
            self.CONFIG['google_routesearch_to'] = ""


        try:
            print "google_routesearch mode:", self.CONFIG['google_routesearch_mode']
        except:
            self.CONFIG['google_routesearch_mode'] = 0

        self.mode = ["driving", "walking", "bicycling"]

        print "__init__ google routesearch"



    def espeak_cmd(self, str):

        print "---- google_routesearch espeak ----"
        print "---- speak [%s] ----" % str

        """
        if str.find( " onto " ) <> -1:
            tmp = []
            tmp = str.split("onto")
            cmd = "espeak \"%s onto\" && espeak -v %s \"%s\" &" %( tmp[0],self.CONFIG['google_routesearch_speak_street_lang'], tmp[1])
        elif str.find( " toward " ) <> -1:
            tmp = []
            tmp = str.split("toward")
            cmd = "espeak \"%s toward\" && espeak -v %s \"%s\" &" %( tmp[0],self.CONFIG['google_routesearch_speak_street_lang'], tmp[1])
        elif str.find( " to stay on " ) <> -1:
            tmp = []
            tmp = str.split(" to stay on ")
            cmd = "espeak \"%s to stay on\" && espeak -v %s \"%s\" &" %( tmp[0],self.CONFIG['google_routesearch_speak_street_lang'], tmp[1])
        else:
             cmd = "espeak \"%s\""%( str)
        """
        cmd = "espeak -v %s \"%s\" &"%( self.CONFIG['google_routesearch_speak_street_lang'], str)





        #print "[[[%s]]]"%cmd
        #return None
        os.system(cmd)

    def makeInit(self):
        pass

    def get_name(self):
        return "Google - routesearch"

    def dist_from_vector(self, pa,pb,pc):
        tr = 0.0

        a = (pb[1]-pa[1])/(pb[0]-pa[0])
        c = pa[1]-( pa[0]*( a  ) )
        b = (((-a)*pa[0])-c)/pa[1]

        d = a*pc[0]+b*pc[1]+c
        if d < 0:
            d = -d
        tr = d/( math.sqrt( (a*a)+(b*b) ) )

        return tr

    def angle_from_vector(self, pa, pb, pc):
        a0 = self.osmMapa.cal_angle(pc[0],pc[1], pb[0],pb[1]  )
        a1 = self.osmMapa.cal_angle(pa[0],pa[1], pb[0],pb[1]  )
        res = a0[0]-a1[0]
        if res == 0.0:
            return 10.0

        if res < 0:
            res = -res
        res -= 3.14159265
        if res < 0:
            res = -res
        return res

    def get_key_point_speak(self,m ):
        if not self.CONFIG['google_routesearch_speak_streets_names']:
            return m[5]
        else:
            return m[2]

    def do_draw(self, gpsmap, gdkdrawable):
        print "drive mode", self.drive_mode

        if self.osmMapa.osm.props.zoom>self.zoom_minimum:


            if len( self.markers_icons ) == 0:
                for p in self.markers:
                    if p[3] <> None:
                        self.markers_icons.append( self.osmMapa.osm.image_add( p[0], p[1], p[3] ) )

            if self.osmMapa.get_gpslock() == 0:

                t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
                t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

                cr = gdkdrawable.cairo_create()

                for p in self.markers_lang:
                    lt = p[0]
                    ln = p[1]
                    #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                    if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                        x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                        self.osmMapa.draw_cloud( cr, x,y, p[2])

        else:
            for i in self.markers_icons:
                self.osmMapa.osm.image_remove( i )
            self.markers_icons = []


        if len(self.points) > 0 and self.recalculate_in_progress == 0 and self.osmMapa.get_gpslock():
            print "calculate route and espeak"
            cr = gdkdrawable.cairo_create()
            # find close point
            id_next = 0
            latc = self.osmMapa.osm.props.latitude
            lonc = self.osmMapa.osm.props.longitude
            dis_min = -10
            dis_total = 0
            dis_done = 0
            id = 0
            p_old = [0.0,0.0]
            #print "search for close point------------"

            for i,p in enumerate(self.points):
                if i == 0:
                    p_old = p
                else:
                    angle = self.angle_from_vector( [p[0],p[1]], [latc,lonc],[p_old[0],p_old[1]] )
                    dis = self.osmMapa.distance( p[0],p[1], p_old[0],p_old[1] )
                    dis_total+=dis

                    if dis_min == -10:
                        dis_min = angle
                        id_next = i

                    elif dis_min>=angle:
                        dis_min = angle
                        id_next = i
                        dis_done = 0
                    else:
                        dis_done+=dis


                    p_old = p
            dis_done = dis_total-dis_done


            if self.CONFIG['google_routesearch_auto_recal_make']:
                dis_recal = int(self.CONFIG['google_routesearch_auto_recal'])
                a = self.points[id_next-1]
                b = self.points[id_next]
                c = [latc,lonc]

                """
                x,y = self.osmMapa.osm.geographic_to_screen(a[0],a[1])
                self.osmMapa.draw_cloud( cr, x,y, ("a\n[%f,%f]"%(a[0],a[1])) )

                x,y = self.osmMapa.osm.geographic_to_screen(b[0],b[1])
                self.osmMapa.draw_cloud( cr, x,y, ("b\n[%f,%f]"%(b[0],b[1])) )

                x,y = self.osmMapa.osm.geographic_to_screen(c[0],c[1])
                self.osmMapa.draw_cloud( cr, x,y, ("c\n[%f,%f]"%(c[0],c[1])) )
                """

                ll_ab = self.osmMapa.cal_dist( a[0],a[1],b[0],b[1])
                km_ab = self.osmMapa.distance( a[0],a[1],b[0],b[1])
                ll_cv = self.dist_from_vector(a,b,c)

                res_scale = ((ll_cv*km_ab)/ll_ab)*1000


                print res_scale," max ",int(self.CONFIG['google_routesearch_auto_recal'])
                if res_scale > 60:
                    self.osmMapa.draw_arrow(
                                            gdkdrawable,
                                            self.points[id_next][0],
                                            self.points[id_next][1]
                                            )

                if res_scale > int(self.CONFIG['google_routesearch_auto_recal']) and self.recalculate_in_progress == 0 and self.drive_mode == 1:
                    self.recalculate_in_progress = 1
                    self.clean_layer()
                    self.CONFIG['google_routesearch_from'] = "my current location"
                    self.search_action()



            search_for_it = -1
            for i in range(id_next, len(self.points)):
                p = self.points[i]
                #print "p:[",p,"]"
                #x,y = self.osmMapa.osm.geographic_to_screen(p[0],p[1])
                #self.osmMapa.draw_cloud( cr, x,y, ("id:[%i]\n[%f,%f]"%(i,p[0],p[1])) )

                id = 0
                for m in self.markers_lang:
                    #print "marker:[",m,"] p[",p,"]"
                    if m[0] == p[0] and m[1] == p[1]:
                        search_for_it = id

                        dis_to_key = self.osmMapa.distance( m[0], m[1], latc, lonc )

                        #x,y = self.osmMapa.osm.geographic_to_screen(m[0],m[1])
                        #self.osmMapa.draw_cloud( cr, x,y,
                        #    ("marker:[%f,%f]\nkey id:[%i] point id:[%i]\ndis:%s\n--------------espeak[%s]"%(m[0],m[1],id,i,self.osmMapa.distance_to_string(dis_to_key),m[2])) )

                        #speak = "in %s %s " % ( self.osmMapa.distance_to_string(dis_to_key).replace("m","meters").replace("km", "kilometers"),  m[2])
                        #print ("marker:[%f,%f]\tkey id:[%i] point id:[%i]\tdis:%s\n---espeak[%s]"%(m[0],m[1],id,i,self.osmMapa.distance_to_string(dis_to_key),speak))

                        t = int( time.strftime("%Y%m%d%H%M%S", time.localtime() ) )


                        info = "%s\n%s" % ( self.osmMapa.distance_to_string(dis_to_key), m[2] )
                        self.osmMapa.draw_cloud( cr, 50,5, info, 20, False)


                        tTotal = t-self.rout_t_start
                        speed = (dis_done/tTotal)*3600
                        self.rout_avg_speed = self.osmMapa.distance_to_string( speed )
                        t_todo = ((dis_total-dis_done)/speed)*60
                        if self.CONFIG['width'] < self.CONFIG['height']:
                            break_line = "\n"
                            yoff = 20
                        else:
                            break_line = ""
                            yoff = 0
                        dist = "total:%s done %s in %i %smin. avr: %s/h at place in: %i min." % (
                                                               self.osmMapa.distance_to_string(dis_total),
                                                               self.osmMapa.distance_to_string(dis_done),
                                                               (tTotal/60),
                                                               break_line,
                                                               self.rout_avg_speed,
                                                               t_todo
                                                               )
                        self.osmMapa.draw_cloud( cr, 150,-32-yoff, dist, 16, False)

                        if m[4]<> None:
                            ico = cairo.ImageSurface.create_from_png( m[4] )
                            cr.set_source_surface( ico, 50,65 )
                            cr.paint()



                        if self.espeak_say <> m[2]:
                            self.espeak_say = m[2]
                            self.espeak_dis = 0.203
                            self.espeak_time = t+5

                            speak = "%s. %s" % ( self.osmMapa.distance_to_string(dis_to_key),  self.get_key_point_speak(m))
                            if self.CONFIG['google_routesearch_speak']:
                                self.espeak_cmd( speak )
                        elif self.espeak_say == m[2] and t > (self.espeak_time):
                                #print dis_to_key,"\t",self.espeak_dis,"\t",t

                                if dis_to_key < 0.200 and self.espeak_dis > 0.200:
                                    self.espeak_dis = dis_to_key
                                    self.espeak_time = t+4

                                    speak = "%s. %s" % ( self.osmMapa.distance_to_string(dis_to_key),  self.get_key_point_speak(m))
                                    if self.CONFIG['google_routesearch_speak']:
                                        self.espeak_cmd( speak )

                                elif dis_to_key < 0.100 and self.espeak_dis > 0.100:
                                    self.espeak_dis = dis_to_key
                                    self.espeak_time = t+4

                                    speak = "%s. %s" % ( self.osmMapa.distance_to_string(dis_to_key),  self.get_key_point_speak(m))
                                    if self.CONFIG['google_routesearch_speak']:
                                        self.espeak_cmd( speak )
                                elif dis_to_key < 0.025 and self.espeak_dis > 0:
                                    self.espeak_dis = dis_to_key
                                    self.espeak_time = t+30

                                    speak = "%s" % ( self.get_key_point_speak(m))
                                    if self.CONFIG['google_routesearch_speak']:
                                        self.espeak_cmd( speak )







                        """
                        self.espeak_say = ""
                        self.espeak_dis = 0
                        self.espeak_time = 0
                        """


                        #search_for_it = -1
                        break
                        #print "marker found !",m
                    id+=1

                if search_for_it <> -1:
                    break




    def clean_layer(self):
        self.drive_mode = 0

        for i in self.markers_icons:
            self.osmMapa.osm.image_remove( i )
        self.markers_icons = []

        for t in self.tracks:
            self.osmMapa.osm.track_remove( t )
        self.tracks = []

        for i in self.icons:
            self.osmMapa.osm.image_remove( i )
        self.icons = []

        self.points = []
        self.markers = []
        self.markers_lang = []
        self.my_point = -1

        self.rout_avg_speed = 0.0
        self.rout_t_start = int( time.strftime("%Y%m%d%H%M%S", time.localtime() ) )
        self.rout_t_done = 0

    def on_clear(self, w, dialog):
        self.clean_layer()
        dialog.destroy()

    def search_action(self, dialog=None):
        self.recalculate_in_progress = 1
        self.clean_layer()
        self.drive_mode = 1

        try:
            if self.bt_offline.get_active():
                zoom_dialog = MyZoomSelect(self)
                zoom_dialog.run()
        except:
            self.bt_offline = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.osmMapa.showBanner(("searching route...\nfrom: %s\nto: %s" % (self.CONFIG['google_routesearch_from'],self.CONFIG['google_routesearch_to'])))
        t = googleRoutesearchDownloader( self, self.CONFIG, self.bt_offline.get_active(), self.zoom_min, self.zoom_max )
        t.start()

        #xml_res = self.downloadXml()
        #print xml_res
        #self.parseXml( xml_res )
        try:
            dialog.destroy()
        except:
            pass

    def on_search(self,w,dialog):
        print "search route start"
        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()

        self.search_action( dialog )


    def on_swap(self, w ):
        a = self.e_start.get_text()
        self.e_start.set_text( self.e_end.get_text() )
        self.e_end.set_text( a )

        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()

    def on_clean(self,w):
        self.e_start.set_text("my current location")
        self.e_end.set_text("")

        self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        self.CONFIG['google_routesearch_to'] = self.e_end.get_text()

    def on_add(self, w):
        if self.e_start.is_focus():
            self.e_start.set_text( "loc:%f+%f"%(self.osmMapa.osm.props.latitude, self.osmMapa.osm.props.longitude) )
            self.CONFIG['google_routesearch_from'] = self.e_start.get_text()
        else:
            self.e_end.set_text( "loc:%f+%f"%(self.osmMapa.osm.props.latitude, self.osmMapa.osm.props.longitude) )
            self.CONFIG['google_routesearch_to'] = self.e_end.get_text()
    def on_changed_mode (self,picker):
        str = picker.get_value()
        id = -1
        iter = 0
        for mode_name in self.mode:
            if mode_name == str:
                id = iter
                break
            else:
                iter+=1
        print "selected mode: ", self.mode[id]
        self.CONFIG['google_routesearch_mode'] = id
    def on_changed_lang (self,picker,dialog):
        str = picker.get_value()
        for i, lang_name in enumerate(self.espeak_langs):
            if lang_name == str:
                if str <> self.CONFIG['google_routesearch_speak_street_lang'] and len(self.points)>0:
                    self.CONFIG['google_routesearch_speak_street_lang'] = str
                    self.search_action(dialog)

                else:
                    self.CONFIG['google_routesearch_speak_street_lang'] = str
                break

        print "selected lang: ", self.CONFIG['google_routesearch_speak_street_lang']

    def on_changed_dis (self,picker,dialog):
        str = picker.get_value()
        for i in range( 50, 1500, 50):
            if i == int(str):
                self.CONFIG['google_routesearch_auto_recal'] = str
                break

        print "selected google_routesearch_auto_recal: ", self.CONFIG['google_routesearch_auto_recal']

    def on_bt_relac(self,w):
        if w.get_active():
            self.CONFIG['google_routesearch_auto_recal_make'] = 1
        else:
            self.CONFIG['google_routesearch_auto_recal_make'] = 0

    def on_bt_export(self,w, dialog):
        dialog.destroy()
        d = SaveTrackDialog()
        file = d.startIt()
        print "file to load", file
        if file <> "":
            print "export export export "
            f = open( file, "w")
            f.write("""<?xml version="1.0"?>
<gpx creator="yosmapa" version="1.0">""" )

            for p in self.markers_lang:
                f.write("""
<wpt lat="%f" lon="%f">
  <name>%s</name>
  <sym>http://maps.gstatic.com/intl/pl_ALL/mapfiles/ms/micons/blue-dot.png</sym>
</wpt>""" %( p[0],p[1],p[2]) )


            f.write("""<trk>
    <name>Line 1</name>
    <trkseg>
""")
            for p in self.points:
                f.write("        <trkpt lat=\"%f\" lon=\"%f\"></trkpt>\n"%(p[0],p[1]))
            f.write("""    </trkseg>
</trk>
</gpx>"""         )
            f.close()
    def on_bt_speak(self, w):
        self.CONFIG['google_routesearch_speak'] = w.get_active()
    def on_bt_speak_st(self, w):
        self.CONFIG['google_routesearch_speak_streets_names'] = w.get_active()

    def get_menu_widgets(self, dialog):


        vbox = gtk.VBox()

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        vbox.pack_start( panel, True,True)
        panel.set_size_request(640, 280)


        abox = gtk.HBox()
        abox.pack_start(gtk.Label("A:"),False)
        self.e_start = gtk.Entry()
        self.e_start.set_text(self.CONFIG['google_routesearch_from'])
        abox.pack_start(self.e_start, True)

        bbox =gtk.HBox()
        bbox.pack_start(gtk.Label("B:"),False)
        self.e_end = gtk.Entry()
        self.e_end.set_text(self.CONFIG['google_routesearch_to'])
        bbox.pack_start(self.e_end, True)


        abbox = gtk.VBox()
        abbox.pack_start( abox,True)
        abbox.pack_start( bbox,True)


        scbox = gtk.HBox()
        bt_swap = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL, "swap")
        #bt_swap.set_text("swap points","some value")
        bt_swap.connect("clicked", self.on_swap)
        scbox.pack_start( bt_swap, False)

        bt_c = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Clear")
        bt_c.connect("clicked", self.on_clean)
        scbox.pack_start( bt_c, False)




        abscbox = gtk.HBox()
        abscbox.pack_start( abbox, True )
        abscbox.pack_start( scbox, False )
        mvbox.pack_start( abscbox, True)







        """
        #sftp://yoyo@yoyo.ghost.pl/home/yoyo/yosmapa_builder/yosmapa_builder
        self.bt_auto = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.bt_auto.set_label("auto")
        hbox.pack_start(self.bt_offline, True)
        mvbox.pack_start( hbox, True )
        """

        hbox = gtk.HBox()

        bt_a = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Add")
        bt_a.connect("clicked", self.on_add)
        hbox.pack_start( bt_a, False)


        bt_search = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Find route")
        bt_search.connect("clicked", self.on_search, dialog)
        hbox.pack_start( bt_search, True)

        if len( self.tracks ):
            bt_clear = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Clear route")
            bt_clear.connect("clicked", self.on_clear, dialog)
            hbox.pack_start( bt_clear, True)


        mvbox.pack_start(hbox, True)



        mvbox.pack_start(gtk.HSeparator(),True)


        hbox = gtk.HBox()
        pb_mode = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_VERTICAL)
        pb_mode.set_title("Transport mode")
        selector_mode = hildon.TouchSelectorEntry(text=True)
        mode_set_id = 0
        iter_nr = 0
        for mode_name in self.mode:
            selector_mode.append_text(mode_name)
        pb_mode.set_selector(selector_mode)
        pb_mode.set_active( self.CONFIG['google_routesearch_mode'] )
        pb_mode.connect("value-changed",self.on_changed_mode)
        hbox.pack_start( pb_mode, True )

        self.bt_offline = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.bt_offline.set_label("work offline")
        hbox.pack_start(self.bt_offline, True)
        mvbox.pack_start( hbox, True )

        mvbox.pack_start(gtk.HSeparator(),True)


        if self.espeak:
            l = gtk.Label("espeak settings:")
            mvbox.pack_start(l,False)
            hbox = gtk.HBox()
            self.bt_speak = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
            self.bt_speak.set_label("speak")
            if self.CONFIG['google_routesearch_speak']:
                self.bt_speak.set_active( True )
            self.bt_speak.connect("clicked", self.on_bt_speak)
            hbox.pack_start(self.bt_speak, True)


            pb_lang = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_VERTICAL)
            pb_lang.set_title("lang")
            selector_lang = hildon.TouchSelectorEntry(text=True)
            id = 0
            for i,lang_name in enumerate(self.espeak_langs):
                selector_lang.append_text(lang_name)
                if lang_name == self.CONFIG['google_routesearch_speak_street_lang']:
                    id = i
            pb_lang.set_selector(selector_lang)
            pb_lang.set_active( id  )
            pb_lang.connect("value-changed",self.on_changed_lang, dialog)
            hbox.pack_start( pb_lang, True )
            mvbox.pack_start(hbox,True)



            self.bt_speak_st = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
            self.bt_speak_st.set_label("speak\nstreet names")
            if self.CONFIG['google_routesearch_speak_streets_names']:
                self.bt_speak_st.set_active( True )
            self.bt_speak_st.connect("clicked", self.on_bt_speak_st)
            hbox.pack_start(self.bt_speak_st, True)

            mvbox.pack_start(gtk.HSeparator(),True)

        if len( self.tracks ):
            bt_export = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Export route to gpx")
            bt_export.connect("clicked", self.on_bt_export, dialog )
            mvbox.pack_start( bt_export, True)
            mvbox.pack_start(gtk.HSeparator(),True)


        l = gtk.Label("auto recalculation:")
        mvbox.pack_start(l,False)
        hbox = gtk.HBox()
        #self.CONFIG['google_routesearch_auto_recal']

        self.bt_recal = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.bt_recal.set_label("make it")
        self.bt_recal.set_active( self.CONFIG['google_routesearch_auto_recal_make'] )
        self.bt_recal.connect("clicked", self.on_bt_relac )
        hbox.pack_start(self.bt_recal, True)

        pb_dis = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_VERTICAL)
        pb_dis.set_title("if distance is greater than [meters]")
        selector_dis = hildon.TouchSelectorEntry(text=True)
        id = 0
        for i in range( 100, 1600, 100 ):
            selector_dis.append_text(("%s"%i))
            if i == int(self.CONFIG['google_routesearch_auto_recal']):
                print "set_active",i
                id = i
        pb_dis.set_selector(selector_dis)
        pb_dis.set_active( id  )
        pb_dis.connect("value-changed",self.on_changed_dis, dialog)
        hbox.pack_start( pb_dis, True )


        mvbox.pack_start(hbox,True)
        mvbox.pack_start(gtk.HSeparator(),True)


        return vbox

    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass