import gtk
import hildon
import cairo


class WelcomeScreen( hildon.StackableWindow ):


    def __init__(self, osmMapa,config):
        hildon.StackableWindow.__init__(self)
        self.osmMapa = osmMapa
        self.CONFIG = config
        self.osmMapa.set_autorotate_for_object(self)
        self.set_title("Welcome")

        vbox = gtk.VBox()
        self.add(vbox)


        self.store = self.create_store()
        self.fill_store( self.store )

        self.iv = gtk.IconView( self.store )
        self.iv.set_column_spacing( 40 )
        self.iv.set_row_spacing( 30 )
        self.iv.set_margin(30)
        style = self.iv.get_style()
        style.bg[gtk.STATE_NORMAL] = gtk.gdk.color_parse( "#e8e8e8" )
        self.iv.set_style( style )
        self.iv.set_selection_mode( gtk.SELECTION_SINGLE )
        self.iv.set_text_column(0)
        self.iv.set_pixbuf_column(1)
        self.iv.connect("selection-changed", self.on_item_activated)

        vbox.pack_start(self.iv, True)


        bt_show = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        bt_show.set_label("welcome screen")
        try:
            if self.CONFIG['welcome_screen']:
                bt_show.set_active( self.CONFIG['welcome_screen'] )
        except:
            self.CONFIG['welcome_screen'] = 1
            bt_show.set_active( self.CONFIG['welcome_screen'] )
            pass
        bt_show.connect("clicked", self.on_bt_show)
        vbox.pack_start(bt_show, False)


        self.show_all()

    def on_bt_show(self,w):
        self.CONFIG['welcome_screen'] = w.get_active()

    def on_item_activated(self, widget):
        print "activeted"
        path = self.iv.get_selected_items()[0]
        iter = self.store.get_iter( path )

        action = self.store.get_value( iter, 0)

        self.destroy()

        if action == "setting":
            self.osmMapa.build_mainMenu()
        elif action == "search":
            self.osmMapa.build_search()
        elif action == "route":
            self.osmMapa.build_route()
        elif action == "track record":
            self.osmMapa.set_config("track_record",True)


    def fill_store(self,store):
        store.clear()

        store.append(["mapa",           self.get_pixbuf("./imgs/ico_map2_128_128.png"), True])
        if self.osmMapa.find_plugins:
            store.append(["search",         self.get_pixbuf("./imgs/ico_find2_128_128.png"), True])
        if self.osmMapa.plugin_present("Google - routesearch"):
            store.append(["route",          self.get_pixbuf("./plugins/ico_navi2_128_128.png"), True])
        if self.osmMapa.plugin_present("gpx track"):
            store.append(["track record",   self.get_pixbuf("./plugins/ico_gpx_r_128_128.png"), True])
        store.append(["setting",        self.get_pixbuf("./imgs/ico_config2_128_128.png"), True])


    def get_pixbuf(self,str):
        return gtk.gdk.pixbuf_new_from_file( str )

    def create_store(self):
        store = gtk.ListStore(str, gtk.gdk.Pixbuf, bool)
        store.set_sort_column_id(0, gtk.SORT_ASCENDING)
        return store

