import os
import cairo

class BuildPluginsList():

    def my_import(self,name):
        mod = __import__(name)
        components = name.split('.')
        for comp in components[1:]:
            mod = getattr(mod, comp)
        return mod

    def __init__(self, osmMapa, config):
        self.plugins = []
        self.CONFIG = config

        for dirname, dirnames, filenames in os.walk( "./plugins/", topdown=True):
            for filename in filenames:
                if dirname == "./plugins/" and filename<>"plugin_proto.py" and filename.find(".pyo") == -1 and filename.find(".png") == -1 and filename.find(".txt") == -1 and filename.find("dont_") == -1 and filename.find("/") == -1:
                    name = filename.replace(".py", "")
                    path = "plugins.%s" % name
                    plug_name = "plugins/%s"%name
                    print "import [%s]"% plug_name
                    module = __import__(plug_name)
                    the_class = getattr(module, name)
                    c = the_class( osmMapa, self.CONFIG )
                    plugin_name = c.get_name()

                    try:
                        if self.CONFIG[plugin_name]:
                            print "CONFIG ",plugin_name,"--> plugin active"
                    except:
                        print "CONFIG ",plugin_name,"-- >plugin not store in config, add it ",plugin_name
                        self.CONFIG[plugin_name] = 0

                    try:
                        ico = cairo.ImageSurface.create_from_png( "./plugins/%s" % c.ico )
                    except:
                        ico = None


                    self.plugins.append([c,plugin_name, ico])


    def get_plugins_list(self):
        return self.plugins