import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import urllib
import osmgpsmap
import math
import cairo
import hildon

from threading import Thread

class googlePlacelsDownloader(Thread):
    def __init__(self,geonames,box,str="", more = False):
        Thread.__init__(self)
        self.geonames = geonames
        self.tp = ""
        self.box = box
        self.zoom_start = self.geonames.osmMapa.osm.props.zoom
        self.str = str
        self.more = more

        self.zoom_out_iter = 0

    def parseXml(self, xml_res):
        tr = []
        try:
            doc = xml.dom.minidom.parseString(xml_res)

            status = doc.getElementsByTagName("status")[0].childNodes[0].data
            if status == "OK":
                for p in doc.getElementsByTagName("result"):
                    #print "add item"
                    lat = float(p.getElementsByTagName("lat")[0].childNodes[0].data)
                    lon = float(p.getElementsByTagName("lng")[0].childNodes[0].data)
                    name = p.getElementsByTagName("name")[0].childNodes[0].data
                    desc = p.getElementsByTagName("vicinity")[0].childNodes[0].data
                    id  = p.getElementsByTagName("id")[0].childNodes[0].data
                    reference  = p.getElementsByTagName("reference")[0].childNodes[0].data

                    try:
                        ico_href = p.getElementsByTagName("icon")[0].childNodes[0].data
                        ico_name = "./maps/%s" % ico_href.replace("/", "_")
                        if not os.path.exists( ico_name ):
                            ico_cmd = "wget \"%s\" -O \"%s\"" % (ico_href, ico_name )
                            os.system(ico_cmd)
                        ico = gdk.pixbuf_new_from_file(ico_name)
                        if ico.get_height() > 24:
                            ico = ico.scale_simple(24,24, gtk.gdk.INTERP_HYPER)
                    except Exception, e:
                        #print "ico igla not from server :/ [%s]" %e
                        ico_name = "./maps/ico_igla_32_32.png"
                        ico = gdk.pixbuf_new_from_file(ico_name)
                        if ico.get_height() > 24:
                            ico = ico.scale_simple(24,24, gtk.gdk.INTERP_HYPER)



                    add_it = 1


                    if add_it:
                        tr.append( [
                            lat,
                            lon,
                            self.geonames.get_name(),
                            name,
                            ico,
                            None,
                            self.geonames.from_zoom,
                            {
                             'name':    name,
                             'lat':     lat,
                             'lon':     lon,
                             'ico':     ico_name,
                             'desc':    desc,
                             'id':      id,
                             'reference': reference
                             }
                            ])
            else:
                print "googlePlacels parseXml status[%s]" % status

            print "-----------------------------------------DONE"
        except Exception, e:
            print "googlePlacels parseXml Error: ",e

        return tr


    def downloadXml(self):

        types = ["accounting","airport","amusement_park","aquarium","art_gallery","fuel", "atm","bakery","bank","bar","beauty_salon","bicycle_store","book_store","bowling_alley","bus_station","cafe","campground","car_dealer","car_rental","car_repair","car_wash","casino","cemetery","church","city_hall","clothing_store","convenience_store","courthouse","dentist","department_store","doctor","electrician","electronics_store","embassy","establishment","finance","fire_station","florist","food","funeral_home","furniture_store","gas_station","general_contractor","geocode","grocery_or_supermarket","gym","hair_care","hardware_store","health","hindu_temple","home_goods_store","hospital","insurance_agency","jewelry_store","laundry","lawyer","library","liquor_store","local_government_office","locksmith","lodging","meal_delivery","meal_takeaway","mosque","movie_rental","movie_theater","moving_company","museum","night_club","painter","park","parking","pet_store","pharmacy","physiotherapist","place_of_worship","plumber","police","post_office","real_estate_agency","restaurant","roofing_contractor","rv_park","school","shoe_store","shopping_mall","spa","stadium","storage","store","subway_station","synagogue","taxi_stand","train_station","travel_agency","university","veterinary_care","zoo"]

        """
https://maps.googleapis.com/maps/api/place/search/xml?location=52.382282,16.964178&radius=1000&types=gas_station&name=Orlen&sensor=false&key=AIzaSyChxqzGp-MlZ1p7jPQfy22KNiP9UlNOFjI
        """


        sType = ""
        sName = ""

        """
        str2 = self.str.replace(" ","_")
        for t in types:
            if t.find( str2 ) <> -1:
                sType = "&type=%s" % t
                print "googlePlacels search by type ! "
                break
        """

        if sType == "":
            print "googlePlacels search by name "
            sName = "&name=%s" % self.str.replace(" ", "%20")


        t_lt, t_ln, b_lt, b_ln = self.box
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        #print t_lt, t_ln, b_lt, b_ln


        dis = int(self.geonames.osmMapa.distance( self.geonames.CONFIG['lat'], self.geonames.CONFIG['lon'], t_lt, t_ln)*250)
        req = "/maps/api/place/search/xml?location=%f,%f&radius=%i%s%s&sensor=false&key=AIzaSyChxqzGp-MlZ1p7jPQfy22KNiP9UlNOFjI" % (
            self.geonames.CONFIG['lat'], self.geonames.CONFIG['lon'],
            dis,
            sType,
            sName
            )
        url = "https://maps.googleapis.com%s" % req
        print "uri:[%s]" % url
        googleRes = urllib.urlopen( url )


        return googleRes.read()


    def run(self):
        if self.more == False:
            self.geonames.osmMapa.showBanner(("searching:%s" % self.str))

        """
        if self.geonames.chkin == 0:
            print "googlePlacels chkin ------------------------"
            conn = httplib.HTTPSConnection("maps.googleapis.com")
            req = "/maps/api/place/check-in/xml?sensor=false&key=AIzaSyChxqzGp-MlZ1p7jPQfy22KNiP9UlNOFjI"
            print req
            conn.request("POST", req)
            r = conn.getresponse()
            print "googlePlacels results [",r.read(),"]------------------------"

            print "googlePlacels chkin ------------------------DONE"
        """

        print "googlePlacels downolad"
        res = self.downloadXml()
        print "googlePlacels parse"
        tr = self.parseXml( res )
        print "googlePlacels parse DONE len(",len(tr),")"

        if len(tr)==0 and self.zoom_out_iter < 2:

            dis = self.geonames.osmMapa.cal_dist( self.box[0], self.box[1], self.box[2], self.box[3] )
            if dis<0: dis = -dis
            self.box = [
                        self.box[0]-dis,
                        self.box[1]-dis,
                        self.box[2]+dis,
                        self.box[3]+dis
                        ]
            self.zoom_out_iter+=1
            #self.geonames.osmMapa.showBanner("looking on bigger area")
            self.run()
        elif len(tr)==0:
            #self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            self.geonames.ui_thread = 2
            #self.geonames.osmMapa.showBanner("no result in bigger area too :..(")
        else:
            #self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            print "googlePlacels downolad"
            print "googlePlacels DONE"

        if len( tr ) > 0:
            for p in tr:
                self.geonames.osmMapa.show_find_results.append( p )
            #self.geonames.osmMapa.recalculate_center_and_zoom()
            self.geonames.ui_thread = 2
            print "googlePlacels add marker"




class googlePlacelsReferenceDownloader(Thread):
    def __init__(self,geonames,ref):
        Thread.__init__(self)
        self.geonames = geonames
        self.ref = ref


    def parseXml(self, xml_res):
        tr = []
        try:
            doc = xml.dom.minidom.parseString(xml_res)

            status = doc.getElementsByTagName("status")[0].childNodes[0].data
            if status == "OK":
                for p in doc.getElementsByTagName("result"):
                    #print "add item"
                    name = p.getElementsByTagName("name")[0].childNodes[0].data
                    desc = p.getElementsByTagName("formatted_address")[0].childNodes[0].data
                    phone = p.getElementsByTagName("formatted_phone_number")[0].childNodes[0].data

                    tr.append( name )
                    tr.append( desc )
                    tr.append( phone )

            else:
                print "googlePlacels ref parseXml status[%s]" % status

            print "-----------------------------------------DONE"
        except Exception, e:
            print "googlePlacels ref parseXml Error: ",e

        return tr


    def downloadXml(self):
        req = "/maps/api/place/details/xml?reference=%s&sensor=true&key=AIzaSyChxqzGp-MlZ1p7jPQfy22KNiP9UlNOFjI" % self.ref
        url = "https://maps.googleapis.com%s" % req
        print "uri:[%s]" % url
        googleRes = urllib.urlopen( url )
        return googleRes.read()


    def run(self):
        print "googlePlacels ref downolad"
        res = self.downloadXml()
        print "googlePlacels ref parse"
        self.geonames.ref_result = self.parseXml( res )
        print "googlePlacels ref parse DONE len(",len(self.geonames.ref_result),")"
        if len(self.geonames.ref_result) == 0:
            self.geonames.ref_result.append( 0 )






class google_places:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "google_places.png"



        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 1
        self.ui_thread = 1

        self.from_zoom = 7

        self.box_old = 0,0,0,0

        self.draw = 0
        self.results = []
        self.timeout = 3
        self.downloadMore = 0

        self.ref_result = []

        self.logo = cairo.ImageSurface.create_from_png( "./plugins/powered-by-google-on-black.png" )

        print "__init__ googlePlacels"



    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):
        pass



    def get_name(self):
        return "Google - places"

    def search_query(self, str):
        # TODO
        self.results = []
        self.ui_thread = 1
        self.box = self.osmMapa.osm.get_bbox()
        self.CONFIG['googlePlacels_search'] = str
        t = googlePlacelsDownloader( self, self.box, self.CONFIG['googlePlacels_search'])
        t.start()
        return []

    def get_menu_widgets(self, dialog):
        return None


    def get_reference( self, ref ):
        self.ref_result = []
        t = googlePlacelsReferenceDownloader( self, ref)
        t.start()


    def do_draw(self, gpsmap, gdkdrawable):
        if len( self.osmMapa.show_find_results )>0:
            power = 0
            name = self.get_name()
            for i in self.osmMapa.show_find_results:
                if i[2] == name:
                    cr = gdkdrawable.cairo_create()
                    cr.set_source_surface( self.logo, self.CONFIG['width']-230,10 )
                    cr.paint()
                    print "add logo"
                    break


    def do_button_release(self, gpsmap, gdkeventbutton):
        pass