import hildon
import gtk
import gobject

class SearchDialog( hildon.Dialog):
    def __init__(self, osmMapa, config ):
        gtk.Dialog.__init__(self)
        self.osmMapa = osmMapa
        self.CONFIG = config

        self.threaded_plugin_loop = []

        print "SearchDialog len:",len(self.osmMapa.show_find_results)
        if len(self.osmMapa.show_find_results) > 0:
            self.osmMapa.marker_clear_from_layer( self.osmMapa.show_find_results )
            self.osmMapa.show_find_results = []
            self.destroy()
            return None
        else:
            self.build()

    def build(self):
        try:
            print "SearchDialog search for:\n",self.CONFIG['search'],"\n-----------"
        except:
            self.CONFIG['search'] = ""

        try:
            print "SearchDialog recent search for:\n",self.CONFIG['recent_search'],"\n-----------"
            i = len(self.CONFIG['recent_search'])
        except:
            self.CONFIG['recent_search'] = []

        recent_max = 100
        if len( self.CONFIG['recent_search'] ) > recent_max:
            self.CONFIG['recent_search'].pop(  )

        self.set_title("Search")
        self.set_size_request(640, 600)


        if len(self.CONFIG['recent_search'])>0:
            mvbox = gtk.VBox()
            panel = hildon.PannableArea()
            panel.add_with_viewport(mvbox)
            self.vbox.pack_start( panel, True,True)
            panel.set_size_request(640, 280)

            for s in self.CONFIG['recent_search']:
                hbox = gtk.HBox()
                try:
                    f_name = "%s_%s.jpg" % (home, md5.new(s[0]).hexdigest())
                    if os.path.isfile(f_name):
                        img = gtk.Image()
                        img.set_from_file(f_name)
                        hbox.pack_start(img,False)
                except:
                    pass
                b = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,s[0])
                b.connect("clicked", self.on_recent_click)
                hbox.pack_start(b, True)
                mvbox.pack_start(hbox, False)


        hbox = gtk.HBox()

        self.plugins_query = []

        for p in self.osmMapa.find_plugins:
            try:
                if p[0].ui_search:
                    if p[0].ico:
                        try:
                            if p[0].ui_thread:
                                it_thread = 1
                            else:
                                it_thread = 0
                        except:
                            it_thread = 0
                        if it_thread:
                            self.plugins_query.append( [p[0], None ])
                        else:
                            self.plugins_query.append( [p[0] ])
                        ico = gtk.Image()
                        ico.set_from_file( "./plugins/%s"%p[0].ico )
                        hbox.pack_start(ico,False)


            except Exception, e:
                print "SearchDialog plugins query init ERROR ",p[1],e



        bt_c = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"[x]")
        hbox.pack_start(bt_c, False)

        e_search = gtk.Entry()
        hbox.pack_start(e_search,True)

        bt_c.connect("clicked", self.on_clean, e_search)


        bt_search = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Find")
        bt_search.connect("clicked", self.on_search, e_search)
        hbox.pack_start(bt_search,False)


        self.vbox.pack_start(hbox,False)

        self.show_all()
        self.run()
        self.destroy()


    def add_item_to_box(self, i):
        hbox = gtk.HBox()

        l = gtk.Label("%s"% self.osmMapa.distance_to_string( self.osmMapa.distance( i[0],i[1] ) ) )
        hbox.pack_start(l, False)

        ico = gtk.Image()
        ico.set_from_pixbuf( i[4] )
        hbox.pack_start(ico,False)

        l = gtk.Label( i[3] )
        l.set_line_wrap(True)
        hbox.pack_start(l,False)

        l = gtk.Label( " " )
        hbox.pack_start(l,True)

        bt = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Action")
        bt.connect("clicked", self.on_result_release, i)
        hbox.pack_start(bt, False)

        return hbox

    def on_search(self, w, e_search = None):
        if e_search:
            self.CONFIG['search'] = e_search.get_text()
        reTmp = []
        reTmp.append( [self.CONFIG['search'],None] )
        for r in self.CONFIG['recent_search']:
            if r[0] <> self.CONFIG['search']:
                reTmp.append( r )
        self.CONFIG['recent_search'] = []
        self.CONFIG['recent_search'] = reTmp

        self.threaded_plugin_loop = []

        d = hildon.Dialog()
        d.set_title("Results: [%s]"%self.CONFIG['search'])

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        d.vbox.pack_start( panel, True,True)
        panel.set_size_request(640, 600)

        for p in self.plugins_query:

            res = p[0].search_query( self.CONFIG['search'] )

            hbox = gtk.HBox()

            l = gtk.Label( "%s (%i):" % (p[0].get_name(), len(res)) )
            hbox.pack_start(l,False)
            l = gtk.Label()
            hbox.pack_start(l,True)
            mvbox.pack_start( hbox, False )

            if len(p) == 2:
                vbox = gtk.VBox()
                p[1] = vbox
                mvbox.pack_start( vbox, False)
                self.make_delay_iter_for_ui_thread( p )

            for i in res:
                mvbox.pack_start(self.add_item_to_box(i),False)
                self.osmMapa.show_find_results.append(  i )

            h = gtk.HSeparator()
            mvbox.pack_start(h,True)

        #d.show_all()
        self.destroy()
        #d.run()
        d.destroy()
        self.osmMapa.recalculate_center_and_zoom()


    def make_delay_iter_for_ui_thread(self, plugin):
        print "make_delay_iter_for_ui_thread ",plugin[0].get_name()

        self.threaded_plugin_loop.append( plugin[0] )

        if len( self.threaded_plugin_loop ) == 1:
            self.make_threaded_plugin_loop_run()

    def make_threaded_plugin_loop_run(self):


        working = 0
        for p in self.threaded_plugin_loop:
            if p.ui_thread == 1:
                working+=1

        if working == 0:
            self.threaded_plugin_loop = []
            self.osmMapa.recalculate_center_and_zoom()


        if len( self.threaded_plugin_loop ) > 0:
            print "make_threaded_plugin_loop_run loop",len( self.threaded_plugin_loop )
            gobject.timeout_add( 1000, self.make_threaded_plugin_loop_run )


    def on_result_release(self, w, item):
        print "item release:",item
        m = gtk.Menu()
        dis = self.osmMapa.distance_to_string( self.osmMapa.distance( item[0],item[1] ) )

        mi = gtk.MenuItem("Distans it: %s___________" % dis)
        m.append(mi)

        mi = gtk.MenuItem("Center to___________")
        #mi.connect("activate",self.on_set_center,c[4],c[5])
        m.append(mi)

        if self.CONFIG['POI']:
            mi = gtk.MenuItem("Add as POI___________")
            #mi.connect("activate",self.on_add_as_poi,c[4],c[5])
            m.append(mi)

        if self.CONFIG['Google - routesearch']:
            mi = gtk.MenuItem("Route to it___________")
            #mi.connect("activate",self.on_route_to_it,c[4],c[5])
            m.append(mi)

        m.show_all()
        m.popup( None, None, None , 2, 0)


    def on_recent_click(self,w):
        self.CONFIG['search'] = w.get_title()
        self.on_search(None)


    def on_clean(self, w, e_search ):
        e_search.set_text("")
        self.CONFIG['search'] = ""
