import gtk
import hildon
import osmgpsmap


class DetailsWindow(gtk.Window):

    def __init__(self, osmMapa, point):
        gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
        self.point = point
        self.osmMapa = osmMapa

        self.set_default_size(500, 500)
        self.set_title("Detials")




        vbox = gtk.VBox()
        vbox0 = gtk.VBox()

        vbox.pack_start( self.get_label("<big>%s</big>" % point[3]) , False)


        osm = osmgpsmap.GpsMap()
        osm.set_center_and_zoom( point[0], point[1], 16 )
        osm.set_size_request(640, 180)
        osm.image_add( point[0], point[1], point[4]  )
        osm.connect('button_release_event', self.on_map_clicked, point[0], point[1])
        osm.connect('button_press_event', self.on_map_clicked, point[0], point[1])
        vbox.pack_start( osm, False)


        label = gtk.Label( "Lat: %f" % point[0] )
        vbox.pack_start( self.get_label(
            "<small>%s</small>" %  self.osmMapa.distance_to_string( self.osmMapa.distance( point[0], point[1]) )
            )
            , False)
        vbox.pack_start( self.get_label("Latitude: %f" % point[0]), False)
        vbox.pack_start( self.get_label("Longitude: %f" % point[1]), False)
        vbox.pack_start( self.get_label("Point from : %s" % point[2]), False)



        panel = hildon.PannableArea()
        panel.add_with_viewport(vbox)
        vbox0.pack_start( panel, True)

        bt_mapa = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Mapa")
        bt_mapa.connect("clicked", self.on_mapa)
        vbox0.pack_start( bt_mapa, False)

        self.add(vbox0)

        self.show_all()

    def on_map_clicked(self,osm,event, lat, lon):
        osm.set_center_and_zoom( lat, lon, 16 )

    def on_mapa(self,w):
        self.destroy()


    def get_label(self, str):
        hbox = gtk.HBox( spacing = 5 )
        l0 = gtk.Label()
        l0.set_markup( str )
        hbox.pack_start( l0, False)

        l1 = gtk.Label()
        hbox.pack_start( l1, True)
        return hbox