import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo


from threading import Thread

class rcspot_eventyDownloader(Thread):
    def __init__(self,pa):
        Thread.__init__(self)
        self.pa = pa



    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        for event in doc.getElementsByTagName("event"):
            e = [
                 event.getElementsByTagName("nazwa")[0].childNodes[0].data,
                 float(event.getElementsByTagName("lon")[0].childNodes[0].data),
                 float(event.getElementsByTagName("lat")[0].childNodes[0].data),
                 event.getElementsByTagName("start_str")[0].childNodes[0].data
                 ]
            self.pa.eventy.append( e )
        print "rcspot found ",len(self.pa.eventy),"events"

    def downloadXml(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("www.rcspot.pl")
        conn.request("GET", "/api_xml.php?p=eventy")
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "rcspot_eventyDownloader downolad"
        res = self.downloadXml()
        print "rcspot_eventyDownloader parse"
        self.parseXml( res )
        self.pa.do_draw_address()
        print "rcspot_eventyDownloader DONE"

class rcspot_eventy:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa
        self.ico = "rcspot.png"

        print "__init__ rcspot eventy"


    def do_draw_address(self):
        for e in self.eventy:
            i = gdk.pixbuf_new_from_file( './plugins/rcspot.png' )
            self.images.append( self.osmMapa.osm.image_add(e[1], e[2],i) )

    def clean_layer(self):
        self.eventy = []
        for i in self.images:
            self.osmMapa.osm.image_remove( i )
        self.images = []

    def killIt(self):
        self.clean_layer()

    def makeInit(self):
        self.eventy = []
        self.images = []
        t = rcspot_eventyDownloader(self)
        t.start()

        return self



    def on_bt_update(self, w, dialog):
        self.clean_layer()
        self.makeInit()

        dialog.destroy()

    def get_menu_widgets(self, dialog):
        bt_update = gtk.Button("update")
        bt_update.connect("clicked", self.on_bt_update, dialog)
        return bt_update

    def get_name(self):
        return "rcspot eventy"

    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>10:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            cr = gdkdrawable.cairo_create()
            for p in self.eventy:
                lt = p[1]
                ln = p[2]
                #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                    self.osmMapa.draw_cloud( cr, x,y, ("%s\n%s" %(p[3],p[0]) ) )

    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass