import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import osmgpsmap
import math
import cairo


class fotoradary:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG

        self.ico = "fotoradary.png"
        self.osmMapa = osmMapa
        self.CONFIG = CONFIG
        self.file = "./plugins/fotoradary.txt"
        self.ico_fotoradar = gdk.pixbuf_new_from_file("./plugins/fotoradary.png")
        self.f = []

        self.from_zoom = 13

        print "__init__ fotoradary"


    def f_rebuild(self):
        if self.from_zoom < self.osmMapa.osm.props.zoom :
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            for pa in self.f:
                lt = float(pa[0])
                ln = float(pa[1])

                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    if not pa[3]:
                        pa[3] = self.osmMapa.osm.image_add( lt, ln, self.ico_fotoradar )

                else:
                    if pa[3]:
                        self.osmMapa.osm.image_remove(pa[3])
                        pa[3] = None


    def clean_layer(self):
        for pr in self.f:
            if pr[3]:
                self.osmMapa.osm.image_remove(pr[3])
                pr[3] = None

    def killIt(self):
        self.clean_layer()

    def makeInit(self):
        self.box_old = 0,0,0,0
        f = open( self.file, "r" )
        l = 1
        while l:
            try:
                l = f.readline()
                t = l.split(",")
                if len(t) == 6 and t[0].find(".") != -1:
                    self.f.append( [float(t[1]),float(t[0]),t[3],None])
            except:
                pass
        print "fotoradary read poi xml found (",len(self.f),") POI :)"

        if self.osmMapa.osm.props.zoom>self.from_zoom:
            self.f_rebuild()


    def get_menu_widgets(self, dialog):
        return None

    def get_name(self):
        return "fotoradary"

    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>self.from_zoom:
            self.f_rebuild()
        else:
            self.clean_layer()


    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        return False

