import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import osmgpsmap
import math
import cairo


class POI:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG

        self.ico = "POI.png"

        self.osmMapa = osmMapa
        self.CONFIG = CONFIG
        self.file = "/home/user/yosmapaPOI.xml"
        self.ico_poi = gdk.pixbuf_new_from_file("./plugins/POI.png")
        self.poi = []
        self.poi_images = []
        print "__init__ POI"


    def on_bt_add(self, w, dlg,dialog):
        id = time.strftime("%Y%m%d%H%M%S", time.localtime() )
        lat = float(self.osmMapa.osm.props.latitude)
        lon = float(self.osmMapa.osm.props.longitude)
        self.poi.append([int(id),
                         self.e_name.get_text(),
                         lat,
                         lon
                        ])
        self.saveXml()
        self.poi_rebuild()
        dlg.destroy()
        dialog.destroy()

    def on_add(self, w, dialog):
        dlg = gtk.Dialog("Add POI")

        self.e_name = gtk.Entry()
        dlg.vbox.pack_start(self.e_name, True)

        bt_add = gtk.Button("Add")
        bt_add.connect("clicked", self.on_bt_add, dlg, dialog)
        dlg.vbox.pack_start(bt_add, True)


        dlg.show_all()





    def saveXml(self):
        f = open( self.file, "w")
        f.write("""<?xml version="1.0"?>
<points creator="yosmapa" version="1.0">
""")
        for p in self.poi:
            str = "    <poi lat=\"%f\" lon=\"%f\" id=\"%s\" name=\"%s\" />\n" % (float(p[2]),float(p[3]),p[0],p[1])
            f.write( str )
        f.write("""</points>"""         )
        f.close()



    def poi_rebuild(self):
        self.clean_layer()

        for pa in self.poi:            
            self.poi_images.append( self.osmMapa.osm.image_add( float(pa[2]), float(pa[3]), self.ico_poi ) )
            print "POI - > add point on map"

    def clean_layer(self):
        for pr in self.poi_images:
            self.osmMapa.osm.image_remove(pr)
        self.poi_images = []

    def killIt(self):
        self.clean_layer()

    def makeInit(self):
        try:
            self.doc = xml.dom.minidom.parse(self.file)

            for p in self.doc.getElementsByTagName("poi"):
                self.poi.append( [p.getAttribute("id"),
                                  p.getAttribute("name"),
                                  float(p.getAttribute("lat")),
                                  float(p.getAttribute("lon"))
                                ])
            print "POI read poi xml found (",len(self.poi),") POI :)"
        except:
            print "POI read poi xml file error create clean one"
            self.saveXml()


        self.poi_rebuild()

    def on_bt_delete_poi(self,w,id, dialog):
        print "delete poi id:",id
        pNew = []
        for p in self.poi:
            if p[0] <> id:
                pNew.append(p)
        self.poi = []
        self.poi = pNew
        self.poi_rebuild()
        self.on_bt_edit(None)
        self.saveXml()
        dialog.destroy()

    def on_bt_edit(self, w):
        d = hildon.Dialog()
        d.set_title("POI edit")

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        d.vbox.pack_start( panel, True,True)
        panel.set_size_request(640, 280)

        for p in self.poi:
            hbox = gtk.HBox()
            l = gtk.Label(p[1])
            hbox.pack_start(l,False)
            l = gtk.Label("")
            hbox.pack_start(l,True)
            bt = gtk.Button("del")
            bt.connect( "clicked", self.on_bt_delete_poi, p[0], d )
            hbox.pack_start(bt,False)
            mvbox.pack_start(hbox,False)

        d.show_all()
        d.run()
        d.destroy()

    def get_menu_widgets(self, dialog):
        hbox = gtk.HBox()

        bt_add = gtk.Button("Add")
        bt_add.connect("clicked", self.on_add, dialog)
        hbox.pack_start( bt_add, True)

        bt_edit = gtk.Button("Actions(%i)"%len(self.poi))
        bt_edit.connect("clicked", self.on_bt_edit )
        hbox.pack_start( bt_edit, False)

        return hbox

    def get_name(self):
        return "POI"



    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>10:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            cr = gdkdrawable.cairo_create()

            for p in self.poi:
                if t_ln < p[3] and b_ln > p[3]:
                    if t_lt > p[2] and b_lt < p[2]:
                        self.osmMapa.draw_cloud_byll( cr, p[2], p[3], p[1] )


    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        return False

