/*
 * yellownotes-applet: a maemo home applet for yellow notes
 * Copyright (C) 2007-2010 Gabriel Nava <gabriel.nava@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option); any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef YELLOWNOTES_H
#define YELLOWNOTES_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define APPLET_X_SIZE 300
#define APPLET_Y_SIZE 200
#define TOOLBAR_Y_SIZE 22

#define MIN_X_SIZE 120
#define MAX_X_SIZE 680
#define MIN_Y_SIZE 100
#define MAX_Y_SIZE 400

#define SETTINGS_PATH	".yellownotes"
#define EXISTING_NOTE	"note"
#define PREFS_FILE	"yellownotes.conf"

#define DEFAULT_COLOR		"#ffff99"
#define DEFAULT_FONT_COLOR	"#000000"
#define DEFAULT_FONT		"Sans 12"



typedef struct _YellowNotesPlugin YellowNotesPlugin;
typedef struct _YellowNotesPluginClass YellowNotesPluginClass;

#define YELLOWNOTES_TYPE_HOME_PLUGIN   (yellownotes_home_plugin_get_type ())

#define YELLOWNOTES_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN, YellowNotesHomePlugin))

#define YELLOWNOTES_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN,  YellowNotesPluginClass))

#define YELLOWNOTES_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN))
 
#define YELLOWNOTES_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN))

#define YELLOWNOTES_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
			                        YELLOWNOTES_TYPE_HOME_PLUGIN,  YellowNotesHomePluginClass))
 
struct _YellowNotesPlugin
{
	    HDHomePluginItem hitem;
};
 
struct _YellowNotesPluginClass
{
	    HDHomePluginItemClass parent_class;
};
 
GType yellownotes_plugin_get_type(void);

HD_DEFINE_PLUGIN_MODULE (YellowNotesPlugin, yellownotes_plugin, HD_TYPE_HOME_PLUGIN_ITEM);




typedef struct
{
	YellowNotesPlugin *parent;
	
	GtkWidget *frame;
	GtkWidget *align;
	GtkWidget *vbox;
	GtkWidget *hbox;

	GtkWidget *save_image;
	GtkWidget *conf_image;
	GtkWidget *delete_image;
	GtkWidget *next_image;
	GtkWidget *previous_image;
	
	GtkWidget *top;
	GtkWidget *conf_evbox;
	GtkWidget *delete_evbox;
	GtkWidget *save_evbox;
	GtkWidget *next_evbox;
	GtkWidget *previous_evbox;
	GtkWidget *label;

	GtkWidget *textview;
	GtkTextBuffer *buffer;
	GtkScrolledWindow *scrolledwindow;
	
	GtkWidget *entry_width;
	GtkWidget *entry_height;
	GdkColor color;
	GdkColor fontcolor;
	gchar *fontname;
	
	gchar *prefs_dir;
	gchar *conf_file;
	gchar *note_file;
	
	gint applet_x_size;
	gint applet_y_size;

	gint *note_number;
	gint *locked;

} YNCtx;


void save_applet_prefs(YNCtx *app);
void adjust_settings(YNCtx *app);
void load_applet_prefs(YNCtx *app);
int write_buffer_to_file(gchar *buffer,gchar *fn);
void load_note_text(YNCtx *app);
gboolean save_note_text(YNCtx *app,GtkTextBuffer *buffer);
gboolean edit_note(GObject *o,GdkEventButton *event,YNCtx *app);
gboolean lock_note(YNCtx *app);
gboolean unlock_note(YNCtx *app);
gboolean next_note(GObject *o,GdkEventButton *event,YNCtx *app);
gboolean previous_note(GObject *o,GdkEventButton *event,YNCtx *app);
gboolean erase_note(GObject *o,GdkEventButton *event,YNCtx *app);
gboolean save_note(GObject *o,GdkEventButton *event,YNCtx *app);
void select_bg_color(GObject *o, YNCtx *app);
void select_font(GObject *o, YNCtx *app);
void select_font_color(GObject *o, YNCtx *app);
void apply_preferences(YNCtx *app);
gboolean configure_applet_button(GObject *o,GdkEventButton *event,YNCtx *app);
gboolean configure_applet(GtkWidget *o,YNCtx *app);
void mkplugin_create_home_applet(YNCtx *app);
void build_ui(void);

G_END_DECLS

#endif

