#include <hildon/hildon.h>

#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "userdata.h"
#include "settings.h"

void yaspot_show_settings(userdata_t *u) {
    GtkWidget *dialog;
    GtkWidget *content_area;

    GtkWidget *cb_autoshow;
    gint autoshow;

    dialog = gtk_dialog_new();
    gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(u->main.window));
    gtk_window_set_title(GTK_WINDOW(dialog), _("Settings"));

    cb_autoshow = hildon_check_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
    gtk_button_set_label(GTK_BUTTON(cb_autoshow), _("Display Playing Queue when selecting song"));

    if (!yaspot_settings_get_autoshow_queue(&autoshow)) {
        hildon_check_button_set_active(HILDON_CHECK_BUTTON(cb_autoshow), autoshow);
    }

    content_area = gtk_dialog_get_content_area(GTK_DIALOG (dialog));

    gtk_box_pack_start(GTK_BOX(content_area),
                       cb_autoshow,
                       FALSE,
                       FALSE,
                       0);

    gtk_widget_show_all(GTK_WIDGET(dialog));
    gtk_dialog_run(GTK_DIALOG(dialog));

    autoshow = hildon_check_button_get_active(HILDON_CHECK_BUTTON(cb_autoshow));
    yaspot_settings_autoshow_queue(autoshow);

    u->settings.autoshow_queue = autoshow;

    gtk_widget_destroy(dialog);
}

// vim: expandtab

