#ifndef _FOO_USERDATA_H_FOO_
#define _FOO_USERDATA_H_FOO_

#include <hildon/hildon.h>
#include <libosso.h>
#include <dbus/dbus.h>

#include "glue.h"
#include "history.h"

/* view internals */

/* main view */
typedef struct view_main_t {
    GtkWidget *window;
    GtkWidget *button_search;
    GtkWidget *entry_search;
    GtkWidget *button_playlists;
    GtkWidget *button_reload_playlists;
    GtkWidget *button_queue;
    GtkWidget *button_history;
    GtkWidget *button_settings;
} view_main_t;

typedef struct connection_t {
    yaspot_state_t status;

} connection_t;

typedef struct settings_t {
    gint autoshow_queue;
} settings_t;

typedef struct userdata_t {
    HildonProgram *program;
    osso_context_t *osso;
    DBusConnection *dbus;

    /* views */
    view_main_t main;
    GtkWidget *login_dialog;

    /* despotify related */
    connection_t connection;
    yaspot_glue_t *session;

    /* display state */
    gboolean display_on;

    /* app-menu-stuff */
    HildonAppMenu *app_menu;
    /* buttons */
    GtkWidget *playpause;
    GtkWidget *prev;
    GtkWidget *next;
    GtkWidget *queue;

    /* history */
    yaspot_history_t *history;
    GtkWidget *history_dialog;

    /* there can be only one */
    gboolean queue_visible;

    /* settings */
    settings_t settings;

} userdata_t;

#endif

// vim: expandtab shiftwidth=4

