#include <glib.h>
/* Include the prototypes for GConf client functions. */
#include <gconf/gconf-client.h>
#include <config.h>

#include "userdata.h"
#include "settings.h"

#define YASPOT_CONF_ROOT "/apps/Maemo/" PACKAGE "/"

static gint store_string(const gchar *path, const gchar *str) {
    GConfClient *gcClient = NULL;
    gint ret = 0;

    gcClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gcClient));

    if (!gconf_client_set_string(gcClient, path, str, NULL)) {
        g_warning("failed to set %s\n", path);
        ret = -1;
    }

    g_object_unref(gcClient);

    return ret;
}

static gchar* fetch_string(const gchar *path) {
    GConfClient *gcClient = NULL;
    GConfValue *val = NULL;
    gchar *str = NULL;

    gcClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gcClient));

    val = gconf_client_get_without_default(gcClient, path, NULL);
    if (!val) {
        g_warning("key %s not found\n", path);
        goto end;
    }

    if (val->type != GCONF_VALUE_STRING) {
        g_warning("key %s is not string\n", path);
        gconf_value_free(val);
        goto end;
    }

    str = g_strdup(gconf_value_get_string(val));

end:
    if (val)
        gconf_value_free(val);
    if (gcClient)
        g_object_unref(gcClient);

    return str;
}

static gint store_int(const gchar *path, const gint num) {
    GConfClient *gcClient = NULL;
    gint ret = 0;

    gcClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gcClient));

    if (!gconf_client_set_int(gcClient, path, num, NULL)) {
        g_warning("failed to set %s\n", path);
        ret = -1;
    }

    g_object_unref(gcClient);

    return ret;
}

static gint fetch_int(const gchar *path, gint *num) {
    GConfClient *gcClient = NULL;
    GConfValue *val = NULL;
    gint ret = -1;

    gcClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gcClient));

    val = gconf_client_get_without_default(gcClient, path, NULL);
    if (!val) {
        g_warning("key %s not found\n", path);
        goto end;
    }

    if (val->type != GCONF_VALUE_INT) {
        g_warning("key %s is not gint\n", path);
        goto end;
    }

    *num = gconf_value_get_int(val);
    ret = 0;

end:
    if (val)
        gconf_value_free(val);
    if (gcClient)
        g_object_unref(gcClient);

    return ret;
}

gchar* yaspot_settings_username() {
    return fetch_string(YASPOT_CONF_ROOT "username");
}

gchar* yaspot_settings_password() {
    return fetch_string(YASPOT_CONF_ROOT "password");
}

int yaspot_settings_set_username(const gchar *username) {
    if (!username)
        return -1;
    return store_string(YASPOT_CONF_ROOT "username", username);
}

int yaspot_settings_set_password(const gchar *password) {
    if (!password)
        return -1;
    return store_string(YASPOT_CONF_ROOT "password", password);
}

int yaspot_settings_save_credentials(int *num) {
    return fetch_int(YASPOT_CONF_ROOT "save_credentials", num);
}

int yaspot_settings_set_save_credentials(int save_credentials) {
    return store_int(YASPOT_CONF_ROOT "save_credentials", save_credentials);
}

int yaspot_settings_high_bitrate(int *num) {
    return fetch_int(YASPOT_CONF_ROOT "high_bitrate", num);
}

int yaspot_settings_set_high_bitrate(int high_bitrate) {
    return store_int(YASPOT_CONF_ROOT "high_bitrate", high_bitrate);
}

/* RESTORED SETTINGS with yaspot_settings_restore */

int yaspot_settings_autoshow_queue(gint autoshow_queue) {
    return store_int(YASPOT_CONF_ROOT "autoshow_queue", autoshow_queue);
}

int yaspot_settings_get_autoshow_queue(gint *autoshow_queue) {
    return fetch_int(YASPOT_CONF_ROOT "autoshow_queue", autoshow_queue);
}

void yaspot_settings_restore(userdata_t *u) {
    gint var;

    if (!yaspot_settings_get_autoshow_queue(&var))
        u->settings.autoshow_queue = var;
}

// vim: expandtab shiftwidth=4

