#ifndef _FOO_YASPOT_HISTORY_H_FOO_
#define _FOO_YASPOT_HISTORY_H_FOO_

#include <glib.h>

enum yaspot_history_operation {
    HISTORY_SEARCH,
    HISTORY_PLAYLIST,
    HISTORY_STORED_PLAYLIST,
    HISTORY_ARTIST,
    HISTORY_ALBUM,
};
typedef enum yaspot_history_operation yaspot_history_operation;

#define YASPOT_HISTORY_LENGTH (32)

/* opaque history object */
struct yaspot_history_t;
typedef struct yaspot_history_t yaspot_history_t;

struct yaspot_history_entry_t {
    yaspot_history_operation operation;
    char *string;
    char *id;
};
typedef struct yaspot_history_entry_t yaspot_history_entry_t;

yaspot_history_t* yaspot_history_new();
void yaspot_history_add(yaspot_history_t *h, yaspot_history_operation op, const char *string, const char *id);
void yaspot_history_free(yaspot_history_t *h);
const yaspot_history_entry_t* yaspot_history_iterate(yaspot_history_t *h, void **state);

void test_history(yaspot_history_t *h);

#endif

// vim: expandtab shiftwidth=4

