#include <hildon/hildon.h>
#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "userdata.h"
#include "glue.h"
#include "app-menu.h"


void msp_playpause_cb(GtkButton *button, gpointer data) {
    userdata_t *u = (userdata_t*)data;

    if (yaspot_glue_playing(u->session))
        g_print("msp_playpause_cb: playing -> pause\n");
    else
        g_print("msp_playpause_cb: paused -> play\n");

    yaspot_glue_set_pause(u->session, yaspot_glue_playing(u->session));
}

void msp_prev_cb(GtkButton *button, gpointer data) {
    userdata_t *u = (userdata_t*)data;

    g_print("msp_prev_cb: prev\n");

    yaspot_glue_prev(u->session);
}

void msp_next_cb(GtkButton *button, gpointer data) {
    userdata_t *u = (userdata_t*)data;

    g_print("msp_next_cb: next\n");

    yaspot_glue_next(u->session);
}

static void show_queue_cb(GtkButton *button, gpointer data) {
    userdata_t *u = (userdata_t*)data;

    g_print("show queue cb\n");

    yaspot_show_queue(u);
}

static void state_cb(gboolean playing, gboolean paused, gpointer data) {
    userdata_t *u = (userdata_t*)data;
    gchar *label;

    g_print("app-menu: state_cb\n");

    if (yaspot_glue_playing(u->session))
        hildon_button_set_title(HILDON_BUTTON(u->playpause), _("Pause"));
    else
        hildon_button_set_title(HILDON_BUTTON(u->playpause), _("Play"));

    label = yaspot_glue_current_track(u->session);
    if (label) {
        hildon_button_set_value(HILDON_BUTTON(u->playpause), label);
        g_free(label);
    } else {
        hildon_button_set_value(HILDON_BUTTON(u->playpause), _("(no queue)"));
    }
}

void yaspot_app_menu_attach(userdata_t *u, HildonWindow *window) {
    if (!u->app_menu) {
        u->app_menu = HILDON_APP_MENU(hildon_app_menu_new());
        u->playpause = hildon_button_new_with_text(HILDON_SIZE_FULLSCREEN_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                                   HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                                   _("Play"),
                                                   _("(no queue)"));
        hildon_button_set_title_alignment(HILDON_BUTTON(u->playpause), 0.5, 0.2);
        hildon_button_set_value_alignment(HILDON_BUTTON(u->playpause), 0.5, 0.7);
        u->prev = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                              HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                              _("Previous"),
                                              NULL);
        u->next = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                              HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                              _("Next"),
                                              NULL);
        u->queue = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                              HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                              _("Playing Queue"),
                                              NULL);
        hildon_app_menu_append(HILDON_APP_MENU(u->app_menu), GTK_BUTTON(u->prev));
        hildon_app_menu_append(HILDON_APP_MENU(u->app_menu), GTK_BUTTON(u->next));
        hildon_app_menu_append(HILDON_APP_MENU(u->app_menu), GTK_BUTTON(u->playpause));
        hildon_app_menu_append(HILDON_APP_MENU(u->app_menu), GTK_BUTTON(u->queue));
        g_signal_connect(u->playpause, "clicked", G_CALLBACK(msp_playpause_cb), u);
        g_signal_connect(u->prev, "clicked", G_CALLBACK(msp_prev_cb), u);
        g_signal_connect(u->next, "clicked", G_CALLBACK(msp_next_cb), u);
        g_signal_connect(u->queue, "clicked", G_CALLBACK(show_queue_cb), u);

        yaspot_glue_add_state_cb(u->session, state_cb, u);
        gtk_widget_show_all(GTK_WIDGET(u->app_menu));
    }

    hildon_window_set_app_menu(window, u->app_menu);
}

void yaspot_app_menu_detach(userdata_t *u, HildonWindow *window) {
    gtk_widget_hide_all(GTK_WIDGET(u->app_menu));
}


