import QtQuick 1.0
import "scripts/videolistscripts.js" as Scripts

Item {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
    signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var results = doc.responseText.split("<a class=\"frame\" href='");
                for (var i = 1; i < results.length; i++) {
                    var r = results[i];
                    var link = "http://youjizz.com" + r.slice(0, r.indexOf("'"));
                    var title = link.slice(link.lastIndexOf("/") + 1, link.lastIndexOf("-")).replace(/-/g, " ").replace(/\b./g, function($0) { return $0.toUpperCase(); });
                    videoListModel.append({ "link": link,
                                          "title": title,
                                          "thumbnail": r.split("<img src=\"")[1].split('"')[0],
                                          "duration": r.split("#605f5f;'>")[1].split("<")[0] });
                }
                videoListModel.loading = false;
            }
        }
        doc.open("GET", feed);
        doc.send();
    }

    function getVideoUrl(index) {
        toggleBusy(true);

        var video = videoListModel.get(index);
        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                var page = request.responseText;
                var title = page.split("id=\"video_text\"><h2>")[1].split("<")[0];
                var playerUrl = page.split("\"file\",\"")[1].split('"')[0];
                video["filePath"] = playerUrl;
                toggleBusy(false);
                playVideos([video]);
            }
        }
        request.open("GET", video.link);
        request.send();
    }

    function addVideosToDownloads() {

        toggleBusy(true);

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = videoListModel.get(videoList.checkList[i])
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText;
                    var title = page.split("id=\"video_text\"><h2>")[1].split("<")[0];
                    var playerUrl = page.split("\"file\",\"")[1].split('"')[0];

                    addDownload({ "title": title,
                                "thumbnail": video.thumbnail,
                                "playerUrl": playerUrl });

                    toggleBusy(false);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
        videoList.checkList = [];
    }

    function playVideo(playerUrl) {
        Controller.playVideo(playerUrl);
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: qsTr("No videos found")
            visible: (!videoListModel.loading) && (videoList.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            footer: Item {
                id: footer

                width: videoList.width
                height: 100
                visible: videoListModel.loading
                opacity: footer.visible ? 1 : 0

                BusyDialog {
                    anchors.centerIn: footer
                    opacity: footer.opacity
                }
            }

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: ListModel {
                id: videoListModel

                property bool loading : true
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 1) && (!videoListModel.loading)) {
                    videoListModel.loading = true;
                    var split = videoFeed.lastIndexOf("-") + 1;
                    var feed = videoFeed.slice(0, split);
                    var page = parseInt(videoFeed.slice(split, videoFeed.lastIndexOf("."))) + 1;
                    setVideoFeed(feed + page + ".html");
                }
            }

            delegate: XListDelegate {
                id: delegate

                checked: Scripts.indexInCheckList(index)
                onDelegateClicked: goToVideo(videoListModel.get(index))
                onPlayClicked: getVideoUrl(index)
            }

            ScrollBar {}
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
