import QtQuick 1.0
import "videolistscripts.js" as Scripts
import "menu.js" as Menu

Rectangle {
    id: window

    property string videoFeed

    signal goToVideo(variant video)
//    signal playVideos(variant videos)

    function setVideoFeed(feed) {
        videoFeed = feed;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var results = doc.responseText.split('<a href="');
                var pattern = /movies/;
                for (var i = 1; i < results.length; i++) {
                    if (pattern.test(results[i])) {
                        var r = results[i];
                        videoListModel.append({ link: "http://xhamster.com" + r.split('"')[0],
                                              title: r.slice(r.indexOf("alt=\"") + 5, r.indexOf("\"/>")).replace("&amp;", "&"),
                                              thumbnail: r.slice(r.indexOf("src=") + 5, r.indexOf("' width")),
                                              duration: getDuration(r.slice(r.indexOf("Runtime") + 9, r.indexOf("<BR>"))) });
                    }
                }
                videoListModel.loading = false;
            }
        }
        doc.open("GET", feed);
        doc.send();
    }

    function getDuration(durationString) {
        /* Converts string to MM:SS format. */
        var a = durationString.split("m")
        var minutes = a[0];
        var seconds = a[1].slice(0, -1);
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        var duration = minutes + ":" + seconds;
        return duration;
    }

    function toggleMenu() {
        Menu.toggleMenu();
    }

    function showVideoDialog() {
        if (dialog.source == "") {
            toggleBusy(true);

            dimmer.state = "dim";
            dialog.source = "VideoListDialog.qml";
            var video = videoListModel.get(videoList.currentIndex);
            dialog.item.close.connect(Scripts.closeDialogs);
            dialog.item.infoClicked.connect(goToVideo);
            dialog.item.playClicked.connect(playVideo);
            videoList.interactive = false;
            mouseArea.enabled = true;

            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText.replace(/ /g,'');
                    video["playerUrl"] = "http://xhamster.com/flv2/" + page.split("'file':'")[1].split("'")[0];

                    toggleBusy(false);

                    dialog.item.setVideo(video);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
    }

    function addVideosToDownloads() {

        toggleBusy(true);

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = videoListModel.get(videoList.checkList[i]);
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == XMLHttpRequest.DONE) {
                    var page = request.responseText.replace(/ /g,'');
                    var playerUrl = "http://xhamster.com/flv2/" + page.split("'file':'")[1].split("'")[0];

                    addDownload({ title: video.title,
                                thumbnail: video.thumbnail,
                                playerUrl: playerUrl });

                    toggleBusy(false);
                }
            }
            request.open("GET", video.link);
            request.send();
        }
    }

    function playVideo(playerUrl) {
        Controller.playVideo(playerUrl);
    }

    color: "black"
    onStateChanged: Scripts.rotateDialogs()

    Loader {
        id: dialog

        anchors { top: window.bottom; topMargin: 10; horizontalCenter: window.horizontalCenter }
        z: 1
        onLoaded: {
            dialog.item.state = window.state;
            dialog.state = "show";
        }

        Timer {
            id: timer

            interval: 600
            onTriggered: dialog.source = ""
        }

        states: [
            State {
                name: "show"
                AnchorChanges { target: dialog; anchors { top: undefined; verticalCenter: window.verticalCenter } }
            }
        ]

        transitions: [
            Transition {
                AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
            }
        ]
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Loader {
            id: menuLoader

            property bool pencilOn : false

            z: 20
            width: dimmer.width / 2
            anchors { left: dimmer.left; bottom: dimmer.bottom; bottomMargin: 60 }

            onLoaded: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                menuLoader.item.addMenuItems([ { name: "Multi-select" } ]);
                if (menuLoader.pencilOn) {
                    menuLoader.item.addMenuItems([ { name: "Add to downloads" } ])
                }
            }

            onPencilOnChanged: {
                menuLoader.item.pencilOn = menuLoader.pencilOn;
                if (!menuLoader.pencilOn) {
                    videoList.checkList = [];
                }
            }

            Timer {
                id: menuTimer

                interval: 600
                onTriggered: menuLoader.source = ""
            }

            Connections {
                target: menuLoader.item

                onItemClicked: {
                    toggleMenu();
                    if (index == 1) {
                        addVideosToDownloads();
                    }
                    menuLoader.pencilOn = !menuLoader.pencilOn;
                }
            }
        }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: largeFontSize
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: "No videos found"
            visible: (!videoListModel.loading) && (videoList.count == 0)
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: dimmer.state == "" ? ListView.StrictlyEnforceRange : ListView.NoHighlightRange
            cacheBuffer: 1000
            maximumFlickVelocity: 1000
            interactive: visibleArea.heightRatio < 1

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: ListModel {
                id: videoListModel

                property bool loading : true
            }
            onCurrentIndexChanged: {
                if ((videoList.count - videoList.currentIndex == 15) && (!videoListModel.loading)) {
                    videoListModel.loading = true;
                    var pos = videoFeed.lastIndexOf("=") + 1;
                    var feed = videoFeed.slice(0, pos);
                    var page = parseInt(videoFeed.substr(pos)) + 1;
                    setVideoFeed(feed + page);
                }
            }

            delegate: XXXListDelegate {
                id: delegate

                function checkOrGoToVideo() {
                    if (menuLoader.pencilOn) {
                        var cl = videoList.checkList;
                        if (!delegate.checked) {
                            cl.push(index);
                        }
                        else {
                            for (var i = 0; i < cl.length; i++) {
                                if (cl[i] == index) {
                                    cl.splice(i, 1);
                                }
                            }
                        }
                        videoList.checkList = cl;
                    }
                    else {
                        goToVideo(videoListModel.get(index));
                    }
                }

                checked: Scripts.indexInCheckList(index)

                Connections {
                    onDelegateClicked: checkOrGoToVideo()
                    onDelegatePressed: {
                        videoList.currentIndex = index;
                        showVideoDialog();
                    }
                }
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
            onClicked: Scripts.closeDialogs()
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
