import simplejson
import httplib, urllib2, urllib
import sys
from os import path
import XBMCMessageClass
import types
import traceback
import unicodedata
import socket

class XBMCLib:
    
    def __init__(self, server, port, user, password):
        self.server = server
        self.port = int(port)
        self.url = "http://%s:%s" % (server,port)
        self.jsonrpcurl = self.url + '/jsonrpc'
    
    def setConnectionParameters(self, server, port, user, password):
        self.url = "http://%s:%s" % (server,port)
        self.jsonrpcurl = self.url + '/jsonrpc'    

    def call_method(self,  method,  params):
            XBMCMessageClass.XBMCMessage.clear(None)
            if params != None:
                postdata = "{\"jsonrpc\": \"2.0\", \"method\": \"%s\", \"params\": %s, \"id\": \"1\"}" % (method,params)
            else:
                postdata = simplejson.dumps({'jsonrpc': "2.0", 'method': method, 'id': "1"})
            try:
                s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                s.settimeout(6)
                s.connect((self.server, self.port))
                s.send(postdata.encode('utf8'))
                respdata = ""
                while True:
                    try:
                        dat = ""
                        dat = s.recv(1024)
                        if dat == "":
                            break
                        respdata = respdata + dat
                        if dat == "" or respdata.count("{") == respdata.count("}"):
                            r = respdata.rpartition("}")
                            respdata = r[0] + r[1]
                            XBMCMessageClass.XBMCMessage.MType = 'S'
                            XBMCMessageClass.XBMCMessage.MResult = simplejson.loads(respdata)                            
                            break
                    except socket.timeout,e:
                        XBMCMessageClass.XBMCMessage.MType = 'E'
                        XBMCMessageClass.XBMCMessage.MText = str(e)                
                        traceback.print_exc(None, None)
                        break
                s.close()

            except IOError, e:
                XBMCMessageClass.XBMCMessage.MType = 'E'
                XBMCMessageClass.XBMCMessage.MText = str(e)
                traceback.print_exc(None, None)
            except httplib.InvalidURL,e:
                XBMCMessageClass.XBMCMessage.MType = 'E'
                XBMCMessageClass.XBMCMessage.MText = str(e)    
                traceback.print_exc(None, None)
            except socket.error, e:
                print e.errno;
            except Exception, e:
                XBMCMessageClass.XBMCMessage.MType = 'E'
                XBMCMessageClass.XBMCMessage.MText = str(e)                
                traceback.print_exc(None, None)                    
                 
            return XBMCMessageClass.XBMCMessage
    
    def call_method_http(self,  method,  params):
            XBMCMessageClass.XBMCMessage.clear(None)
            if params != None:
                postdata = "{\"jsonrpc\": \"2.0\", \"method\": \"%s\", \"params\": %s, \"id\": \"1\"}" % (method,params)
            else:
                postdata = simplejson.dumps({'jsonrpc': "2.0", 'method': method, 'id': "1"})
            
            try:
                urllib.quote_plus(postdata)
                #postdata = urllib.quote(postdata)
                r = urllib2.urlopen(self.jsonrpcurl, postdata)
                respdata = r.read()
                XBMCMessageClass.XBMCMessage.MType = 'S'
                XBMCMessageClass.XBMCMessage.MResult = simplejson.loads(respdata)
            except IOError, e:
                XBMCMessageClass.XBMCMessage.MType = 'E'
                XBMCMessageClass.XBMCMessage.MText = str(e)
                traceback.print_exc(None, None)
            except httplib.InvalidURL,e:
                XBMCMessageClass.XBMCMessage.MType = 'E'
                XBMCMessageClass.XBMCMessage.MText = str(e)                
                traceback.print_exc(None, None)
                
            return XBMCMessageClass.XBMCMessage
    
    def play(self):
        res=self.call_method('AudioPlaylist.Play',None)
        #res = self.call_method_http('XBMC.Play', '{"songid": 1}')
        #print res.MResult
        return res
    
    def stop(self):
        res=self.call_method('AudioPlayer.Stop',None)
        return res

    def pause(self):
        res=self.call_method('AudioPlayer.PlayPause',None)
        return res        

    def skipNext(self):
        res=self.call_method('AudioPlaylist.SkipNext',None)
        return res        

    def skipPrevious(self):
        res=self.call_method('AudioPlaylist.SkipPrevious',None)
        return res         

    def shuffle(self):
        res=self.call_method('AudioPlaylist.Shuffle',None)
        return res         

    def unShuffle(self):
        res=self.call_method('AudioPlaylist.UnShuffle',None)
        return res     
    
    def addSong(self, file):
        res = self.call_method('AudioPlaylist.Add','{"file": "%s"}' % file)
        return res
     
    def clearPlaylist(self):
        res = self.call_method('AudioPlaylist.Clear',None)
        return res     

    def setVolume(self, number):
        res = self.call_method('XBMC.SetVolume','%i' % number)
        return res    

    def getVolume(self):
        res = self.call_method('XBMC.GetVolume', None)
        return res    

    def volumeUp(self):
        res = self.getVolume()
        if "result" in res.MResult:
            currentVolume = int(res.MResult["result"])
            if currentVolume >= 100:
                currentVolume = 100
            else:
                currentVolume = currentVolume + 1
            self.setVolume(currentVolume)

    def volumeDown(self):
        res = self.getVolume()
        if "result" in res.MResult:
            currentVolume = int(res.MResult["result"])
            if currentVolume > 0:
                currentVolume = currentVolume - 1
            else:                
                currentVolume = 0
            self.setVolume(currentVolume)
        
    def getMusicSources(self):
        res=self.call_method('Files.GetSources','{"media": "music"}')
        if res.MType == 'S':
            res.MResult = res.MResult["result"]["shares"]
        return res
    
    def getMusicSourceObjects(self, msobject):
        uc_msobject = u"%s" % msobject
        uc_msobject.encode('UTF-8','ignore')
        res = self.call_method('Files.GetDirectory', '{"directory": "%s", "media": "music", "recursive": "false"}' % uc_msobject)
        if res.MType == 'S':
            if "result" in res.MResult:
                res.MResult = res.MResult["result"]
            else:
                res.MType = 'E'
                res.MText = 'ERROR'
        return res
    
    def getPlaylistItems(self):
        res = self.call_method('AudioPlaylist.GetItems', None)
        if res.MType == 'S':
            try:
                for item in res.MResult["result"]["items"]:
                    if item["label"] == "":
                        item["label"] = path.split(item["file"])[1]
                res.MResult = res.MResult["result"]["items"]
            except KeyError, e:
                res.MType = 'E'
                res.MText = ""
        return res

    def getCurrentSong(self):
        res = self.call_method('AudioPlaylist.GetItems', None)
        if res.MType == 'S':
            try:
                if "current" in res.MResult["result"]:
                    #print res.MResult["result"]
                    res.MResult["result"]["current"]
                    res.MResult = res.MResult["result"]["current"]
                else:
                    res.MType = 'E'
                    res.MText = ""                    
            except KeyError, e:
                res.MType = 'E'
                res.MText = ""
        return res
    
    def getAudioPlayerState(self):
        res = self.call_method('AudioPlayer.State', None)
        if res.MType == 'S':
            try:
                res.MResult["result"]["playing"]
                res.MResult["result"]["paused"]
                res.MResult = res.MResult["result"]
            except KeyError, e:
                res.MType = 'E'
                res.MText = ""
        return res
    
    def getFanArt(self, track):
        res = self.call_method_http('Files.Download', '{"file:" "%s"}' % track )
        if res.MType == 'S':
            try:
                res.MResult["result"]["playing"]
                res.MResult["result"]["paused"]
                res.MResult = res.MResult["result"]
            except KeyError, e:
                res.MType = 'E'
                res.MText = ""
        return res     
    
    def downloadImage(self,url):
        image = urllib.URLopener()
        tempfile, header = image.retrieve(url, '/tmp/test.jpg')
        return tempfile      
    
    def introspect(self):
        self.setConnectionParameters(self.server, 8080, "", "")
        res = self.call_method_http('JSONRPC.Introspect', None)    
        self.setConnectionParameters(self.server, 9090, "", "")        
        print res.MResult 
        
    def getAnnoucementFlags(self):
        res = self.call_method('JSONRPC.GetAnnouncementFlags', None)
        print res.MResult
        
    def announce(self):
        res = self.call_method('JSONRPC.Announce', '{"sender": "xbmc potato", "message": "PlaybackStarted"}')
        print res.MResult
        #{'params': {'message': 'PlaybackStarted', 'sender': 'xbmc'}, 'jsonrpc': '2.0', 'method': 'Announcement'}
        