'''
Created on 4 Dec 2010

@author: yiannis
'''
import socket
import datetime
from serial import Serial
import traceback

class YamahaRXVServer(object):
    def __init__(self):
        self.myPort = 9898
        self.srvSocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(('google.com', 0))
        sockName = s.getsockname()
        myIP = sockName[0]
        self.srvSocket.bind((myIP, self.myPort))
        print "%s - Listening on %s:%s" % (datetime.datetime.now(), sockName[0], str(self.myPort))
        self.srvSocket.listen(1)
        self.run = True
        
    def start(self):
        while self.run:
            channel, details = self.srvSocket.accept()
            print '%s - Initialized connection with: %s' % (datetime.datetime.now(), details)
            rxCommand = channel.recv ( 100 )
            if rxCommand == 'STOP_SERVER':
                self.run = False
                channel.send( 'SERVER_STOP_COMMAND_RECEIVED' )
                channel.close()
            elif rxCommand == 'TEST_COMMAND':
                channel.send( 'TEST_COMMAND_RECEIVED' )
                channel.close()            
            else:
                try:
                    self.serialSend(rxCommand)
                    channel.send ( 'ACK' )
                    channel.close()
                except Exception, e:
                    print traceback.print_exc(None, None)
            self.srvSocket.close()
        print '%s - Server Closed' % datetime.datetime.now()
                
    def serialSend(self, command):
        serial = Serial(0)        
        print "%s - Sending command %s to serial port %s" % (datetime.datetime.now(), str(command), str(serial.portstr))
        serial.write(command)
                    
if __name__ == '__main__':
    yamahaServer = YamahaRXVServer()
    yamahaServer.start()