from __future__ import with_statement
import ConfigParser
import os

class XPotConfig():

    def __init__(self, qdialog):
        self.config = ConfigParser.SafeConfigParser()
        if qdialog is not None:
            self.qdialog = qdialog
        self.home = os.getenv('HOME')
        self.configFile = "%s/.xbmcpot/xpot.cfg" % self.home
        self.createInitialConfigFile()
        self.readConfig()
        
    def createInitialConfigFile(self):
        if not os.path.exists("%s/.xbmcpot" % self.home):
            print "Config Directory does not exist. Creating new config directory..."
            os.makedirs("%s/.xbmcpot" % self.home)
        if not os.path.exists(self.configFile):
            print "Config File does not exist. Creating new config file..."
            FILE = open(self.configFile, "w")
            self.config.add_section("connection")
            self.config.set("connection", "server", "")
            self.config.set("connection", "port", "8080")
            self.config.set("connection", "user", "")
            self.config.set("connection", "password", "")
            
            self.config.add_section("AVR")
            self.config.set("AVR", "server", "")
            self.config.set("AVR", "port", "9898")
            self.config.set("AVR", "source", "")
            
            self.config.add_section("features")
            self.config.set("features", "poweronavr", "False")
            self.config.set("features", "switchsourceavr", "False")
            self.config.set("features", "volumecontrol", "xbmc")
            self.config.set("features", "poweronxbmc", "False")
            self.config.set("features", "xbmcmac", "")
            self.config.set("features", "poweronxbmctimeout", "60")
            self.config.write(FILE)
        
    def readConfig(self):
        self.config.read(self.configFile)
        sectionName=""
        try:
            sectionName="'[connection] server'"
            self.server = self.config.get("connection", "server")
            
            sectionName="'[connection] port'"
            self.port = self.config.get("connection", "port")
            
            sectionName="'[connection] user'"
            self.user = self.config.get("connection", "user")
            
            sectionName="'[connection] password'"
            self.password = self.config.get("connection", "password")
            
            sectionName="'[AVR] server'"
            self.serverAVR = self.config.get("AVR", "server")
            
            sectionName="'[AVR] port'"
            self.portAVR = self.config.get("AVR", "port")
            
            sectionName="'[AVR] source'"
            self.sourceAVR = self.config.get("AVR", "source")
            
            sectionName="'[features] poweronavr'"
            self.powerOnAVR = self.config.get("features", "poweronavr")
            
            sectionName="'[features] switchsourceavr'"
            self.switchSourceAVR = self.config.get("features", "switchsourceavr")
            
            sectionName="'[features] volumecontrol'"
            self.volumeControl = self.config.get("features", "volumecontrol")
            
            sectionName="'[features] poweronxbmc'"
            self.powerOnXBMC = self.config.get("features", "poweronxbmc")   
            
            sectionName="'[features] xbmcmac'"
            self.XBMCMac = self.config.get("features", "xbmcmac")   
            
            sectionName="'[features] poweronxbmctimeout'"
            self.powerOnXBMCTimeout = self.config.get("features", "poweronxbmctimeout")                                              
          
        except ConfigParser.NoSectionError:
            print "No Section %s in file %s:" % (sectionName,self.configFile)
            
        return self
            
    def writeConfig(self):
        self.config.set('connection', "server", str(self.server))
        self.config.set('connection', "port", str(self.port))
        self.config.set('connection', "user", str(self.user))
        self.config.set('connection', "password", str(self.password))
        
        self.config.set('AVR', "server", str(self.serverAVR))
        self.config.set('AVR', "port", str(self.portAVR))
        self.config.set('AVR', "source", str(self.sourceAVR))
        
        self.config.set('features', "poweronavr", str(self.powerOnAVR))
        self.config.set('features', "switchsourceavr", str(self.switchSourceAVR))
        self.config.set('features', "volumecontrol", str(self.volumeControl))  

        self.config.set('features', "poweronxbmc", str(self.powerOnXBMC))
        self.config.set('features', "xbmcmac", str(self.XBMCMac))
        self.config.set('features', "poweronxbmctimeout", str(self.powerOnXBMCTimeout))  
                        
        with open(self.configFile, 'wb') as cfile:
            self.config.write(cfile)