#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#--------------------------------------------------------------------------------
#www2sms.py, www2sms_gui.py, www2sms_providers.py, www2sms_gui.ui v0.1b
#Copyright Bjoern Olausson
#--------------------------------------------------------------------------------
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#To view the license visit
#http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#or write to
#Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#--------------------------------------------------------------------------------
#--------------------------------------------------------------------------------
#

import os, errno, pwd, sys, math, sqlite3, time, calendar
from PyQt4 import QtCore, QtGui
from www2sms_gui import *
from www2sms_providers import *

USER = pwd.getpwuid(os.getuid())[0]
CONFIG_DIR = "/home/%s/MyDocs/www2sms" %(USER)

#List of provider we support in www2sms_providers.py
list_providers = ['o2online']

class MainWindow(QtGui.QMainWindow, Ui_MainWindow):
	def __init__(self, win_parent = None):
                #Init the base class
		QtGui.QMainWindow.__init__(self, win_parent)
		self.ui = Ui_MainWindow()
                self.ui.setupUi(self)
		# Setup GUI elements
                # Populate the available Providers
                for value in list_providers:
			self.ui.comboBox_SetupProvider.addItem(value)
		CT = time.localtime(time.time())
		# Set the year for scheduling SMS. From now to the next three years
		YEAR = CT[0]
		for YEARS in range(YEAR,YEAR + 3, 1):
		    	self.ui.comboBox_AdvancedScheduleStartYear.addItem(str(YEARS))
			self.ui.comboBox_AdvancedScheduleStopYear.addItem(str(YEARS))
		# Try to update the GUI to the last used Account, else skip this
                try:
			PROVIDER, ALIAS, LOGIN, PASSWORD = c.execute('SELECT provider, alias, login, password FROM login WHERE last=1').fetchall()[0]
			# Populate all Acounts
			ACCOUNTS = c.execute('SELECT alias FROM login').fetchall()
			for a in ACCOUNTS:
				self.ui.comboBox_SetupAlias.addItem(a[0])
			# Update the GUI
			# Updating the the Provider ComboBox
			provider_index = self.ui.comboBox_SetupProvider.findText(PROVIDER)
			self.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
			# Updating the the Alias ComboBox
			alias_index = self.ui.comboBox_SetupAlias.findText(ALIAS)
			self.ui.comboBox_SetupAlias.setCurrentIndex(alias_index)
			# Updating the lineEdit Alias
			self.ui.lineEdit_SetupNewAlias.setText(ALIAS)
			# Updating the lineEdit Login
			self.ui.lineEdit_SetupLogin.setText(LOGIN)
			# Updating the lineEdit Pasword
			#PASSWORD = base64.b64decode(PASSWORD)
			self.ui.lineEdit_SetupPassword.setText(PASSWORD)
		except IndexError:
			pass

		# Conect to some buttons and make them execute a method of the class MainWindow
		QtCore.QObject.connect(self.ui.pushButton_Send, QtCore.SIGNAL("clicked()"), self.on_send_clicked)
		QtCore.QObject.connect(self.ui.pushButton_SetupSave, QtCore.SIGNAL("clicked()"), self.on_SetupSave_clicked)
		QtCore.QObject.connect(self.ui.plainTextEdit_SMS, QtCore.SIGNAL("textChanged()"), self.UpdateChars)
		QtCore.QObject.connect(self.ui.comboBox_SetupAlias, QtCore.SIGNAL("activated(QString)"), self.on_SetupAlias_activated)
		QtCore.QObject.connect(self.ui.pushButton_SetupDelete, QtCore.SIGNAL("clicked()"), self.on_SetupDelete_clicked)
		QtCore.QObject.connect(self.ui.pushButton_SetupDelete, QtCore.SIGNAL("clicked()"), self.on_SetupDelete_clicked)
		QtCore.QObject.connect(self.ui.comboBox_AdvancedScheduleStartMonth, QtCore.SIGNAL("activated(QString)"), self.on_StartDate_changed)
		QtCore.QObject.connect(self.ui.comboBox_AdvancedScheduleStopMonth, QtCore.SIGNAL("activated(QString)"), self.on_StopDate_changed)
		QtCore.QObject.connect(self.ui.comboBox_AdvancedScheduleStartYear, QtCore.SIGNAL("activated(QString)"), self.on_StartDate_changed)
		QtCore.QObject.connect(self.ui.comboBox_AdvancedScheduleStopYear, QtCore.SIGNAL("activated(QString)"), self.on_StopDate_changed)

	# Class which is called to get the propper number of days for the schedule start date
	def on_StartDate_changed(self):
		cal = calendar.Calendar()
		sYEAR = int(self.ui.comboBox_AdvancedScheduleStartYear.currentText())
		sMONTH = int(self.ui.comboBox_AdvancedScheduleStartMonth.currentText())
		self.ui.comboBox_AdvancedScheduleStartDay.clear()
		for DAY in cal.itermonthdays(sYEAR, sMONTH):
			if DAY != 00:
				DAY = '%02d' %(DAY)
				self.ui.comboBox_AdvancedScheduleStartDay.addItem(str(DAY))

	# Class which is called to get the propper number of days for the schedule stop date
	def on_StopDate_changed(self):
		cal = calendar.Calendar()
		sYEAR = int(self.ui.comboBox_AdvancedScheduleStopYear.currentText())
		sMONTH = int(self.ui.comboBox_AdvancedScheduleStopMonth.currentText())
		self.ui.comboBox_AdvancedScheduleStopDay.clear()
		for DAY in cal.itermonthdays(sYEAR, sMONTH):
			if DAY != 00:
				DAY = '%02d' %(DAY)
				self.ui.comboBox_AdvancedScheduleStopDay.addItem(str(DAY))

	# Class which is called to get the number of characters typed in plainTextEdit_SMS and update lcdNumber_SMSChars
	def UpdateChars(self):
		SMS_CHARS = self.ui.plainTextEdit_SMS.document().characterCount() - 1
		self.ui.label_SMSChars.setText(str(SMS_CHARS))
		# Might be better. Floor to Ceiling division: -(-x//y)
		SMS_COUNT = int(math.ceil(SMS_CHARS / 160) + 1)
		self.ui.label_SMSCount.setText(str(SMS_COUNT))

	# Class which ubdates the GUI to the Account selected in comboBox_SetupAlias
	def on_SetupAlias_activated(self):
		# Get the selected Account
		ALIAS = unicode(self.ui.comboBox_SetupAlias.currentText())
		# Read the settings for the selected Account fom DB
		try:
			PROVIDER, ALIAS, LOGIN, PASSWORD = c.execute('SELECT provider, alias, login, password FROM login WHERE alias=?', (ALIAS,)).fetchall()[0]
		except IndexError:
			pass
		# Update the GUI elements
		provider_index = self.ui.comboBox_SetupProvider.findText(PROVIDER)
		self.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
		self.ui.lineEdit_SetupNewAlias.setText(ALIAS)
		self.ui.lineEdit_SetupLogin.setText(LOGIN)
		self.ui.lineEdit_SetupPassword.setText(PASSWORD)
		# Remove the last account flag to set it on the new/updated profile
		c.execute('UPDATE login SET last=0 WHERE last=1')
		# Set the last flag on the new Account
		c.execute('UPDATE login SET last=1 WHERE alias=?',(ALIAS,))
		conn.commit()

	# Well, this is obvious, isn't it? Okay, it deletes the current selected account.
	def on_SetupDelete_clicked(self):
		# Get the current selected Account
		ALIAS = unicode(self.ui.comboBox_SetupAlias.currentText())
		# Delet it form the DB
		c.execute('DELETE FROM login WHERE alias=?', (ALIAS,))
		conn.commit()
		# Remove the Account from comboBox_SetupAlias
		alias_index = self.ui.comboBox_SetupAlias.findText(ALIAS)
		self.ui.comboBox_SetupAlias.removeItem(alias_index)
		# Check if there is something left in the DB
		ROWS = c.execute('SELECT alias FROM login').rowcount
		# Update the GUI elements
		if ROWS == -1:
			self.ui.lineEdit_SetupNewAlias.clear()
			self.ui.lineEdit_SetupLogin.clear()
			self.ui.lineEdit_SetupPassword.clear()
		else:
			self.on_SetupAlias_activated()
		QtGui.QMessageBox.information(self, 'www2sms', "Account %s deleted" %(ALIAS))

	# Class which is called, when an account is created/updated
	def on_SetupSave_clicked(self):
		# Gather Account information
		PROVIDER = unicode(self.ui.comboBox_SetupProvider.currentText())
		ALIAS = unicode(self.ui.lineEdit_SetupNewAlias.text())
		LOGIN = unicode(self.ui.lineEdit_SetupLogin.text())
		PASSWORD = unicode(self.ui.lineEdit_SetupPassword.text())
		# Remove the last account flag to set it on the new/updated profile
		c.execute('UPDATE login SET last=0 WHERE last=1')
		# Check if Account exist, if it exists, we update the content in the DB on save, else we add it
		EXIST = c.execute('select alias FROM login WHERE alias=?', (ALIAS,)).fetchall()
		if len(EXIST) != 0:
		    c.execute('UPDATE login SET provider=?, login=?, password=?, last=1 WHERE alias=?', (PROVIDER, LOGIN, PASSWORD, ALIAS))
		else:
		    c.execute('INSERT INTO login VALUES (NULL, ?, ?, ?, ?, 1)', (PROVIDER, ALIAS, LOGIN, PASSWORD))
		    # Add the new Account to comboBox_SetupAlias
		    self.ui.comboBox_SetupAlias.addItem(ALIAS)
		conn.commit()
		# Let the user know that we have saved the the account/changes
		QtGui.QMessageBox.information(self, 'www2sms', "saved")
		# Update the GUI
		alias_index = self.ui.comboBox_SetupAlias.findText(ALIAS)
		self.ui.comboBox_SetupAlias.setCurrentIndex(alias_index)
		provider_index = self.ui.comboBox_SetupProvider.findText(PROVIDER)
		self.ui.comboBox_SetupProvider.setCurrentIndex(provider_index)
		self.ui.lineEdit_SetupLogin.setText(LOGIN)
		self.ui.lineEdit_SetupPassword.setText(PASSWORD)

	# Class which is called when we want to send the sms. It actually calls a method on the providers class
	def on_send_clicked(self):
		self.ui.pushButton_Send.setText("Sending...")
		# Really ready to send?
		reply = QtGui.QMessageBox.question(self, 'Send SMS?', "Are you sure?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		# If reply is YES, we send the SMS, else we just do nothing
		if reply == QtGui.QMessageBox.Yes:
		    	# Read Scheduling settings if activated

			SCHEDULE = []
			if self.ui.radioButton_AdvancedScheduleRepeat.isChecked():
				# SCHEDULE Layout: ([RECURRENCY, STOPTrueFalse], [YEARstart, YEARstop], [MONTHstart, MONTHstop], [DAYstart, DAYstop], [HOUREstart, HOUREstop], [MINUTEstart, MINUTEstop])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedRecurrence.currentText()), self.ui.radioButton_AdvancedScheduleStop.isChecked() ])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedScheduleStartYear.currentText()), str(self.ui.comboBox_AdvancedScheduleStopYear.currentText()) ])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedScheduleStartMonth.currentText()), str(self.ui.comboBox_AdvancedScheduleStopMonth.currentText()) ])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedScheduleStartDay.currentText()), str(self.ui.comboBox_AdvancedScheduleStopDay.currentText()) ])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedScheduleStartHoure.currentText()), str(self.ui.comboBox_AdvancedScheduleStopHoure.currentText()) ])
				SCHEDULE.append([ str(self.ui.comboBox_AdvancedScheduleStartMinute.currentText()), str(self.ui.comboBox_AdvancedScheduleStopMinute.currentText()) ])
			else:
				SCHEDULE = False

			# Read Sender
			if self.ui.radioButton_AdvancedMyMobileNumber.isChecked():
				SENDER = "MyNumber"
			elif self.ui.radioButton_AdvancedAnonym.isChecked():
				SENDER = "Anonym"
			elif self.ui.radioButton_AdvancedText.isChecked():
				SENDER = self.ui.lineEdit_AdvancedText.text()

			# Read Special
			FLASH = self.ui.radioButton_AdvancedFlashSMS.isChecked()

			# Read the login
			LOGIN = unicode(self.ui.lineEdit_SetupLogin.text())
			# Read the password
			PASSWORD = unicode(self.ui.lineEdit_SetupPassword.text())
			# Read the number to which we send the SMS
			NUMBER = unicode(self.ui.lineEdit_Number.text())
			# Read the text we want to send
			SMSTEXT = unicode(self.ui.plainTextEdit_SMS.toPlainText())
			# Read the provider to use
			PROVIDER = unicode(self.ui.comboBox_SetupProvider.currentText())
			# Instanziate the providers class
			send_SMS = providers()
			# Call the method PROVIDER from the providers class and pass the number and text to send.
			STATUS, MSG = getattr(send_SMS, PROVIDER)(NUMBER, SMSTEXT, LOGIN, PASSWORD, SCHEDULE, SENDER, FLASH)
			if STATUS:
				self.on_send_success(MSG)
			else:
				self.on_send_failed(MSG)
		self.ui.pushButton_Send.setText("Send")

	# Class wich is called from providers class when the sms was successfully send
	def on_send_success(self,MSG):
		QtGui.QMessageBox.information(self, 'www2sms', MSG)
		self.ui.lineEdit_Number.clear()
		self.ui.plainTextEdit_SMS.clear()

	# Class wich is called from providers class when the sms failed to send
	def on_send_failed(self,MSG):
		QtGui.QMessageBox.warning(self, 'www2sms', MSG)

def mk_db():
    try:
	os.makedirs(CONFIG_DIR, 0755)
    except OSError, e:
	# Pass if the directory exist, else raise a exception
	if e.errno == errno.EEXIST:
	    pass
	else:
	    raise Exception("Failed to create %s. (%s, %s)" %(CONFIG_DIR, errno, strerror))
	# Chanke to the config dir.
	os.chdir(CONFIG_DIR)
	conn = sqlite3.connect('www2sms.db')
	c = conn.cursor()
	# Create Database
	try:
	    c.execute('''create table login (id INTEGER PRIMARY KEY, provider TEXT, alias TEXT UNIQUE, login TEXT, password TEXT, last INTEGER)''')
	    #c.execute('''create table o2online (id INTEGER PRIMARY KEY, provider TEXT, alias TEXT UNIQUE)''')
	    conn.commit()
	except sqlite3.OperationalError:
	    pass
	c.close()
	conn.close()

# Connect to DB
mk_db()
conn = sqlite3.connect('www2sms.db')
c = conn.cursor()

if __name__ == "__main__":
	# Someone is launching this directly
	# Create the QApplication
	app = QtGui.QApplication(sys.argv)
	#The Main window
	ui = MainWindow()
	ui.show()
	# Enter the main loop
	app.exec_()
