/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTGLOBAL_H__
#define __WRTGLOBAL_H__

namespace WRT {

    enum WebKitView {
        WebView = 0x10,
        GraphicsWebView = 0x20
    };

   namespace JSApi {
      enum WidgetJavaScriptApi  {
          Menu = 0x001,
             ContextMenu = 0x002,
             MenuItem = 0x004,
             WidgetInterface = 0x008,
             Device = 0x010,
             JilServiceLoader = 0x020,
             Version = 0x40,
             W3C = Menu | ContextMenu | MenuItem | WidgetInterface | Device | Version,
             Plain = Menu | ContextMenu | MenuItem | Device  | Version,
             JIL = W3C | JilServiceLoader
      };
   }
}

#endif // __WRTGLOBAL_H__

