/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _WGT_WIDGET_H_
#define _WGT_WIDGET_H_

#include "SuperWidget.h"
#include "featuremapping.h"
#include "secsession.h"


#define BACKUP_RESTORE_UID 0x20026FF5
#if defined(Q_OS_MAEMO5) || defined(Q_OS_MAEMO6)
namespace WRT{
   namespace Maemo{
       class WebWidget;
   }
}
#endif

/*****************************************************************************
 * Wgt specific widget
 *
 * *************************************************************************/
class WgtWidget : public SuperWidget
{
public:
    WgtWidget(QString& rootDirectory);
    virtual ~WgtWidget() {};

    // TODO : Code of these two are almost equal. Should be fixed.
    virtual WidgetInstallError install(const bool update = false);
    virtual WidgetInstallError install(const QString& sigId, const bool update = false);
    virtual WidgetProperties* getProperties(const QString& pkgPath){return SuperWidget::getProperties(pkgPath);};
    virtual QString launcherPath(const QString &pkgPath);

#if !defined(Q_OS_MAEMO6) && !defined(Q_OS_MAEMO5)
    SuperWidget* toWgz();
#endif

    virtual void writeManifest(const QString& path="");

    virtual QString value(const QString& key, const QString & attribute = QString(""));

    /**
     * Returns true if the key with the attribute exists in w3c widget config; otherwise false.
     * @param key the config.xml element name
     * @attribute the attribute is an optional argument. With attribute you can test whether a value
     * of given attribute within specified key exists in config.xml element.
     */
    bool contains( const QString & key, const QString & attribute = QString(""));
    virtual bool unZipBundle(const QString& path){return SuperWidget::unZipBundle(path);};
    virtual bool parseManifest(const QString& path="",const bool force=false);
    virtual void disableBackupRestoreValidation(bool disableUnsignWidgetSignCheck);

protected :
    virtual void initialize(QString& rootDirectory) {SuperWidget::initialize(rootDirectory);};
    virtual WidgetProperties* widgetProperties();
    virtual bool findDigitalSignatures( QStringList& digSig, WidgetInstallError & error, const QString& path="");
    virtual bool validateDigitalSignatures(QStringList& sigList, WidgetInstallError & error, const QString& widgetPath = "", bool cleanup=false);
    virtual bool findStartFile(QString& startFile, const QString& widgetPath="");
    virtual bool findIcons(QStringList& icons, const QString& widgetPath="");
    virtual bool findFeatures(WidgetFeatures& features, const QString& widgetPath="");
    virtual bool isFeatureAllowed(WidgetFeatures& features, WRT::SecSession* secureSession, bool runtime = false);
    virtual bool createSecuritySession(WRT::SecSession** secureSession, QString& trustDomain,const QString& sigId="", bool runtime = false);
    bool getCertificateAKI(QString& aki);
    QString getTrustDomain();

private :
    bool isDirectionValid(QString AttributeValue);
#ifdef Q_OS_SYMBIAN
    void updatePaths(const QString& domainNameUid);
    QString getProcUid(const QString& domain) const;
    void restartNotificationL();
#endif
private:
    bool m_disableUnsignWidgetSignCheck;
    QString m_validCertificateAKI;
    FeatureMapping m_mapping;
    //friend class declaration starts here
    friend class WgtWidgetTest;

#if defined(Q_OS_MAEMO5) || defined(Q_OS_MAEMO6)
   friend class WRT::Maemo::WebWidget;
#endif

};
#endif
