/**
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WRTAPIPROVIDER_HH
#define WRTAPIPROVIDER_HH

#include <QStringList>

#include "serviceprovider.h"
#include "serviceloader.h"
#include "wrtapiinterface.h"

namespace WRT {

    class ServiceLoader;

    class WrtApiProviderPrivate
    {

    public:
        WrtApiProviderPrivate();
        ~WrtApiProviderPrivate();

    public:
        WRT::ServiceLoader* m_serviceLoader;
        QStringList m_apiNames;
        QMap<QString, WrtApiInterface*> m_apis;
    };


    class Q_DECL_EXPORT WrtApiProvider : public QObject, public WRT::ServiceProvider {
        Q_OBJECT
    public:
        /** Constructor
         */
        explicit WrtApiProvider();

        /** Destructor
         */
        virtual ~WrtApiProvider();

        /** Creates WRT API objects based on configuration file
         *  wrtapiconf.h. Exposes objects to JavaScript if their
         *  reimplementation of WrtWpiInterface:name() returns a non-empty
         *  string.
         *  @param loader Loader to be used for accessing QWebPage.
         */
        void handleNewInstance(WRT::ServiceLoader* loader);

        /** Deletes all WRT APIs
         *  @param loader Loader to be used for accessing QWebPage.
         */
        void destroyInstance(WRT::ServiceLoader* loader);

        /** Sets the APIs to be loaded.
         *  @param apis List of API names to be loaded. API names are defined
         *         in wrtapiconf.h.
         */
        void setApis(QStringList apis);

        /** Returns the API object based on API name.
         *  @param name API name defined in wrtapiconf.h. Returns 0, if
         *         name was not configured to be instantiated and taken into
         *         use in wrtapiconf.h (i.e. was not in wrtApiList).
         */
        WrtApiInterface* apiObject(QString name);

    public Q_SLOTS:
        /** Calls WrtWpiInterface::pageOnReload for each WRT API.
         */
        virtual void pageOnReload();


    private:
        WrtApiProviderPrivate* d;
    };

}
#endif /* WRTAPIPROVIDER_HH */



