/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __WRTAPIMANAGER_P_H__
#define __WRTAPIMANAGER_P_H__
#include <QObject>
#include "wrtglobal.h"

namespace WRT{

class WrtApiProvider;
class ServiceLoader;
class WrtPage;

class WrtApiManagerPrivate : public QObject
{
    Q_OBJECT
public:
    WrtApiManagerPrivate();
    ~WrtApiManagerPrivate();

public:
    QString getApiList(JSApi::WidgetJavaScriptApi);
    WrtApiProvider* m_wrtApiProvider;
    WRT::ServiceLoader* m_serviceLoader;
    WRT::WrtPage* m_wrtPage;

};

}

#endif
