/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "wrtapimanager_p.h"
#include "wrtpage.h"
#include "wrtapimanager.h"
#include "wrtapiconf.h"
#include "wrtapiprovider.h"
#include "serviceloader.h"
namespace WRT {

WrtApiManagerPrivate::WrtApiManagerPrivate() :
    m_wrtApiProvider(0),
    m_serviceLoader(0) {
}


WrtApiManagerPrivate::~WrtApiManagerPrivate() {

    if (m_wrtApiProvider) {
        delete m_wrtApiProvider;
    }
    if (m_serviceLoader) {
        delete m_serviceLoader;
    }
}

QString WrtApiManagerPrivate::getApiList(JSApi::WidgetJavaScriptApi list){
    QString final;

    // Evaluate CJSE device.js as a first JavaScript file
    if ((list & JSApi::Device) && wrtApiList.contains(DeviceJsFile)){
        final += DeviceJsFile;
        final += DELIM;
    }

    // Evaluate common JavaScript utils before evaluating any other WRT API.
    final += "utils.js";
    final += DELIM;

    if ((list & JSApi::MenuItem) && wrtApiList.contains(MenuItem)){
        final += MenuItem;
        final += DELIM;
    }

    if ((list & JSApi::Menu) && wrtApiList.contains(Menu)){
        final += Menu;
        final += DELIM;
    }

    if ((list & JSApi::ContextMenu) && wrtApiList.contains(ContextMenu)){
        final += ContextMenu;
        final += DELIM;
    }

    if ((list & JSApi::WidgetInterface) && wrtApiList.contains(WidgetInterface)){
        final += WidgetInterface;
        final += DELIM;
    }

    if ((list & JSApi::JilServiceLoader) && wrtApiList.contains(JilServiceLoaderFile)){
        final += JilServiceLoaderFile;
        final += DELIM;
    }

    if ((list & JSApi::Version) && wrtApiList.contains(Version)){
        final += Version;
        final += DELIM;
    }

    return final.simplified();
}

}
