/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WRTAPIINTERFACE_H
#define WRTAPIINTERFACE_H

class QWebPage;

namespace WRT {

   /** Base class for all the WRT APIs.
    */

    class WrtApiInterface {
        public:

        /** Sets the QWebPage. It can later use e.g for evaluating JavaScript.
         *
         *  @param page Web page.
         */
        virtual void setWebPage(QWebPage* page) = 0;

        /** Gets the name used when exposing objects to JavaScript.
         *
         *  @return The JS name of the API. E.g if name of the API is "menu",
         *          in JS public slots of the class implementing this interface
         *          are invoked by calling "menu.<public slot name>"
         *          If this function returns empty string, the object is not
         *          exposed to JS at all.
         */
        virtual QString name() const = 0;


        /** This function gets called when the page is being reloeaded
         *  and the object is being newly added to page as javascript object.
         *  This function should evaluate all JavaScript files required by
         *  the API (QWebPage::currentFrame().evaluateJavaScript(script))
         */
        virtual void pageOnReload() = 0;

    };
}


#endif
