/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WRTAPICONF_H
#define WRTAPICONF_H

#include <QStringList>
#include "wrtglobal.h"

/** This is a configuration file for defining which WRT APIs are loaded
 *  by WrtApiManager. When adding a new API you need to define the name
 *  of the API as const QString and add that name to wrtApiList.
 *  Then add the new class to WrtApiProvider::handleNewInstance WRT API
 *  factory.
 */


namespace WRT {

    const QString DELIM(" ");

    // C++ Objects
    const QString MenuItem("JSMenuItem");
    const QString Menu("JSMenu");
    const QString ContextMenu("JSContextMenu");

    // JavaScript resources
    const QString WidgetInterface("JSWidgetInterface");

    // Version information
    const QString Version("JSVersion");

    // CJSE APIs

    const QString DeviceJsFile("nokia/device/device.js");

    // Misc
    const QString JilServiceLoaderFile("jilserviceloader.js");

    /** wrtApiList is a QString containing all WRT API names separated
     *  by space. The order of APIs defines the load order. This should
     *  be taken into account, if there are dependencies between APIs.
     *  For example, MenuItem must always be before Menu and ContextMenu.
     *
     * NOTE! If you add more apis, also add new enum to wrtglobal.h and update
     * wrtapimanager's getApiList() accordingly
     */
#if defined(Q_OS_MAEMO5) || defined(Q_OS_MAEMO6)
    const QString wrtApiList =
            MenuItem + DELIM + Menu + DELIM + ContextMenu + DELIM + WidgetInterface + DELIM + DeviceJsFile + DELIM + JilServiceLoaderFile + DELIM + Version;
#else
    const QString wrtApiList;
#endif


}



#endif
