/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef JS_RESOURCE_WRAPPER_H_
#define JS_RESOURCE_WRAPPER_H_

#include <QObject>
#include <QString>

#include "wrtapiinterface.h"

class QWebPage;

namespace WRT {

class JSResourceWrapperPrivate;

class JSResourceWrapper: public QObject, public WrtApiInterface {
    Q_OBJECT

public:

enum JavaScriptHandling {
    EvalauteJavaScript,
    DontEvalauteJavaScript
};

    explicit JSResourceWrapper(QString jsResourceFile, QString jsObjectName, JavaScriptHandling javaScriptHandling = EvalauteJavaScript);
    virtual ~JSResourceWrapper();

    virtual void setWebPage(QWebPage* page);
    virtual QString name() const;
    virtual void pageOnReload();
    virtual void beforeJavaScriptEvaluation();

public Q_SLOTS:
    virtual QString toSource();

 Q_SIGNALS:
    void loadFinished();

protected:
    QWebPage * webPage();
    bool isLoading();

private Q_SLOTS:
    void loadStarted();
    void loadFinished(bool ok);

private:
    JSResourceWrapperPrivate * d;

};

}

#endif /* JS_RESOURCE_WRAPPER_H_ */
