/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef ACTIONADAPTER_H
#define ACTIONADAPTER_H

#include <QList>
#include <QObject>

#include "action.h"

class QWidget;
class QGraphicsWidget;
class QSignalMapper;
class ActionAdapterTest;
class JSContextMenuTest;
class JSMenuTest;

namespace WRT {

class Action;
class JSMenu;
class JSViewMenu;
class JSContextMenu;

namespace Maemo {
    class WebAppRunner;
}

class ActionAdapter : public QObject
{
    Q_OBJECT
private:

    explicit ActionAdapter(QGraphicsWidget* widget);
    ActionAdapter(QWidget* widget);
    ~ActionAdapter();

    QList<Action*> actions(Action::Location location) const;
    void addAction(Action* action);
    void insertAction(Action* action, Action* insertBefore);
    void removeAction(Action* action);
    void removeActions(QList<Action*> actions);
    void addActions(QList<Action*> actions);
    QSignalMapper* signalMapper() const;
    void gatherActions(QList<QAction*>& actions, QAction* action) const;
    void addActionMappings(Action* action);

private slots:
#if !defined(SUPPORT_ONLY_FLAT_MENUS)
    void updateSubActions();
    void removeSubActions();
#endif

private:
    QWidget* m_widget;
    QGraphicsWidget* m_graphicsWidget;
    QSignalMapper* m_actionMapper;

    friend class JSMenu;
    friend class JSViewMenu;
    friend class JSContextMenu;
    friend class WRT::Maemo::WebAppRunner;
    friend class ::ActionAdapterTest;
    friend class ::JSContextMenuTest;
    friend class ::JSMenuTest;
};

}

#endif // ACTIONADAPTER_H
