/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QMenu>

#include "action.h"

namespace WRT {

Action::Action(QObject * parent)
#ifdef Q_OS_MAEMO6
    : MAction(parent)
#else
    : QAction(parent)
#endif
    , m_id(-1)
    , m_location(UnKnown)
    , m_subAction(0)
{
}

Action::Action(const QString & text, QObject * parent)
#ifdef Q_OS_MAEMO6
    : MAction(text, parent)
#else
    : QAction(text, parent)
#endif
    , m_id(-1)
    , m_location(UnKnown)
    , m_subAction(0)
{
}

Action::~Action() {
}

void Action::setId(int id) {
    m_id = id;
}

int Action::id() {
    return m_id;
}

void Action::setLocation(Location location) {
    m_location = location;

#ifdef Q_OS_MAEMO6
    if (location == ViewMenuLocation) {
        MAction::setLocation(MAction::ApplicationMenuLocation);
    } else if (location == ContextMenuLocation) {
        MAction::setLocation(MAction::ObjectMenuLocation);
    } else if (location == ToolBarLocation) {
        MAction::setLocation(MAction::ToolBarLocation);
    }
#endif
}
WRT::Action::Location Action::location() {
    return m_location;
}

#if !defined(SUPPORT_ONLY_FLAT_MENUS)
void Action::addSubAction(Action* action) {
    if (!m_subAction) {
        m_subAction = new QMenu();
        setMenu(m_subAction);
    }

    m_subAction->addAction(action);
    emit subActionsAdded();
}

void Action::removeSubAction(Action* action) {
    if (m_subAction) {
        m_subAction->removeAction(action);
        if (m_subAction->isEmpty()) {
            delete m_subAction;
            m_subAction = 0;
            setMenu(m_subAction);
        }
    }
    emit subActionsRemoved();
}

void Action::insertSubAction(Action* action, int beforeIndex) {
    if (!m_subAction) {
        m_subAction = new QMenu();
        setMenu(m_subAction);
    }

    QList<QAction*> actionList = m_subAction->actions();
    if (beforeIndex >= 0 && beforeIndex < actionList.length()) {
        QAction* beforeItem = actionList.at(beforeIndex);
        m_subAction->insertAction(beforeItem, action);
    } else {
        m_subAction->addAction(action);
    }
    emit subActionsAdded();
}
#endif

QList<QAction*> Action::subActions() const {
#if defined(SUPPORT_ONLY_FLAT_MENUS)
    return QList<QAction*>();
#else
    if (m_subAction) {
        return m_subAction->actions();
    } else {
        return QList<QAction*>();
    }
#endif
}


}
