/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "w3cjswidget.h"
#include "wgtjswidget.h"
#include "wrtwidgetcontainer.h"
#include <QDebug>

using namespace WRT;

WgtJSWidget::WgtJSWidget(WidgetContainer* wrtWidgetContainer) :
    W3CJSWidget(wrtWidgetContainer)
{
}

WgtJSWidget::~WgtJSWidget ()
{
}

void WgtJSWidget::notificationRecieved(WidgetContainer::WrtWidgetNotify value)
{

 switch (value) {
     case WidgetContainer::WrtWidgetToForeGround:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onWakeup) != 'undefined') && (widget.onWakeup != null)){widget.onWakeup();}");
         break;

     case WidgetContainer::WrtWidgetFocusIn:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onFocus) != 'undefined') && (widget.onFocus != null)){widget.onFocus();}");

         // Do the W3CJSWidget action for focus in, as well
         W3CJSWidget::notificationRecieved(value);
         break;

#if defined(Q_OS_SYMBIAN)
     case WidgetContainer::WrtWidgetToFullscreen:
         widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onMaximize) != 'undefined') && (widget.onMaximize != null)){widget.onMaximize();}");
         break;
#endif

#if 0
     case WidgetContainer::WrtWidgetOnRestore:
         //TO BE DONE
      break;
#endif

     default:
         W3CJSWidget::notificationRecieved(value);
         break;
 }
}

QVariant WgtJSWidget::preferenceForKey(const QVariant& key)
{
    return SuperJSWidget::preferenceForKey(key);
}

void WgtJSWidget::setPreferenceForKey(const QVariant& value, const QVariant& key)
{
    SuperJSWidget::setPreferenceForKey( value , key);
}

void WgtJSWidget::prepareForTransition(const QString& mode)
{
   widgetContainer()->setTransitionMode( mode );
}

void WgtJSWidget::performTransition()
{
    widgetContainer()->performTransition();
}

void WgtJSWidget::setNavigationEnabled(bool flag)
{
    // if set tabbed navigation: if meta tag navigation is created, update its value
    // else, create the meta tag
    // if unset tabbed navigation: remove the meta tag navigation is it exists
    QString script;
    if (flag) {
        script = "var m = document.getElementsByTagName('meta'); \
            for (var i in m) { \
                if (m[i].name=='navigation') { \
                    var head = document.getElementsByTagName('head')[0]; \
                    head.removeChild(m[i]); \
                    break; \
                } \
            }";
    } else {
        script = "var found = false; \
            var m = document.getElementsByTagName('meta'); \
            for (var i in m) { \
                if (m[i].name=='navigation') { \
                    m[i].content = 'tabbed'; \
                    found = true; \
                    break; \
                } \
            } \
            if (!found) { \
                var head = document.getElementsByTagName('head')[0]; \
                var meta = document.createElement('meta'); \
                meta.name = 'navigation'; \
                meta.content = 'tabbed'; \
                head.appendChild(meta); \
            }";
    }

    qDebug() << "tab script:" << script;
    widgetContainer()->evaluateJavaScript(script);
}

void WgtJSWidget::setNavigationType(QString type)
{
    qDebug() << "setNavigationType: " << type;
/*
    if (type.startsWith("cursor"))
    else if (type.startsWith("tabbed"))
    else if (type.startsWith("none"))
*/
}

void WgtJSWidget::openApplication(QString uid)
{
    qDebug() << "openApplication: " << uid;
    widgetContainer()->openApplication(uid);
}

QString WgtJSWidget::identifier() const
{
    return SuperJSWidget::identifier();
}
